/* 半角数字チェック */
function NumberCheck(item, str, len) {
	if(str.length == 0){
		return item + "が未入力です。\n";
	}else if(str.length > len){
		return item + "は、"+len+"文字以下で入力して下さい。["+str+"]\n";
	}
	for(var i=0 ; i<str.length; i++){
		var code=str.charCodeAt(i);
		if ((48<=code && code<=57) || str.substr(i,1)=='.') {
            /* 半角数字許容 */
		}else{
			return item + "は、半角数字のみで入力して下さい。["+str+"]\n";
		}
	}
	return "";
}


/* 半角英数字チェック */
function AlphabetNumberCheck(item, str, len) {
	if(str.length == 0){
		return item + "が未入力です。\n";
	}else if(str.length > len){
		return item + "は、"+len+"文字以下で入力して下さい。["+str+"]\n";
	}
	for(var i=0 ; i<str.length; i++){
		var code=str.charCodeAt(i);
		if ((48<=code && code<=57) || (65<=code && code<=90) || (97<=code && code<=122) || str.substr(i,1)=='_' || str.substr(i,1)=='.' ) {
            /* 半角英字（a-z,A-Z）の文字コード範囲 */
            /* 半角[_]も許容 */
		}else{
			return item + "は、半角英数字のみで入力して下さい。["+str+"]\n";
		}
	}
	return "";
}


/* 全角半角英数字チェック */
function ZenAlphabetNumberCheck(item, str, len) {
	if(str.length == 0){
		return item + "が未入力です。\n";
	}else if(str.length > len){
		return item + "は、"+len+"文字以下で入力して下さい。["+str+"]\n";
	}
	for(var i=0 ; i<str.length; i++){
		var code=str.charCodeAt(i);

		/* 1文字ずつ文字コードをエスケープし、その長さが4文字以上なら全角 */
		var zenlen=escape(str.charAt(i)).length;

		if ( (32<=code && code<=126) || (zenlen>=4) || str.substr(i,1)=='.' ) {
            /* 半角英字（a-z,A-Z）の文字コード範囲 */
            /* 半角[_]も許容 */
		}else{
			return item + "は、全角および半角英数字のみで入力して下さい。["+str+"]\n";
		}
	}
	return "";
}

function SelectCheck(item, str) {
	if(str == 0){
		return item + "が未選択です。\n";
	}
	return "";
}

function RadioCheck(item, obj) {
	var flag = 0;
	for(var i=0; i<obj.length; i++){
		if( obj[i].checked )
			flag = 1;
	}
	if (!flag){
		return item + "が未選択です。\n";
	}
	return "";
}

function DateCheck(item, str) {
	if(str.length == 0){
		return item + "が未入力です。\n";
	}else if(str.length > 10){
		return item + "は、"+len+"文字以下で入力して下さい。["+str+"]\n";
	}
	for(var i=0 ; i<str.length; i++){
		var code=str.charCodeAt(i);
		if ((48<=code && code<=57) || str.substr(i,1)=='/' || str.substr(i,1)=='-') {
            /* 半角数字許容 */
		}else{
			return item + "は、半角英数字のみで入力して下さい。["+str+"]\n";
		}
	}
	return "";
}


/* Fileチェック */
function FileCheck(item, str, len) {
	if(str.length == 0){
		return item + "が未入力です。\n";
	}else if(str.length > len){
		return item + "は、"+len+"文字以下で入力して下さい。["+str+"]\n";
	}
	for(var i=0 ; i<str.length; i++){
		var code=str.charCodeAt(i);
		if ((33<=code && code<=64) || (65<=code && code<=90) || (97<=code && code<=122) || str.substr(i,1)=='.' || str.substr(i,1)=='_') {
            /* 半角英字（a-z,A-Z）の文字コード範囲 */
            /* 半角[_]も許容 */
		}else{
			return item + "は、半角英数字のみで入力して下さい。["+str+"]\n";
		}
	}
	return "";
}

/* URLチェック */
function UrlCheck(item, str, len) {
	if(str.length == 0){
		return item + "が未入力です。\n";
	}else if(str.length > len){
		return item + "は、"+len+"文字以下で入力して下さい。["+str+"]\n";
	}
	for(var i=0 ; i<str.length; i++){
		var code=str.charCodeAt(i);

		if (32<=code && code<=126  || str.substr(i,1)=='\n' || str.substr(i,1)=='\r' || str.substr(i,1)=='\a') {

		}else{
			//return item + "は、半角英数字のみで入力して下さい。["+str+"]\n";
			return item + "は、半角英数字のみで入力して下さい。["+str+"]["+code+"]\n";
		}
	}
	return "";
}

/* HTMLチェック */
function HtmlCheck(item, str, len) {
	if(str.length == 0){
		return item + "が未入力です。\n";
	}else if(str.length > len){
		return item + "は、"+len+"文字以下で入力して下さい。["+str+"]\n";
	}
	for(var i=0 ; i<str.length; i++){
		var code=str.charCodeAt(i);

		/* 1文字ずつ文字コードをエスケープし、その長さが4文字以上なら全角 */
		var zenlen=escape(str.charAt(i)).length;

		if ((32<=code && code<=126) || (zenlen>=4) || str.substr(i,1)=='\n' || str.substr(i,1)=='\r' || str.substr(i,1)=='\a' ) {
            /* 半角英字（a-z,A-Z）の文字コード範囲 */
            /* 半角[_]も許容 */
		}else{
			return item + "は、半角英数字のみで入力して下さい。["+str+"]\n";
		}
	}
	return "";
}


function CheckBoxCheck(item, obj, count) {
	var flag = 0;
	for(var i=0; i<count; i++) {
		var a = obj.elements['data[GetupImg][girl_type_ids][' + i + ']'];
		if(a.type == 'checkbox'){
			if(a.checked){
				flag++;
			}
		}
	}
	if(flag == 0) {
		return item + "は、１つ以上選択して下さい。\n";
	}else if(flag > 5){
		return item + "は、５つ以下選択して下さい。\n";
	}
	return "";
}

