<?php
//	参照：　http//localhost:81/inabou/trafficfee/
//	参照：　http//p7.yoshikura.com/inabou/trafficfee/


// Excel出力用ライブラリ
App::import( 'Vendor', 'PHPExcel', array('file'=>'phpexcel' . DS . 'PHPExcel.php') );
App::import( 'Vendor', 'PHPExcel_IOFactory', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'IOFactory.php') );
App::import( 'Vendor', 'PHPExcel_Cell_AdvancedValueBinder', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Cell' . DS . 'AdvancedValueBinder.php') );
// Excel95用ライブラリ
//App::import( 'Vendor', 'PHPExcel_Writer_Excel5', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Writer' . DS . 'Excel5.php') );
//App::import( 'Vendor', 'PHPExcel_Reader_Excel5', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Reader' . DS . 'Excel5.php') );

// Excel2007用ライブラリ
App::import( 'Vendor', 'PHPExcel_Writer_Excel2007', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Writer' . DS . 'Excel2007.php') );
App::import( 'Vendor', 'PHPExcel_Reader_Excel2007', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Reader' . DS . 'Excel2007.php') );

App::uses('AppController', 'Controller');
App::import('Vendor', 'util/common');

class TrafficfeeController extends AppController {
	public $name = 'Trafficfee';
	public $uses = array('User', 'Trafficfee', 'Car');	//, 'Quotation', 'Logs'
	public $layout = 'trafficfee';

	public $components = array('Auth', 'Common');	//'Session', , 'Mail', 'Email', 'Qdmail', 'Excel'  
	public $helpers = array('Common', 'Html', 'Form');	//'Javascript', , 'Tabular', 'Calender', 'Holiday'
	public $URL_SELF;

	public $_dir = "/inabou/";
	public $_url = "";
	public $_path = WWW_ROOT;
	

    function beforeFilter() {
		define("Classes", $_SERVER["DOCUMENT_ROOT"]."/Classes/");

	//	if($this->Common->CheckUserAuth($this->Auth) == false){
		//	$this->redirect(array('controller'=>'users','action'=>'login',"メール認証に失敗しました。"));
	//	}

		$this->set('main_title', "ETC記録");
		$this->set('error_message', null);
		$this->set('data_error', false);
		$this->set('data_error_msg', "");

//		App::import('Helper', 'Html');
//      $html = new HtmlHelper();
//		$this->URL_SELF = $html->url('/', true);	// http://vps.waa.jp/trafficfee
		$this->set('URL_SELF', $this->URL_SELF);
		date_default_timezone_set('Asia/Tokyo');

		$this->_dir = "/inabou/";
		$this->set('_dir', $this->_dir);
		
		$this->_url = FULL_BASE_URL.$this->_dir;
		$this->set('_url', $this->_url);

		$this->_path = WWW_ROOT;
		$this->set('_path', $this->_path);
    }

	public function index(){
		$this->redirect(array('controller'=>'trafficfee','action'=>'search'));
	}

	/* =================== 　通行料金検索　 ======================= */
	public function search($main_menu="", $main_year="") {
		$error_msg = "";
		$this->set('main_title', 'ETC記録');
		$this->set('sub_title', '検索');


		/* 検索単語の取得 */
		$search = $this->Common->getPost($this, 'Trafficfee', 'search');
		$id = $this->Common->getPost($this, 'Trafficfee', 'id');
		
		$use_date1 = $this->Common->getPost($this, 'Trafficfee', 'use_date1');
		$use_date2 = $this->Common->getPost($this, 'Trafficfee', 'use_date2');

		if(!$use_date1){
			$a = $this->Common->GetModelAll("Trafficfee", "use_date");
			$use_date1 = $a[0];
			$this->set('use_date1', 	$use_date1);
		}
//debug($use_date1);

		if(!$use_date2){
			$a = $this->Common->GetModelAll("Trafficfee", "use_date");
			$use_date2 = $a[count($a)-1];
			$this->set('use_date2', 	$use_date2);
		}
//debug($use_date2);

		$car_plate = $this->Common->getPost($this, 'Trafficfee', 'car_plate');
		$use_section = $this->Common->getPost($this, 'Trafficfee', 'use_section');
		$amount = $this->Common->getPost($this, 'Trafficfee', 'amount');

		/* pagenation引数取得 */
		$page = $this->Common->getPost($this, 'Trafficfee', 'page');
		$direction = $this->Common->getPost($this, 'Trafficfee', 'direction');
		$sort = $this->Common->getPost($this, 'Trafficfee', 'sort');

		/* 検索単語に基づき条件作成 */
		$conditions = array();
		if($id)
			$conditions = array_merge_recursive($conditions, array("id" => $id));

		if($use_date1 and $use_date2)
			$conditions = array_merge_recursive($conditions, array('use_date BETWEEN ? AND ?' => array($use_date1, $use_date2)));

		if($car_plate)
			$conditions = array_merge_recursive($conditions, array( "car_plate like" => '%'.$car_plate.'%'));

		if($use_section)
			$conditions = array_merge_recursive($conditions, array( "use_section like" => '%'.$use_section.'%'));

		$user0 = $this->Auth->User();
		if($user0['id'] > 3){
			$conditions = array_merge_recursive($conditions, array( "car_plate Not like" => '%6667%'));
		}


		$this->set('conditions', $conditions);

//debug($conditions);

		$this->paginate = array(
			'Trafficfee' => array(
				'page' => 1,
				'limit' => 20,
				'order' => array('id'), 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('Trafficfee');
		$this->set('data', $data);


		$this->set('search', $search);
		$this->set('error_msg', $error_msg);
//debug($data);
		//$user0 = $this->Auth->User();
		$this->set('login_id', $user0['id']);
	}






	/* =================== 　通行料金検索　 ======================= */
	public function search2($main_menu="", $main_year="") {
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);

		$user0 = $this->Auth->user();
		//if($user0['category'] == 0){
		//	$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'trafficfee','action'=>'index'));
		//}
		$this->set('main_title', '通行料金(日毎)');
		$this->set('sub_title', '検索');
		
		/* 検索単語の取得 */
		$search = $this->Common->getPost($this, 'Trafficfee', 'search');
		$id = $this->Common->getPost($this, 'Trafficfee', 'id');
		if($this->flag == false){
			//$this->flag = $this->MakeTrafficfee();
		}
		
		$use_date1 = $this->Common->getPost($this, 'Trafficfee', 'use_date1');
		$use_date2 = $this->Common->getPost($this, 'Trafficfee', 'use_date2');

		if(!$use_date1){
			$a = $this->Common->GetModelAll("Trafficfee", "use_date");
			if(count($a) > 0)
				$use_date1 = $a[0];
			$this->set('use_date1', 	$use_date1);
		}
//debug($use_date1);

		if(!$use_date2){
			$a = $this->Common->GetModelAll("Trafficfee", "use_date");
			if(count($a) > 0)
				$use_date2 = $a[count($a)-1];
			$this->set('use_date2', 	$use_date2);
		}
//debug($use_date2);

		$car_plate = $this->Common->getPost($this, 'Trafficfee', 'car_plate');
		$use_section = $this->Common->getPost($this, 'Trafficfee', 'use_section');
		$amount = $this->Common->getPost($this, 'Trafficfee', 'amount');

		/* pagenation引数取得 */
		$page = $this->Common->getPost($this, 'Trafficfee', 'page');
		$direction = $this->Common->getPost($this, 'Trafficfee', 'direction');
		$sort = $this->Common->getPost($this, 'Trafficfee', 'sort');

		/* 検索単語に基づき条件作成 */
		$conditions = array();
		if($id)
			$conditions = array_merge_recursive($conditions, array("ids" => $id));

		if($use_date1 and $use_date2)
			$conditions = array_merge_recursive($conditions, array('use_date BETWEEN ? AND ?' => array($use_date1, $use_date2)));

		if($car_plate)
			$conditions = array_merge_recursive($conditions, array( "car_plate like" => '%'.$car_plate.'%'));

		if($use_section)
			$conditions = array_merge_recursive($conditions, array( "use_section like" => '%'.$use_section.'%'));

		if($user0['id'] > 3){
			$conditions = array_merge_recursive($conditions, array( "car_plate Not like" => '%6667%'));
		}

		$this->set('conditions', $conditions);
//debug($conditions);
		/* 検索単語に基づき引数作成 */
		$searchword = array();
		$searchword = array("search" => $search,
					 "id" => urlencode($id),
				     "use_date1" => urlencode($use_date1),
				     "use_date2" => urlencode($use_date2),

				     "car_plate" => urlencode($car_plate),
				     "use_section" => urlencode($use_section),
		);
		/* ページネーションの作成 *///debug($conditions);
		$this->paginate = array(
			'Trafficfee' => array(
				'page' => 1,
				'limit' => 20,
				'order' => array('id'), 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('Trafficfee');
		$this->set('data', $data);
//debug($data);
		$this->set('searchword', $searchword);
		$this->set('argument', $this->Common->array_to_string($searchword));

		//$this->set('data', 	$this->data);
		$this->set('login_category', $user0['category']);

	}


	/* =================== 　通行料金検索　 ======================= */
	public function search3($main_menu="", $main_year="") {
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);

		$user0 = $this->Auth->user();
		//if($user0['category'] == 0){
		//	$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'trafficfee','action'=>'index'));
		//}
		$this->set('main_title', '通行料金(車No毎)');
		$this->set('sub_title', '検索');
		
		/* 検索単語の取得 */
		$search = $this->Common->getPost($this, 'Trafficfee', 'search');
		$id = $this->Common->getPost($this, 'Trafficfee', 'id');
		if($this->flag == false){
			//$this->flag = $this->MakeTrafficfee();
		}
		
		$use_date1 = $this->Common->getPost($this, 'Trafficfee', 'use_date1');
		$use_date2 = $this->Common->getPost($this, 'Trafficfee', 'use_date2');

		if(!$use_date1){
			$a = $this->Common->GetModelAll("Trafficfee", "use_date");
			if(count($a) > 0)
				$use_date1 = $a[0];
			$this->set('use_date1', 	$use_date1);
		}
//debug($use_date1);

		if(!$use_date2){
			$a = $this->Common->GetModelAll("Trafficfee", "use_date");
			if(count($a) > 0)
				$use_date2 = $a[count($a)-1];
			$this->set('use_date2', 	$use_date2);
		}
//debug($use_date2);

		$car_plate = $this->Common->getPost($this, 'Trafficfee', 'car_plate');
		$use_section = $this->Common->getPost($this, 'Trafficfee', 'use_section');
		$amount = $this->Common->getPost($this, 'Trafficfee', 'amount');

		/* pagenation引数取得 */
		$page = $this->Common->getPost($this, 'Trafficfee', 'page');
		$direction = $this->Common->getPost($this, 'Trafficfee', 'direction');
		$sort = $this->Common->getPost($this, 'Trafficfee', 'sort');

		/* 検索単語に基づき条件作成 */
		$condition = array();
		if($id)
			$condition = array_merge_recursive($condition, array("id" => $id));

		//if($use_date1 and $use_date2)
		//	$condition = array_merge_recursive($condition, array('use_date BETWEEN ? AND ?' => array($use_date1, $use_date2)));

		if($car_plate)
			$condition = array_merge_recursive($condition, array( "car_plate like" => '%'.$car_plate.'%'));

		if($use_section)
			$condition = array_merge_recursive($condition, array( "use_section like" => '%'.$use_section.'%'));

		if($user0['id'] > 3){
			$condition = array_merge_recursive($condition, array( "car_plate Not like" => '%6667%'));
		}

//debug($conditions);
		$searchword = array("search" => $search,
					 "id" => urlencode($id),
				     "use_date1" => urlencode($use_date1),
				     "use_date2" => urlencode($use_date2),

				     "car_plate" => urlencode($car_plate),
				     "use_section" => urlencode($use_section),
		);


		
		/* ページネーションの作成 *///debug($conditions);
		$this->paginate = array(
			'Trafficfee' => array(
				'page' => 1,
				'limit' => 20,
				'order' => array('id'), 		// desc
				'conditions' => $condition, 
			), 
		);
		$this->data = $this->paginate('Trafficfee');

		$this->set('searchword', $searchword);
		$this->set('argument', $this->Common->array_to_string($searchword));

		$this->set('data', 	$this->data);
		$this->set('login_category', $user0['category']);

	}






	/* =================== 　通行料金検索　 ======================= */
	public function search4($main_menu="", $main_year="") {
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);

		$user0 = $this->Auth->user();
		//if($user0['category'] == 0){
		//	$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'trafficfee','action'=>'index'));
		//}
		$this->set('main_title', '通行料金(車No毎)');
		$this->set('sub_title', '検索');

		$a = $this->Common->GetModelAll("Trafficfee", "use_date");
		$use_date1 = $a[0];
		$use_date2 = $a[count($a)-1];

		$use_date1 = date("Y-m-d", strtotime($use_date2." -1 year  +1 day"));

		$this->set('use_date1', 	$use_date1);
		$this->set('use_date2',	$use_date2);
//debug($use_date1);
//debug($use_date2);

		$colspan = 12;	//intval(date("m", strtotime($use_date2))) + 3+12;

//debug($use_date1);
		$car_plate = $this->Common->getPost($this, 'Trafficfee', 'car_plate');
		$use_section = $this->Common->getPost($this, 'Trafficfee', 'use_section');
		$amount = $this->Common->getPost($this, 'Trafficfee', 'amount');

		/* pagenation引数取得 */
		$page = $this->Common->getPost($this, 'Trafficfee', 'page');
		$direction = $this->Common->getPost($this, 'Trafficfee', 'direction');
		$sort = $this->Common->getPost($this, 'Trafficfee', 'sort');

		/* 検索単語に基づき引数作成 */
		$searchword = array();
		$searchword = array("use_date1" => urlencode($use_date1), "use_date2" => urlencode($use_date2));

		$conditions = array('use_date  BETWEEN ? AND ?' => array($use_date1, $use_date2));
//debug($colspan);

//SELECT car_plate, sum(`amount`) as total, DATE_FORMAT(use_date, '%Y%m') as dates 
//FROM `trafficfee` WHERE 1 GROUP BY DATE_FORMAT(use_date, '%Y%m'), `car_plate` ORDER BY id;

		$data = $this->Trafficfee->find('all', array(
			'fields' => array('car_plate', 
					//'GROUP_CONCAT(`id`) as ids', 
					//'GROUP_CONCAT(`use_date`) as dates', 
					//'GROUP_CONCAT(`amount`) as amounts', 
					"sum(`amount`) as total",
					"DATE_FORMAT(use_date, '%Y%m') as dates"
					),
			'group' => array("DATE_FORMAT(use_date, '%Y%m')", "car_plate"),
			'order' => array('id'), 		// desc
			'conditions' => $conditions,
			));
//debug($data);

		$data1 = $this->Trafficfee->find('all', array(
			'fields' => array('car_plate'),
			'group' => array("car_plate"),
			'order' => array('car_plate'), 		// desc
			'conditions' => $conditions,
			));
		for($i=0; $i<count($data1); $i++){
			$rows1[$i] = $data1[$i]['Trafficfee']['car_plate'];
			$rows2[$i] = $this->Common->GetCarUserName($rows1[$i]);
		}
//debug($rows1);
//debug($rows2);

		$data2 = $this->Trafficfee->find('all', array(
			'fields' => array("DATE_FORMAT(use_date, '%Y%m') as dates"),
			'group' => array("DATE_FORMAT(use_date, '%Y%m')"),
			'order' => array("DATE_FORMAT(use_date, '%Y%m')"), 		// desc
			'conditions' => $conditions,
			));

//debug($data2);
		for($i=0; $i<count($data2); $i++){
			$columns[$i] = $data2[$i][0]['dates'];
		}
//debug($columns);
//exit();
		for($n=0; $n<count($data); $n++){
//debug($data[$n]['Trafficfee']['car_plate']);
//debug($data[$n][0]['dates']);
			$found = 0;
			for($i=0; $i<count($rows1); $i++){
				for($j=0; $j<count($columns); $j++){
					if($rows1[$i] == $data[$n]['Trafficfee']['car_plate']){
						if($columns[$j] == $data[$n][0]['dates']){
//debug("*[".$i."][".$j."]");
							if(!isset($data3[$i][$j+2])){
								$data3[$i]['car_plate'] = $rows1[$i];
								$data3[$i]['user'] = $rows2[$i];
								$data3[$i][$j+2] = $data[$n][0]['total'];
								$found = 1;
								break;
							}elseif($data3[$i][$j+2] == 0){
								$data3[$i][0] = $rows1[$i];
								$data3[$i][1] = $rows2[$i];
								$data3[$i][$j+2] = $data[$n][0]['total']."/".$data[$n][0]['dates'];
								$found = 1;
								break;
							}else{
								debug("エラー[".$i."][".$j."]"); exit();
							}
						}
					}
					$found = 0;
				}
				if($found == 1){
					$found = 0;
					break;
				}
			}
		}

//debug($data3);
//exit();
		if(!empty($this->data)){
			$colspan = 12;
			if(isset($this->data['excel'])){
//debug($this->data);
//exit();
				/***********************************/
				$this->search_export($data3, $rows1, $rows2, $columns);
				/***********************************/
			}
		}

		/* ページネーションの作成 *///debug($conditions);
		$this->paginate = array(
			'Trafficfee' => array(
				'fields' => array(),
				'group' => array(),
				'page' => 1,
				'limit' => 100,
				'order' => array('id'), 		// desc
				'conditions' => array(), 
			), 
		);
		$this->data = $this->paginate('Trafficfee');
		$this->data = $data3;
		$this->set('data', 	$this->data);
//debug($this->data);
		$colspan = 12;	//intval(date("m", strtotime($use_date2))) + 3+12;
		$this->set('colspan', $colspan);
		$this->set('columns', $columns);
		$this->set('rows1', $rows1);
		$this->set('rows2', $rows2);
//exit();
	}




	function search_export($data, $rows1, $rows2, $columns){
//debug($data);
//debug($rows1);
//debug($rows2);
//debug($columns);
//exit();
		$excel_file0 = "trafficfee.xlsx";
		$xcellFile0 = $this->Common->ConvPath( WWW_ROOT."files/trafficfee/ORG/".$excel_file0);
		if(file_exists($xcellFile0) == false){
			debug("No exists ExcelFile:".$xcellFile0);
			exit();
		}
//debug($xcellFile0);
		//$excel_file = date("YmdHis")."_".$excel_file0;
		$excel_file = date("YmdHi")."_".$excel_file0;

		$xcellFile = $this->Common->ConvPath( WWW_ROOT."files/trafficfee/".$excel_file);
		if(file_exists($xcellFile)){
			unlink($xcellFile);
		}
		copy($xcellFile0, $xcellFile);
//debug($xcellFile);


		//$book = new PHPExcel();
		$book = PHPExcel_IOFactory::load($xcellFile);
//exit();

//debug($log);
		$data_count = count($data)-1;
//debug($data_count);
//debug($data);
//exit();

		$sh=0;
		//for($sh=0; $sh<5; $sh++){

			// シートの設定を行う
			$book->setActiveSheetIndex($sh);
			$sheet = $book->getActiveSheet();
//exit();


			$colspan = 12;
			//-----------------------------------------------
			$sheet->setCellValueByColumnAndRow( 0, 1, "連番");
			$sheet->setCellValueByColumnAndRow( 1, 1, "車No");
			$sheet->setCellValueByColumnAndRow( 2, 1, "所有者");
			for($j=0; $j<$colspan; $j++){
				$sheet->setCellValueByColumnAndRow( 3+$j, 1,  sprintf("%s", $columns[$j]));
			}
			$sheet->setCellValueByColumnAndRow( $colspan+3, 1, "合計");
			//-----------------------------------------------
//exit();
			$sub_total = 0;
			for($i=0; $i<count($data); $i++){
				// セルに値をセットする
				//$sheet->setCellValueByColumnAndRow( 0, $i + 2,  $i+1 );
				$sheet->setCellValueByColumnAndRow( 0, $i + 2,  $i+1 );
				$sheet->setCellValueByColumnAndRow( 1, $i + 2,  $rows1[$i] );
				$sheet->setCellValueByColumnAndRow( 2, $i + 2,  $rows2[$i] );
				$sub_total = 0;

				for($j=0; $j<$colspan; $j++){
					if(isset($data[$i][$j+2])){
						$sheet->setCellValueByColumnAndRow( 3+$j, $i + 2,  $data[$i][$j+2]);
						$sub_total += $data[$i][$j+2];
					}else{
						$sheet->setCellValueByColumnAndRow( 3+$j, $i + 2,  0);
						//$sub_total += 0;
					}
				}
				$sheet->setCellValueByColumnAndRow( $colspan+3, $i + 2, $sub_total );
//break;
			}
			
			$sheet->setCellValueByColumnAndRow( 0, $i + 2,  "" );
			$sheet->setCellValueByColumnAndRow( 1, $i + 2,  "" );
			$sheet->setCellValueByColumnAndRow( 2, $i + 2,  "合計" );
			/*
			for($j=0; $j<$colspan; $j++){
				$sheet->setCellValueByColumnAndRow( 3+$j, $i + 2,  $data['Trafficfee']['m_total'][$j] );
			}
			$sheet->setCellValueByColumnAndRow( $colspan+3, $i + 2, $data['Trafficfee']['m_total'][$j] );
			*/
			//-----------------------------------------------
		
		//}//endfor $sh
		// Excel2007形式で保存する
		$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
		$writer->save($xcellFile);

	// メモリの解放
		$book->disconnectWorksheets();
		unset($book);
//exit();
		// ファイルのダウンロード
		$dl_file = $excel_file;
		header('Content-Type: application/force-download');
		header('Content-Length: '.filesize($xcellFile));
		header('Content-Disposition: attachment; filename="'.mb_convert_encoding($dl_file, 'SJIS-win', 'UTF-8').'"');
		readfile($xcellFile);
		//exit();
	
		//$this->redirect(array('controller'=>'invoice','action'=>'search'));
		
	}







	/* =================== 通行料金詳細 ======================= */
	function search_detail($arg=""){
		$user0 = $this->Auth->user();
		if($user0['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'trafficfee','action'=>'index'));
		}

		$this->set('main_title', '通行料金(一覧)');
		$this->set('sub_title', '通行料金　＞　詳細');
		$this->set('sub_title2', '通行料金　＞　詳細');

		if($arg){
			$this->Trafficfee->id = $arg;
		}else{
			$this->Trafficfee->id = $this->Common->getPost($this, 'Trafficfee', 'id');
		}
		if(empty($this->data)){
			$this->data = $this->Trafficfee->read();	//読み出し
//print_r($this->data);
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
		}else{
			//$this->data = $this->Common->sjis2utf8($this->data);
			
			$count = $this->Trafficfee->find('count', array('conditions' => array('category LIKE' => $this->data['Trafficfee']['category'],
																		'id !=' => $this->Trafficfee->id)));
			if($count){
				//$this->data = $this->Common->utf82sjis($this->data);
				$this->set('data', $this->data);
				$this->set('error_message', "データが既に存在しています。");
				return;
			}
			
//echo $this->Common->getPost($this, 'Trafficfee', 'password')."<br>";
//print_r($this->data);
			//$this->data = $this->Common->sjis2utf8($this->data);
			
			if(false){
				if(!$this->Trafficfee->save($this->data)){		//更新
					$errors = $this->Trafficfee->invalidFields();
					$mes = '';
					foreach($errors as $field => $message){
						$mes .= $field." : ".$message."<br />\n";
					}
					$this->set('error_message', $mes);

					//$this->data = $this->Common->utf82sjis($this->data);
					$this->set('data', $this->data);
				}else{
					$this->redirect(array('controller'=>'trafficfee','action'=>'search'));
				}
			}
		}
		$this->set('category', $user0['category']);
	}



	/* =================== 通行料金詳細 ======================= */
	function search_detail2($arg=""){
		$user0 = $this->Auth->user();
		if($user0['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'trafficfee','action'=>'index'));
		}
		
		//implode(",", explode(",", $arg));

		$this->set('main_title', '通行料金(日毎)');
		$this->set('sub_title', '通行料金　＞　詳細');
		$this->set('sub_title2', '通行料金　＞　詳細');

		if(empty($this->data)){
			$this->data = $this->Trafficfee->find('all', 
				array('conditions' => array('Trafficfee.id' => explode(",", $arg))
				));
//debug($arg);
//print_r($this->data);
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
		}else{

		}
		$this->set('category', $user0['category']);
	}


	/* =================== 通行料金詳細 ======================= */
	function search_detail3($arg=""){
		$user0 = $this->Auth->user();
		if($user0['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'trafficfee','action'=>'index'));
		}
		
		//implode(",", explode(",", $arg));

		$this->set('main_title', '通行料金(車No毎)');
		$this->set('sub_title', '通行料金　＞　詳細');
		$this->set('sub_title2', '通行料金　＞　詳細');

		if(empty($this->data)){
			$this->data = $this->Trafficfee->find('all', 
				array('conditions' => array('Trafficfee.id' => explode(",", $arg))
				));
//debug($arg);
//print_r($this->data);
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
		}else{

		}
		$this->set('category', $user0['category']);
	}



	/* =================== 通行料金修正 ======================= */
	function search_edit($arg=""){
		$user0 = $this->Auth->user();
		if($user0['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'trafficfee','action'=>'index'));
		}

		$this->set('main_title', '通行料金');
		$this->set('sub_title', '通行料金　＞　修正');

		if($arg)
			$this->User->id = $arg;
		else
			$this->User->id = $this->Common->getPost($this, 'User', 'id');

		if(empty($this->data)){
			$this->data = $this->User->read();	//読み出し
//print_r($this->data);
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
		}else{
			//$this->data = $this->Common->sjis2utf8($this->data);
			
			$count = $this->User->find('count', array('conditions' => array('category LIKE' => $this->data['User']['category'],
																		'id !=' => $this->User->id)));
			if($count){
				//$this->data = $this->Common->utf82sjis($this->data);
				$this->set('data', $this->data);
				$this->set('error_message', "ユーザ名が既に存在しています。");
				return;
			}
			
//echo $this->Common->getPost($this, 'User', 'password')."<br>";
//print_r($this->data);
			//$this->data = $this->Common->sjis2utf8($this->data);
			
			//if(false){
				if(!$this->User->save($this->data)){		//更新
					$errors = $this->User->invalidFields();
					$mes = '';
					foreach($errors as $field => $message){
						$mes .= $field." : ".$message."<br />\n";
					}
					$this->set('error_message', $mes);

					//$this->data = $this->Common->utf82sjis($this->data);
					$this->set('data', $this->data);
				}else{
					$this->redirect(array('controller'=>'trafficfee','action'=>'search'));
				}
			//}
		}
		$this->set('category', $user0['category']);
	}

	/* =================== 通行料金削除 ======================= */
	function search_delete($arg=""){
		$user0 = $this->Auth->user();
		if($user0['category'] != 2){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'trafficfee','action'=>'index'));
		}

		$this->set('main_title', '通行料金');
		$this->set('sub_title', '通行料金　＞　削除');

		if($arg)
			$this->User->id = $arg;
		else
			$this->User->id = $this->Common->getPost($this, 'User', 'id');

		if(empty($this->data)){
			$this->data = $this->User->read();	//読み出し
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
		}else{
			$this->set('data', $this->data);

			if(!$this->User->delete($this->User->id)){		//削除
				$errors = $this->User->invalidFields();
				$mes = '';
				foreach($errors as $field => $message){
					$mes .= $field." : ".$message."<br />\n";
				}
				$this->set('error_message', $mes);
			}else
				$this->redirect(array('controller'=>'trafficfee','action'=>'search'));
		}
		$this->set('category', $user0['category']);
	}
	/* =================== 通行料金新規作成 ======================= */
	function search_new(){
		$user0 = $this->Auth->user();
		if($user0['category'] != 2){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'trafficfee','action'=>'index'));
		}

		$this->set('main_title', '通行料金情報');
		$this->set('sub_title', '通行料金　＞　新規作成');

		if(empty($this->data)){
			//$this->data['Trafficfee']['category'] = null;
			//$this->data['Trafficfee']['password'] = null;
			//$this->data['Trafficfee']['use_date'] = 0;
			//$this->set('data', $this->data);
		}else{
			//$this->data = $this->Common->sjis2utf8($this->data);

			$count = $this->Trafficfee->find('count', array('conditions' => array('category LIKE' => $this->data['Trafficfee']['category'])));
			if($count){
				//$this->data = $this->Common->utf82sjis($this->data);
				$this->set('data', $this->data);
				$this->set('error_message', "ユーザ名が既に存在しています。");
				return;
			}

			$this->data['Trafficfee']['id'] = null;
//print_r($this->data); echo "<br>";
			if(!$this->Trafficfee->save($this->data)){		//新規作成
				$errors = $this->Trafficfee->invalidFields();
				$mes = '';
				foreach($errors as $field => $message){
					$mes .= $field." : ".$message."<br />\n";
				}
				$this->set('error_message', $mes);

				//$this->data = $this->Common->utf82sjis($this->data);
				$this->set('data', $this->data);
			}else
				$this->redirect(array('controller'=>'trafficfee','action'=>'search'));
		}
		$this->set('category', $user0['category']);
	}


	
	function download($arg=""){
		$this->set('main_title', "ダウンロード");
		$this->set('sub_title',  '');
		
		if($arg){
			$this->Trafficfee->id = $arg;
		}else{
			$this->Trafficfee->id = $this->Trafficfee->id = $this->Common->getPost($this, 'Trafficfee', 'id');
		}
		if(empty($this->data)){
			$this->data = $this->Trafficfee->read();	//読み出し
			$this->xlsx_write_proc();
		}else{
		
		}
//debug($up_file);
		$this->set('data', $this->data);
	}

	private function xlsx_write_proc(){
		$path0 = $this->Common->ConvPath( WWW_ROOT."files/Trafficfee/excel/ORG/" );
		$path = $this->Common->ConvPath( WWW_ROOT."files/Trafficfee/excel/" );
		//$filename = "Trafficfee_form.xlsx";
		$filename = "Trafficfee_form.xlsx";

		$excel_file = $path.$filename;
		if(file_exists($excel_file))
			unlink($excel_file);
		copy($path0.$filename, $excel_file);
		
        //ファイルを読み込む
        $objReader = PHPExcel_IOFactory::createReader('Excel2007');

        $objPHPExcel = $objReader->load($excel_file);
		$objPHPExcel->setActiveSheetIndex(0);
		
        $sheet = $objPHPExcel->getActiveSheet();
        //$sheet->setCellValueByColumnAndRow($c, $r+1, $v);

		$sheet->setCellValue('B6', $this->data2['Quotation']['dest_up']);
		$sheet->setCellValue('B7', $this->data2['Quotation']['dest_low']);
		$sheet->setCellValue('M7', $this->data2['Quotation']['address']);

		$sheet->setCellValue('B14', $this->data2['Quotation']['OrderNo_up']);
		$sheet->setCellValue('B17', $this->data2['Quotation']['OrderNo_mid']);
		$sheet->setCellValue('B20', $this->data2['Quotation']['OrderNo_low']);
		
		$sheet->setCellValue('V2', $this->data2['Quotation']['EstimateNo']);
		$sheet->setCellValue('Q6', date('Y年m月d日', strtotime($this->data['Trafficfee']['DeliveryTime'])));
		$sheet->setCellValue('R26', $this->data2['Quotation']['OrderNo']);
		
		$sheet->setCellValue('M28', $this->data2['Quotation']['Total_Amount']);
		
		$a = explode("/", $this->data2['Quotation']['ProductName']);
		$b = explode("/", $this->data2['Quotation']['quantity']);
		$c = explode("/", $this->data2['Quotation']['Qty_assist']);
		$d = explode("/", $this->data2['Quotation']['price']);
		$e = explode("/", $this->data2['Quotation']['Amount_line']);
		$f = explode("/", $this->data2['Quotation']['remark']);

//debug(count($a));
		if(count($a) >= 12)
			$n = 11;
		else
			$n = count($a);

		for($i=0; $i<$n; $i++){
			if(trim($a[$i].$b[$i].$c[$i].$d[$i].$e[$i]) != ""){
	        	$sheet->setCellValueByColumnAndRow(2, 34+$i, $this->zero_check( $a[$i] )); //C24
	        	$sheet->setCellValueByColumnAndRow(9, 34+$i, $this->zero_check( $b[$i] )); //J24
	        	$sheet->setCellValueByColumnAndRow(11, 34+$i, $this->zero_check( $c[$i] )); //L24
	        	$sheet->setCellValueByColumnAndRow(13, 34+$i, $this->zero_check( $d[$i] )); //N24
	        	$sheet->setCellValueByColumnAndRow(16, 34+$i, $this->zero_check( $e[$i] )); //Q24
	        	$sheet->setCellValueByColumnAndRow(20, 34+$i, $this->zero_check( $f[$i] )); //U24
			}
		}
		
		$sheet->setCellValue('I47', $this->zero_check($this->data2['Quotation']['labor_cost']));
		$sheet->setCellValue('I48', $this->zero_check($this->data2['Quotation']['other_expense']));
		$sheet->setCellValue('I43', $this->zero_check($this->data2['Quotation']['discount']));

		$sheet->setCellValue('S47', $this->zero_check($this->data2['Quotation']['subTotal']));
		$sheet->setCellValue('S48', $this->zero_check($this->data2['Quotation']['Tax_calc_frame']));
		$sheet->setCellValue('S49', $this->zero_check($this->data2['Quotation']['Total_Amount']));

		// Excel2007形式で保存する
		//$writer = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel2007");
		$writer = PHPExcel_IOFactory::createWriter($objPHPExcel, "Excel5");
		$writer->save($excel_file);

//debug($this->data['Quotation']['dest_up']);
//debug($this->data['Quotation']['dest_low']);
		//$excel_file = $this->ConvPath( WWW_ROOT."files/quotation_form.xlsx" );
		
		$filename = $this->data2['Quotation']['dest_low'];
		if($filename == "")
			$filename = $this->data2['Quotation']['dest_up'];
		//$filename = date("Ymd_", strtotime($this->data2['Quotation']['estimate_date'])) . $filename . "_通行料金.xlsx";
		$filename = date("Ymd_", strtotime($this->data2['Quotation']['estimate_date'])) . $filename . "_通行料金.xls";
		// $this->Common->to_utf8();
		Configure::write('debug', 0);       // debugコードを非表示
		header("Content-disposition: attachment; filename={$filename}");    //ダウンロードさせるため
		header("Content-type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet; name={$filename}");
 
		$result = file_get_contents( $excel_file );   // ダウンロードするデータの取得
		print( $result );           // 出力
 //exit();
		return $filename;
	}

	private function zero_check($n){
		if($n == "")
			return "";
		elseif(is_numeric($n))
			return number_format(intval( $n ));
		else
			return $n;
	}

}