<?php
//	http://localhost:81/inabou/signup/set_password
//	http://p7.inabous.net/inabou/signup/
//	http://p7.inabous.net/inabou/signup/set_password

// kayoken2 42496c43801994089e2cd5c6907a8f586d4e221f
//          63500254d0ce0b7cd3a2dbea09bcdb1b4d4532fd

App::uses('AppController', 'Controller');
App::uses('CakeEmail', 'Network/Email');

class SignupController extends AppController {
	public $name = 'Signup';
	public $uses = array('User2');
	public $components = array('Auth');
    public $layout = 'login';
	public $_dir = "/inabou/";
	public $_url = "";
	public $_path = WWW_ROOT;

	
	public function beforeFilter(){
		parent::beforeFilter();
		$this->Auth->allow();

		$this->_dir = "/inabou/";
		$this->set('_dir', $this->_dir);

		if(strstr($_SERVER['SERVER_NAME'], "localhost"))
			$this->_url = "http://localhost:81".$this->_dir;
		else
			$this->_url = "https://".$_SERVER['SERVER_NAME'].$this->_dir;
		$this->set('_url', $this->_url);

		$this->_path = WWW_ROOT;
		$this->set('_path', $this->_path);
		
		$main_title = "SignUp";
		$this->set('main_title', $main_title);
	}
	
	public function index(){
		$password = $this->Auth->password("kayoken2");
debug($password);
		if (! $this->request->data){
			$this->render();
			return;
		}
		
		$this->User2->validate = array(
			'email' => array(
				array(
					//'rule' => 'notEmpty', 
					'rule' => 'notBlank', 
					'message' => 'メールアドレスを入力してください'
				), 
				array(
					'rule' => array('custom', '/^.+@.+$/'), 
					'message' => 'メールアドレスの形式が正しくありません。', 
				), 
				array(
					'rule' => 'confirm', 
					'message' => 'メールアドレスが一致していません。', 
				), 
				array(
					'rule' => 'isUniqueAndActive', 
					'message' => 'このメールアドレスは使用されています。', 
				)
			)
		);
		$this->User2->set($this->request->data);
		if (! $this->User2->invalidFields()){
			$email = $this->request->data['User2']['email'];
			$activation_code = md5($email.time());
			
			$user = $this->User2->find('first', array('conditions' => array('email' => $email, 'is_active' => false)));
			if (! $user){
				$this->User2->create();
				$user = array('User2' => $this->request->data['User2']);
			}
			$user['User2']['is_active'] = false;
			$user['User2']['activation_code'] = $activation_code;
			$this->User2->save($user);
			
			//$cakeemail = new CakeEmail('default');
			$cakeemail = new CakeEmail('smtp');
			$cakeemail->to($email);
			$cakeemail->subject('仮登録のお知らせ');
			$cakeemail->send(sprintf('http://p7.inabous.net/inabou/signup/activate/%s', $activation_code));
			
			$this->render('email_sent');
		}
	}
	
	public function activate($activation_code){
		$user = $this->User2->find('first', array('conditions' => array('activation_code' => $activation_code, 'is_active' => false)));
		if (! $user){ $this->redirect('/signup/index'); }
		
		if (! $this->request->data){
			$this->render();
			return;
		}
		$this->User2->validate = array(
			'password' => array(
				array(
					//'rule' => 'notEmpty', 
					'rule' => 'notBlank', 
					'message' => 'パスワードを入力してください。'
				), 
				array(
					'rule' => array('custom', '/^[a-zA-Z0-9]+$/'), 
					'message' => '半角英数字で入力してください。', 
				), 
				array(
					'rule' => 'confirm', 
					'message' => 'パスワードが一致していません。', 
				), 
			), 
		);
		$this->User2->set($this->request->data);
		if (! $this->User2->invalidFields()){
			$user['User2']['password'] = $this->Auth->password($this->request->data['User2']['password']);
			unset($user['User2']['password_confirm']);
			$user['User2']['is_active'] = true;
			
			$this->User2->validate = array();
			$this->User2->save($user);
			
			$this->Auth->login($user);
			$this->redirect($this->Auth->redirectUrl());
		}
	}

	public function set_password(){
		if (! $this->request->data){
			$this->render();
			return;
		}
debug($this->request->data);
debug($this->request->data['User2']['password']);
		$email = $this->request->data['User2']['email'];
		$user = $this->User2->find('first', array('conditions' => array('email' => $email)));
debug($user);
		if (! $user){

		}
exit();
	}
	
}
