<?php
//	参照：　http://localhost/inabou/users/login
//	参照：　http//p5.yoshikura.com/inabou/schedulex/

// Excel出力用ライブラリ
/*
App::import( 'Vendor', 'PHPExcel', array('file'=>'phpexcel' . DS . 'PHPExcel.php') );
App::import( 'Vendor', 'PHPExcel_IOFactory', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'IOFactory.php') );
App::import( 'Vendor', 'PHPExcel_Cell_AdvancedValueBinder', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Cell' . DS . 'AdvancedValueBinder.php') );
// Excel95用ライブラリ
//App::import( 'Vendor', 'PHPExcel_Writer_Excel5', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Writer' . DS . 'Excel5.php') );
//App::import( 'Vendor', 'PHPExcel_Reader_Excel5', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Reader' . DS . 'Excel5.php') );

// Excel2007用ライブラリ
App::import( 'Vendor', 'PHPExcel_Writer_Excel2007', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Writer' . DS . 'Excel2007.php') );
App::import( 'Vendor', 'PHPExcel_Reader_Excel2007', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Reader' . DS . 'Excel2007.php') );
*/

if(file_exists('D:\xampp\htdocs\vendor\autoload.php'))
	require 'D:\xampp\htdocs\vendor\autoload.php';
else
	require '/home/enzbaoev/public_html/p7/vendor/autoload.php';

//use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx as Writer;
use PhpOffice\PhpSpreadsheet\Reader\Xlsx as Reader;
use PhpOffice\PhpSpreadsheet\RichText\RichText as RichText; //RichTextAPIを使用
use PhpOffice\PhpSpreadsheet\Style;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;

//	https://phpspreadsheet.readthedocs.io/en/latest/


App::uses('AppController', 'Controller');
App::import('Vendor', 'util/common');


class SchedulexController extends AppController {
	public $name = 'Schedulex';
	public $uses = array('User', 'Schedulex', 'Car', 'Logs');
	public $layout = 'schedulex';

	public $components = array('Auth', 'Common');	//'Session', , 'Mail', 'Email', 'Qdmail', 'Excel'
	public $helpers = array('Common', 'Html', 'Form');	//'Javascript', , 'Tabular' , 'Calender', 'Holiday

	public $_dir = "/inabou/";
	public $_url = "";
	public $_path = WWW_ROOT;

    function beforeFilter() {
		$this->set('main_title', "予定表(点検)");
		$this->set('error_message', null);
		$this->set('data_error', false);
		$this->set('data_error_msg', "");

		date_default_timezone_set('Asia/Tokyo');

		$this->_dir = "/inabou/";
		$this->set('_dir', $this->_dir);
		
		$this->_url = FULL_BASE_URL.$this->_dir;
		$this->set('_url', $this->_url);

		$this->_path = WWW_ROOT;
		$this->set('_path', $this->_path);

		$this->set('_store_id', $this->_store_id);

		$main_title = "メニュー管理";
		$this->set('main_title', $main_title);

		$user0 = $this->Auth->user();
		$this->set('login_category', $user0['category']);
    }

	public function index($main_menu="", $main_year=""){
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);

		date_default_timezone_set('Asia/Tokyo');
		$this->User->updateAll(
			array( 'accessed' => "'" . date("Y-m-d H:i:s") . "'", 'ip_address' => "'" . $_SERVER["REMOTE_ADDR"] . "'"),
			array( 'id' => $this->Auth->user('id'))
		);
		
		$fp = fopen("./log/Schedulex_log.txt","a");
		fwrite($fp, $this->Auth->user('username') . "," . $this->Auth->user('name1') . "," . $this->Auth->user('name2') . "," . date("Y-m-d H:i:s") . "," . $_SERVER["REMOTE_ADDR"] . "\n");
		fclose($fp);
		$this->save_logs();
		$this->redirect(array('controller'=>'schedulex','action'=>'search'));
	}

	private function save_logs(){
		$data = $this->Logs->find('all', array('conditions' => array(
				'username LIKE' => $this->Auth->user('username'),
				'contents LIKE' => "予定表(点検)",
				'accessed >' => date("Y-m-d H:i:s",strtotime("-30 minute"))
				)));
		if(count($data)){
			//debug("1時間以上経ってない");
			return;
		}

		$data['Logs']['id'] = null;
		$data['Logs']['contents'] = "予定表(点検)";
		$data['Logs']['username'] = $this->Auth->user('username');
		$data['Logs']['name1'] = $this->Auth->user('name1');
		$data['Logs']['name2'] = $this->Auth->user('name2');
		$data['Logs']['accessed'] = date("Y-m-d H:i:s");
		$data['Logs']['ip_address'] = $_SERVER['REMOTE_ADDR'];
//print_r($this->data); echo "<br>";
		if(!$this->Logs->save($data)){		//新規作成
			$errors = $this->Logs->invalidFields();
			$mes = '';
			foreach($errors as $field => $message){
				$mes .= $field." : ".$message."<br />\n";
			}
			$this->set('error_message', $mes);
			$this->set('data', $this->data);
		}
	}



	/* =================== 　予定表(点検)検索　 ======================= */
	public function search() {
		$user0 = $this->Auth->user();
		$error_msg = "";
		if($user0['category'] == 0){
			$error_msg = "このメニューは利用ができません。";
			//$this->redirect(array('controller'=>'schedulex','action'=>'index'));
		}
		$this->set('main_title', '予定表(点検)');
		$this->set('sub_title', '検索');

//****		//$this->MakeWorkIntervalTime();

		/* 検索単語の取得 */
		$search = $this->Common->getPost($this, 'Schedulex', 'search');
		$id = $this->Common->getPost($this, 'Schedulex', 'id');

		$work_date = $this->Common->getPost($this, 'Schedulex', 'work_date');

		$work_date1 = $this->Common->getPost($this, 'Schedulex', 'work_date1');
		$work_date2 = $this->Common->getPost($this, 'Schedulex', 'work_date2');
		if(!$work_date1){
			$a = $this->Common->GetModelAll("Schedulex", "work_date");
			if(count($a) > 0)
				$work_date1 = $a[0];
			$this->set('work_date1', 	$work_date1);
		}
//debug($work_date1);

		if(!$work_date2){
			$a = $this->Common->GetModelAll("Schedulex", "work_date");
			if(count($a) > 0)
				$work_date2 = $a[count($a)-1];
			$this->set('work_date2', 	$work_date2);
		}
//debug($work_date2);

		$work_group = $this->Common->getPost($this, 'Schedulex', 'work_group');

		$site_name = $this->Common->getPost($this, 'Schedulex', 'site_name');
		$site_color = $this->Common->getPost($this, 'Schedulex', 'site_color');
		$site_time1 = $this->Common->getPost($this, 'Schedulex', 'site_time1');
		$site_time2 = $this->Common->getPost($this, 'Schedulex', 'site_time2');
		$car_no = $this->Common->getPost($this, 'Schedulex', 'car_no');

		$deploy_name = $this->Common->getPost($this, 'Schedulex', 'deploy_name');

		$note = $this->Common->getPost($this, 'Schedulex', 'note');

		/* pagenation引数取得 */
		$page = $this->Common->getPost($this, 'Schedulex', 'page');
		$direction = $this->Common->getPost($this, 'Schedulex', 'direction');
		$sort = $this->Common->getPost($this, 'Schedulex', 'sort');

		/* 検索単語に基づき条件作成 */
		$condition = array();
		if($id)
			$condition = array_merge_recursive($condition, array("id" => $id));
		if($work_date)
			$condition = array_merge_recursive($condition, array( "work_date like" => '%'.$work_date.'%'));
		if(($work_date1) and ($work_date2))
			$condition = array_merge_recursive($condition, array( 'work_date BETWEEN ? AND ?' => array($work_date1, $work_date2)));

		if($work_group)
			$condition = array_merge_recursive($condition, array( "work_group like" => $work_group));
		if($deploy_name)
			$condition = array_merge_recursive($condition, array( "deploy_name like" => '%'.$deploy_name.'%'));
		if($site_name)
			$condition = array_merge_recursive($condition, array( "site_name like" => '%'.$site_name.'%'));
		if($site_color)
			$condition = array_merge_recursive($condition, array( "site_color like" => '%'.$site_color.'%'));

		if($site_time1)
			$condition = array_merge_recursive($condition, array( "site_time1 like" => $site_time1));
		if($site_time2)
			$condition = array_merge_recursive($condition, array( "site_time2 like" => $site_time2));
		if($car_no)
			$condition = array_merge_recursive($condition, array( "car_no like" => '%'.$car_no.'%'));
		if($note)
			$condition = array_merge_recursive($condition, array( "note like" => '%'.$note).'%');


		$this->set('condition', $condition);
//debug($condition);
		/* 検索単語に基づき引数作成 */
		$searchword = array();
		$searchword = array("search" => $search,
					 "id" => urlencode($id),
				     "work_date" => urlencode($work_date),
				     "work_date1" => urlencode($work_date1),
				     "work_date2" => urlencode($work_date2),
				     "work_group" => urlencode($work_group),
				     "deploy_name" => urlencode($deploy_name),
				     "site_name" => urlencode($site_name),
				     "site_color" => urlencode($site_color),
				     "site_time1" => urlencode($site_time1),
				     "site_time2" => urlencode($site_time2),
				     "car_no" => urlencode($car_no),
				     "note" => urlencode($note),
		);

//debug($condition);
		/* ページネーションの作成 */
		$this->paginate = array(
			'Schedulex' => array(
				'page' => 1,
				'limit' => 60,
				'order' => array('work_date'=>'desc', 'deploy_name'=>'asc', 
				//"CAST(replace(site_time1, ':', '') AS UNSIGNED)" =>'asc',		//desc  asc
				'site_time1',
				), 		// 'id'
				'conditions' => $condition, 
			), 
		);
		$data = $this->paginate('Schedulex');
		$this->set('data', $data);
		$this->set('search', $search);
		$this->set('error_msg', $error_msg);


		$this->set('searchword', $searchword);
		$this->set('argument', $this->Common->array_to_string($searchword));

		$this->set('login_category', $user0['category']);
		$this->set('login_user', $user0);

		$this->set('ExportDateY', date("Y"));
		$this->set('ExportDateM', date("m"));

	}

	function search_update(){
		$this->MakeWorkIntervalTime();
		$this->redirect(array('controller'=>'schedulex','action'=>'search'));
	}

	function MakeWorkIntervalTime(){
		//$data = $this->Schedulex->find('all', array('order' => ['work_date'=>'asc', 'deploy_name'=>'desc', "CAST( DATE_FORMAT(site_time1, '%H%i') AS UNSIGNED)" =>'desc'] ));
		$data = $this->Schedulex->find('all', array('order' => ['work_date'=>'asc', 'deploy_name'=>'asc', 
							"CAST(replace(site_time1, ':', '') AS UNSIGNED)" =>'asc', 
							//'id'=>'asc'
							]));

		//$data = $this->Schedulex->find('all', array('order' => ['id'=>'asc'] ));
			 //'fields' => array('site_time1', "CAST(replace(site_time1, ':', '') AS UNSIGNED) as time"),
//debug($this->Schedulex->getDataSource()->getLog(false, false));
//debug($data);
//exit();
		$work_group = 1;
		for($i=0; $i<count($data); $i++){
			$site_time1 = $data[$i]['Schedulex']['site_time1'];
			$site_time2 = $data[$i]['Schedulex']['site_time2'];
			
			$n1 = strtotime($site_time1);
			$n2 = strtotime($site_time2);
			$h = $n2 - $n1;
			if($h > 0){
				$h += strtotime('2012/01/01');
				$work_time = date("H:i", $h);
			}else{
			  	$work_time = "?";
			}
			$this->Schedulex->set('id', $data[$i]['Schedulex']['id']);
			$this->Schedulex->saveField('work_time', $work_time);

			$work_interval = "";
			if(isset($data[$i+1]['Schedulex']['work_date'])){
				if( ($data[$i+1]['Schedulex']['work_date'] == $data[$i]['Schedulex']['work_date'])
					and ($data[$i+1]['Schedulex']['deploy_name'] == $data[$i]['Schedulex']['deploy_name']) ){
			
					$next_site_time1 = $data[$i+1]['Schedulex']['site_time1'];
			
					if($next_site_time1 <> ""){
						$n1 = strtotime($site_time2);
						$n2 = strtotime($next_site_time1);		//strtotime($data['Schedulex']['site_time1']);
						$h = $n2 - $n1;

//debug($i);
//debug($h);
//debug($site_time2);
//debug($n1);
//debug($next_site_time1);
//debug($n2);

						if($h >= 0){
							$h += strtotime('2012/01/01');
							$work_interval = date("H:i", $h);
						}else{
					  		$work_interval  = "?";		//"?"
//debug($data[$i]['Schedulex']['work_date']);
//debug($site_time2);
//debug($next_site_time1);
//exit();
						}
					}
				}
			}

			if(isset($data[$i-1]['Schedulex']['work_date'])){
				if($data[$i-1]['Schedulex']['work_date'] != $data[$i]['Schedulex']['work_date']){
					$work_group = 1;
				}elseif( ($data[$i-1]['Schedulex']['work_date'] == $data[$i]['Schedulex']['work_date'])
					and ($data[$i-1]['Schedulex']['deploy_name'] != $data[$i]['Schedulex']['deploy_name']) ){
					$work_group += 1;
				}
			}else{
				$work_group = 1;
			}
			$this->Schedulex->set('id', $data[$i]['Schedulex']['id']);
			$this->Schedulex->saveField('work_interval', $work_interval);
			$this->Schedulex->saveField('work_group', $work_group);
		}//end for
		
		$SqlStr = "SET @n := 0";
		$ret = $this->Schedulex->query($SqlStr);
		$SqlStr = "UPDATE schedulex SET id = (@n := @n +1)";
		$ret = $this->Schedulex->query($SqlStr);
		//$this->DispTable($data);
	
	}
	
	function search_export(){
		$year = $this->Common->getPost($this, 'Schedulex', 'ExportDateY');
		//$year = "2022";
		if($year == "")
			$year = "2023";
		// 月を指定
		$month = $this->Common->getPost($this, 'Schedulex', 'ExportDateM');
		//$month = '08';
		//if($month == "")
		//	$month = '08';
		$first_date = date('Y-m-d', strtotime('first day of ' . $year."-".$month));
		//$first_date = "2022-08-01";
//debug($first_date);
		$week_num = date("w", strtotime($first_date));
//debug($week_num);
		if ($week_num == 0){
			//日曜日だった場合
  			$monday1 = date('Y/m/d', strtotime("-6 day", strtotime($first_date)));
		}else{
  			$monday1 = date('Y/m/d', strtotime("-{$week_num} day", strtotime($first_date) + 24*60*60));
		}
//debug($monday1);
//exit();
		//$last_date = date('Y-m-d', strtotime('last day of ' . $year."-".$month));
		$last_date = date('Y-m-d', strtotime('last day of ' . $first_date));
		
//debug("指定月の初日：" . $first_date);
//debug("指定月の末日：" . $last_date);

	//	App::import('Helper', 'Html');
    //    $html = new HtmlHelper();
		//----------------------------
		$xcellFile0 = "schedule.xlsx";
		//----------------------------
		$xcellPath0 = $_SERVER['DOCUMENT_ROOT']."/inabou/app/webroot/files/schedulex/ORG/".$xcellFile0;
		if(file_exists($xcellPath0) == false){
			debug("No exists ExcelFile:".$xcellPath0);
			exit();
		}
//debug($xcellFile0);
		$xcellFile1 = date("Ym", strtotime($first_date))."_".$xcellFile0;

		$xcellPath1 = $this->Common->ConvPath( WWW_ROOT."files/schedulex/".$xcellFile1);
		if(file_exists($xcellPath1)){
			unlink($xcellPath1);
		}
		copy($xcellPath0, $xcellPath1);
		$xcellPath1 = mb_convert_encoding($xcellPath1, "SJIS", "UTF-8");
//debug($xcellPath1);
//exit();
		$conditions = array( 'work_date BETWEEN ? AND ?' => array($first_date, $last_date));
		$orders = array('work_date'=>'asc', 'work_group'=>'asc', 'id'=>'asc');
					//"CAST(replace(site_time1, ':', '') AS UNSIGNED)" =>'asc', 
		$data = $this->Schedulex->find('all', array('conditions' => $conditions, 'order' => $orders));
						//	'deploy_name'=>'asc',
//debug($conditions);
//debug($first_date);
//debug($last_date);
//debug($data);
//exit();
		$data_count = count($data);
//debug($data_count);
//debug($data);
//exit();
		//$a = ["A2", "A18", "A34", "G2", "G18", "G34", "G50"]; //'日にちの配列
		//$b = ["A12", "A28", "A44", "G12", "G28", "G44", "G54"]; //'曜日にちの配列
        $a = ["A4", "A18", "A32", "G4", "G18", "G32", "G46"];	//'日にちの配列
		$b = ["A12", "A26", "A40", "G12", "G26", "G40", "G50"]; //'曜日にちの配列
		$c = ["月", "火", "水", "木", "金", "土", "日"]; //'日にちの配列


		$sheetNames1 = ["A", "B", "C", "D", "E", "F"];
		$sheetNames2 = ["Ａ", "Ｂ", "Ｃ", "Ｄ", "Ｅ", "F"];
		//$sheetNames = ["A", "B", "C", "D", "F"];

		//$book = new PHPExcel();
		//$book = PHPExcel_IOFactory::load($xcellPath1);
		$reader = new Reader();
		$book = $reader->load($xcellPath1);

		$book->getDefaultStyle()->getFont()->setName( 'ＭＳ ゴシック' );
		$book->getDefaultStyle()->getFont()->setSize( 11 );

		$sheetNames = array();
		for($sh=0; $sh<6; $sh++){
//$sh=0;
			// シートの設定を行う
			//$book->getActiveSheet()->setTitle(date("Y年m月d日"));
			//$book->setActiveSheetIndex($sh);
			//$book->getSheetByName($sheet_names($sh));
			//$sheet = $book->getActiveSheet();
			
			if($book->sheetNameExists($sheetNames1[$sh]))
				$sheetNames[$sh] = $sheetNames1[$sh];
			elseif($book->sheetNameExists($sheetNames2[$sh]))
				$sheetNames[$sh] = $sheetNames2[$sh];
			else{
				debug("シートネームエラー[".$sheetNames1[$sh]."],[".$sheetNames1[$sh]."]");
				debug($sh);
				exit();
			}
			$sheet = $book->getSheetByName($sheetNames[$sh]);
			//-----------------------------------------------
			for($i=0; $i<count($a); $i++){
				// セルに値をセットする
				if($i == 0){
					$sheet->setCellValue($a[$i], date("m/j", strtotime($monday1)));
				}else{
					$sheet->setCellValue($a[$i], date("m/j", strtotime("+{$i} day", strtotime($monday1))));
				}
				$sheet->setCellValue($b[$i], $c[$i]);
			}
			$monday1 = date('Y/m/d', strtotime( "+{$i} day", strtotime($monday1) ));
			//-----------------------------------------------
//if($sh == 1) exit();
		}//endfor
        $rows = [4, 18, 32, 4, 18, 32, 46];
        //$rows = [2, 18, 34, 2, 18, 34, 50, 56];
        //$rows = [2, 18, 34, 2, 18, 34, 50];
        $cols = [2,  2,  2, 8,  8,  8, 8];
		
		$n = 0;
		$old_deploy_name = "";
		/******************************/
		for($sh=0; $sh<6; $sh++){
			// シートの設定を行う
			//$book->setActiveSheetIndex($sh);
			//$sheet = $book->getActiveSheet();
			$sheet = $book->getSheetByName($sheetNames[$sh]);
			/******************************/
			for($i=0; $i<count($a); $i++){	//'日にちの配列
//debug($month);
				$mmdd = $sheet->getCell( $a[$i] )->getValue();
				if(($month == 1) and (substr($mmdd, 0, 2)==12))
					$work_date1 = ($year-1)."/".$mmdd;
				else
					$work_date1 = $year."/".$mmdd;
				
				/******************************/
				for($j=0; $j<14; ){		//1日分の行数 7*2
					//$data[$n]['Schedulex'] = $data[$n]['schedulex'];
					if(isset($data[$n]['Schedulex']['work_date']) == false){
debug($data[$n]);
exit();
						break;
					}
					$work_date2 = $data[$n]['Schedulex']['work_date'];
//debug($work_date1);
//debug($work_date2);
//exit();
					$site_color_str = "";
					if(strtotime($work_date1) == strtotime($work_date2)){
						if(is_null($data[$n]['Schedulex']['deploy_name'])){
//debug($data[$n]['Schedulex']);
//exit();
							continue;
						}
						
//debug($data[$n]['Schedulex']['deploy_name']);
						if(($data[$n]['Schedulex']['deploy_name'] != $old_deploy_name)
								 or (is_null($data[$n]['Schedulex']['deploy_name']))
								 or ($data[$n]['Schedulex']['deploy_name'] == "")
								 ){
//debug($data[$n]['Schedulex']['deploy_name']);
//exit();

						// セルに値をセットする
//debug(($cols[$i] -1)."･".($rows[$i] + $j));
//debug($data[$n]['Schedulex']['site_name']);

//debug($data[$n]['Schedulex']['site_color']);
//debug($data[$n]['Schedulex']);
//exit();

							$sheet->setCellValueByColumnAndRow( $cols[$i], $rows[$i] + $j, $data[$n]['Schedulex']['site_name']);
							//縮小して表示
							$sheet->getStyleByColumnAndRow( $cols[$i], $rows[$i] + $j )->getAlignment()->setShrinkToFit(true); 
							
							//カラー表示
							$site_color_str = $data[$n]['Schedulex']['site_color'];
							$sheet->getStyleByColumnAndRow( $cols[$i], $rows[$i] + $j )->getFont()->getColor()->setRGB( $site_color_str );
							
							$sheet->setCellValueByColumnAndRow( $cols[$i] +1, $rows[$i] + $j, $data[$n]['Schedulex']['car_no']);
							$sheet->setCellValueByColumnAndRow( $cols[$i] +2, $rows[$i] + $j, $data[$n]['Schedulex']['deploy_name']);
							$sheet->setCellValueByColumnAndRow( $cols[$i] +3, $rows[$i] + $j, $data[$n]['Schedulex']['note']);

							$j++;
							$sheet->setCellValueByColumnAndRow( $cols[$i], $rows[$i] + $j, $data[$n]['Schedulex']['site_time1']."-".$data[$n]['Schedulex']['site_time2']);
							$sheet->getStyleByColumnAndRow( $cols[$i], $rows[$i] + $j )->getFont()->getColor()->setRGB( 'FF0000' );
							$sheet->getStyleByColumnAndRow( $cols[$i], $rows[$i] + $j )->getFont()->setSize( 9 );
							
							$j++;
							$old_deploy_name = $data[$n]['Schedulex']['deploy_name'];
//exit();
						}else{
//debug($data[$n]['Schedulex']);
//exit();
							if(!($rows[$i] == 4 and $j == 0 and $n == 0))
								$j -= 2;
//debug(($cols[$i] -1)."･".($rows[$i] + $j));

//debug( $sheet->getCellByColumnAndRow( $cols[$i] , $rows[$i] + $j )->getCoordinate());
//debug($rows[$i]);
//debug($j);
//exit();
//debug($data[$n]);

							$site_name_str = $sheet->getCellByColumnAndRow( $cols[$i] , $rows[$i] + $j )->getValue();
							if($site_name_str == "")
								$site_name_str = $data[$n]['Schedulex']['site_name'];
							else
								$site_name_str .= "／".$data[$n]['Schedulex']['site_name'];
							$site_names = explode("／", $site_name_str);
							$sheet->setCellValueByColumnAndRow( $cols[$i] , $rows[$i] + $j, $site_name_str);

							if($site_color_str == "")
								$site_color_str = $data[$n]['Schedulex']['site_color'];
							else
								$site_color_str .= "／".$data[$n]['Schedulex']['site_color'];
							$site_colors = explode( "／", $site_color_str );
							//======================================================================================
//if("コムネット府中美好町（共用部のみ）,横浜チラシ")
							//  リッチテキストで前半はサイズ12で、後半はサイズ20で設定
							$objRichText = new RichText();
							
							for($k=0; $k<count($site_names); $k++){
								if($k <> 0){
									$objTextElm = $objRichText->createTextRun( "／" );
									$objTextElm->getFont()->getColor()->setRGB( "000000" );
								}
								//  リッチテキストに文字列設定
								$objTextElm = $objRichText->createTextRun( $site_names[$k] );
								//  フォントカラー設定
//debug($n);
//debug($site_names);
//debug($site_colors);
//exit();
								if(isset($site_colors[$k])){
									if(!is_null($site_colors[$k]) and $site_colors[$k] <> ""){
//debug($objTextElm->getFont()->getColor());
										$objTextElm->getFont()->getColor()->setRGB( $site_colors[$k] );
									}
								}
 							}
							
//debug($objRichText);
//exit();
							//  [xx]セルに設定
//							$sheet->getCellByColumnAndRow( $cols[$i], $rows[$i] + $j )->setValue($objRichText);
							//======================================================================================

							$j++;
							$site_time =  $sheet->getCellByColumnAndRow( $cols[$i], $rows[$i] + $j )->getValue();
							$sheet->setCellValueByColumnAndRow( $cols[$i], $rows[$i] + $j, $site_time."／".$data[$n]['Schedulex']['site_time1']."-".$data[$n]['Schedulex']['site_time2']);
							$j++;
						}
//debug($n);
//goto xcell_save;
						$n++;
					}else{
						break;
					}
					if($n >= $data_count) break;
//debug($j);
				}	//end og for $j  		//1日分の行数
//debug($i);
//debug($j);
//debug($data[$n]['Schedulex']['deploy_name']);

				if($i == 8){
					debug("ループ・エラー". $i);
//goto xcell_save;
					exit();
				}
				if($n >= $data_count) break;
			}// end of for $i

			//-----------------------------------------------
			if($n >= $data_count) break;
		}//endfor $sh
xcell_save:
		// Excel2007形式で保存する
		//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
		$writer = new Writer($book);
		$writer->save($xcellPath1);
//exit();
	// メモリの解放
		$book->disconnectWorksheets();
		unset($book);
//exit();
		// ファイルのダウンロード
		Configure::write('debug', 0);       // debugコードを非表示
		$dl_file = str_replace("\\", "/", $xcellPath1);
		header('Content-Type: application/force-download');
		header('Content-Length: '.filesize($dl_file));
		header('Content-Disposition: attachment; filename="'.mb_convert_encoding($xcellFile1, 'SJIS-win', 'UTF-8').'"');
		readfile($dl_file);
    	exit;
	}
	
	
	function search_export2(){
		$this->autoRender = false;	//View File なし
		$first_date = $this->Common->getPost($this, 'Schedulex', 'first_date');
//debug($first_date);
		if(strtotime($first_date) < strtotime('2000-01-01')){
			debug($first_date);
			exit();
		}

		$data = $this->Schedulex->find('all', array('conditions' => array( 'work_date LIKE' => $first_date), 
			'order' => ['work_date'=>'asc', 'work_group'=>'asc', "CAST(replace(site_time1, ':', '') AS UNSIGNED)" =>'asc', 'id'=>'asc'] ) );
//debug($data);

		//----------------------------
		$xcellFile0 = "schedule1.xlsx";
		//----------------------------
		$xcellPath0 = $_SERVER['DOCUMENT_ROOT']."/inabou/app/webroot/files/schedulex/ORG/".$xcellFile0;
		if(file_exists($xcellPath0) == false){
			debug("No exists ExcelFile:".$xcellPath0);
			exit();
		}
//debug($xcellFile0);

		$xcellFile1 = date("Ymd", strtotime($first_date))."_".$xcellFile0;

		$xcellPath1 = $this->Common->ConvPath( WWW_ROOT."files/schedulex/".$xcellFile1);
		if(file_exists($xcellPath1)){
			unlink($xcellPath1);
		}
		copy($xcellPath0, $xcellPath1);
		$xcellPath1 = mb_convert_encoding($xcellPath1, "SJIS", "UTF-8");
//debug($xcellPath1);
		$reader = new Reader();
		$book = $reader->load($xcellPath1);


		//$book->getDefaultStyle()->getFont()->setName( 'ＭＳ ゴシック' );
		//$book->getDefaultStyle()->getFont()->setName( 'HG丸ｺﾞｼｯｸM-PRO' );
		$book->getDefaultStyle()->getFont()->setSize( 12 );
		$sheet = $book->getSheetByName("Sheet1");

		$sheet->setCellValueByColumnAndRow( 2, 1, date("Y年m月d日", strtotime($first_date)));

		$n = 1;
		for($i=0; $i<count($data); $i++){
			$sheet->setCellValueByColumnAndRow( 1, $i+3, $n++);
			
			//$sheet->setCellValueByColumnAndRow( 2, $i+3, $data[$i]['Schedulex']['site_name']);
			$site_color = $data[$i]['Schedulex']['site_color'];
//debug($site_color);
			//  リッチテキストで前半はサイズ12で、後半はサイズ20で設定
			$objRichText = new RichText();
			//  リッチテキストに文字列設定
			$objTextElm = $objRichText->createTextRun( $data[$i]['Schedulex']['site_name'] );
			//  フォントカラー設定
			$objTextElm->getFont()->getColor()->setRGB( $site_color );
			$sheet->getCellByColumnAndRow( 2, $i+3, )->setValue($objRichText);
			
			$site_time1 = $data[$i]['Schedulex']['site_time1'];
			$sheet->setCellValueByColumnAndRow( 3, $i+3, $site_time1);
			$site_time2 = $data[$i]['Schedulex']['site_time2'];
			$sheet->setCellValueByColumnAndRow( 4, $i+3, $site_time2);
			
			$work_time = $this->time_diff($site_time1, $site_time2);
			$sheet->setCellValueByColumnAndRow( 5, $i+3, $work_time);
			
			if(isset($data[$i+1]['Schedulex']['site_time1'])){
				$deploy_name1 = $data[$i]['Schedulex']['deploy_name'];
				$deploy_name2 = $data[$i+1]['Schedulex']['deploy_name'];
				if($deploy_name1 == $deploy_name2){
					$site_time1 = $data[$i+1]['Schedulex']['site_time1'];
					$work_interval = $this->time_diff($site_time2, $site_time1);
				}else{
					$work_interval = "";
				}
			}else{
				$work_interval = "";
			}
			$sheet->setCellValueByColumnAndRow( 6, $i+3, $work_interval);

			$sheet->setCellValueByColumnAndRow( 7, $i+3, $data[$i]['Schedulex']['car_no']);
			$sheet->setCellValueByColumnAndRow( 8, $i+3, $data[$i]['Schedulex']['work_group']);
			$sheet->setCellValueByColumnAndRow( 9, $i+3, $data[$i]['Schedulex']['deploy_name']);
			$sheet->setCellValueByColumnAndRow( 10, $i+3, $data[$i]['Schedulex']['note']);
		}
		// サーバに出力
		$writer = new Writer($book);
		$writer->save($xcellPath1);
//debug($xcellPath1);
//exit();
		// メモリの解放
		//$book->disconnectWorksheets();
		//unset($book);

		// ファイルのダウンロード
		//Configure::write('debug', 0);       // debugコードを非表示
		
		$filename = mb_convert_encoding($xcellFile1, 'SJIS-win', 'UTF-8');
		$download_path = str_replace("\\", "/", $xcellPath1);
		$filename=basename($download_path);
		$file_size = filesize($download_path);
		header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
		header("Content-Length: {$file_size}");
		header("Content-Disposition: attachment; filename=$filename");
		ob_end_clean();
		readfile($download_path);   // ファイルを出力する前に、バッファの内容をクリア（ファイルの破損防止）
		exit;
	}


	function time_diff($dt1, $dt2){
		//差を求める日時
		$dateTime1 = '2022-01-01 '.$dt1;
		$dateTime2 = '2022-01-01 '.$dt2;
 
		//DateTimeクラス
		$objDatetime1 = new DateTime($dateTime1);
		$objDatetime2 = new DateTime($dateTime2);

		if($objDatetime1 > $objDatetime2)
			return "?";
		//diffメソッド
		//ふたつの日付の差をあらわす DateInterval オブジェクトを返します。
		$objInterval = $objDatetime1->diff($objDatetime2);
 
		//%Rは + や - の符号を出力するオプションです
		//echo $objInterval->format('%R%H').'時<br/>'; //時
		//echo $objInterval->format('%R%I').'分<br/>'; //分
	
		return $objInterval->format('%H').":".$objInterval->format('%I');
	}



	function DispTable($list){
		//		https://teratail.com/questions/73006

		$header = ["id"=>"id","work_date"=>"作業日","work_group"=>"グループ","deploy_num"=>"配置No",  "deploy_name"=>"配置名",
			"site_name"=>"現場名", "site_color"=>"現場色", "site_time1"=>"現場時間1", "site_time2"=>"現場時間2",
			"work_time"=>"作業時間", "work_interval"=>"移動時間",
			"car_no"=>"車No", "note"=>"備考"];

		$str="";
		$str.="<table>\n";
		$str.="<thead>\n";
		if(is_array($header)){
  			$str.="<tr>\n";
  			foreach($header as $val){$str.="<td>".htmlspecialchars($val)."</td>\n";}
  				$str.="</tr>\n";
		}
		$str.="</thead>\n";
		$str.="<tbody>\n";
		if(is_array($list)){
  			foreach($list as $row){
    			$str.="<tr>\n";
//print_r($row);
    			foreach($row['Schedulex'] as $val){
      				$str.="<td>".htmlspecialchars($val)."</td>\n";
    			}
    			$str.="</tr>\n";
  			}
		}
		$str.="</tbody>\n";
		$str.="</table>\n";
		print $str;
	
	}
	



	function search_import($xcellFile){
		//$path = $this->Common->ConvPath( WWW_ROOT."files/schedulex/R/");
		//$files = glob($path.'*.xlsx');
//debug($xcellFile);
//exit();
		//$excel_file = "R3.5.xls";
		//$xcellFile = $files[0];	//$this->Common->ConvPath( WWW_ROOT."files/schedulex/R/".$excel_file);

		if(file_exists($xcellFile) == false){
			debug("ファイルが存在しない：".$xcellFile);
			exit();
		}
		//if($cmd == "new"){
		//	$sql = "TRUNCATE TABLE `schedulex`";
		//	$this->Schedulex->query($sql);
		//}
		/** PHPExcelを読み込み*/
//		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel.php" );
		/** PHPExcel_IOFactory 出力用のphpを読み込み*/
//		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel/IOFactory.php" );

		//$book = PHPExcel_IOFactory::load($xcellFile);
		$f = explode(".", basename($xcellFile));
//debug($f);
		//if(strstr($f[0], "_schedule")){
		if(false){
			$y = substr($f[0], 0, 4);
			$m = substr($f[0], 4, 2);
		}else{
			$y = intval(preg_replace('/[^0-9]/', '', $f[0])) + 2018;
			$m = $f[1];
		}
		$y1 = $y."-".$m."-1";
		$y2 = date('Y-m-d',strtotime('last day of '.$y1));
		$conditions = array('work_date BETWEEN ? AND ?' => array($y1, $y2));
		$this->Schedulex->deleteAll($conditions);
//debug($y1."-".$y2);
//debug($conditions);
//exit();
		$reader = new Reader();
		$book = $reader->load($xcellFile);
		
		$sheetenames = array("Ａ", "Ｂ", "Ｃ", "Ｄ", "Ｅ", "Ｆ");
		$sheetenames2 = array("A", "B", "C", "D", "E", "F");

		//if(strstr($f[0], "_schedule")){
		if(false){
        	$aDate = ["A2", "A18", "A34", "G2", "G18", "G34", "G50"];	//'配列
        	$rows = [2, 18, 34, 2, 18, 34, 50, 56];
		}else{
	        $aDate = ["A4", "A18", "A32", "G4", "G18", "G32", "G46"];	//'配列
	        $rows = [4, 18, 32, 4, 18, 32, 46];
		}
        $cols = [2,  2,  2, 8,  8,  8, 8];
		
		//$year = "2022";
		$n = 0;
		$old_deploy_name = "";
		$site_colors = array();
		
		//for($sh=0; $sh<5; $sh++){
		for($sh=0; $sh<6; $sh++){		//６ｼｰﾄ
			// シートの設定を行う
			$book->setActiveSheetIndex($sh);
			$sheet = $book->getActiveSheet();
			//-----------------------------------------------
			for($i=0; $i<count($aDate); $i++){		//１シート中の日日分
				$date_val  = $sheet->getCell( $aDate[$i] )->getCalculatedValue();

				$date_val0 = $sheet->getCell( $aDate[$i] )->getCalculatedValue();
//debug($aDate[$i]);
//debug(date('Y-m-d', strtotime($date_val0)));
//exit();
				if($date_val0 == 0 or $date_val0 == null){
					$date_val = "0000-00-00";
				}elseif(strstr($date_val0, "/") and strlen($date_val0) < 6){
					$date_val = date('Y-m-d', strtotime(date("Y")."/".$date_val0));
				}elseif(strstr($date_val0, "/") and strlen($date_val0) > 6){
					$date_val = date('Y-m-d', strtotime($date_val0));
				}else{
//debug($date_val0);
					//$date_val = date('Y-m-d', PHPExcel_Shared_Date::ExcelToPHP( $date_val0 ));
					$date_val = date('Y-m-d', PhpOffice\PhpSpreadsheet\Shared\Date::excelToTimestamp($date_val0));
				}
//debug($date_val);
//exit();

				if ( $date_val != '' ) {
					$data['Schedulex']['work_date'] = $date_val;
				}else{
					$data['Schedulex']['work_date'] = "";
				}
				for($j=0; $j<14; $j++){		//1日分の行数　２＊７
//	https://phpspreadsheet.readthedocs.io/en/latest/

					$site_name1 = trim( $sheet->getCellByColumnAndRow( $cols[$i], $rows[$i] + $j )->getValue() );
					$site_names = explode("／", $site_name1);
					$site_color1 = $sheet->getStyleByColumnAndRow( $cols[$i], $rows[$i] + $j )->getFont()->getColor()->getRGB();
					if($site_names[0] == '' or count($site_names) == 0)
						continue;
//debug($site_name1);
//debug($site_names);
//debug($site_color1);
					$site_colors = array();
					for($k=0; $k<count($site_names); $k++){
						$site_colors[$k] = $site_color1;
						$site_names[$k] = $this->mbtrim($site_names[$k]);
					}

//debug($site_names);
//debug($site_colors);
//exit();
					//$colvl = $sheet->getCellByColumnAndRow( $cols[$i] -1, $rows[$i] + $j )->getValue();
					
					$cell_obj = $sheet->getCellByColumnAndRow( $cols[$i], $rows[$i] + $j );
					$colvl = $cell_obj->getValue();
//debug($colvl);
					$col2 = $cell_obj->getCoordinate();
//debug($cell_obj->getValue());
//debug($col2);

					if(!is_string($cell_obj->getValue())){
//debug($col2);
						$col3 = $cell_obj->getValue()->getRichTextElements(); ///////////////
//debug($col3);
						$txtParts = array();
						$ColorParts = array();
						foreach($col3 as $element){
//debug($element);					
							$txtParts[] = $element->getText();
							if(is_null($element->getFont()))
								$ColorParts[] = $site_color1;
							else
								$ColorParts[] = $element->getFont()->getColor()->getRGB();
					
						}
//debug($txtParts);
//debug($ColorParts);
//exit();

						for($k=0; $k<count($site_names); $k++){
							for($m=0; $m<count($txtParts); $m++){
								if(strstr($txtParts[$m], $site_names[$k])){
									$site_colors[$k] = $ColorParts[$m];
								}
							}
						}
					}
				//	$site_colors = $ColorParts;

//debug($site_names);
//debug($site_colors);
//exit();

//	phpspreadsheet multiple font colors or fonts in one cell
//	phpspreadsheet Get different font-color inside 1 cell using
//	https://stackoverflow.com/questions/68329525/how-to-color-part-of-an-existing-text-in-phpexcel-using-richtext

//exit();
					// 000000 黒
					// 92D050 緑
					// 00B0F0 青
					// FFC000 橙
					// 000000 黒
					
					$data['Schedulex']['car_no'] = $car_no = trim( $sheet->getCellByColumnAndRow( $cols[$i], $rows[$i] + $j )->getValue() );

//					$col2 = $sheet->getCellByColumnAndRow( $cols[$i] +2, $rows[$i] + $j )->getCoordinate();
//debug($col2);
//exit();
					$data['Schedulex']['car_no'] = trim( $sheet->getCellByColumnAndRow( $cols[$i] +1, $rows[$i] + $j )->getValue() );


					$deploy_name = trim( $sheet->getCellByColumnAndRow( $cols[$i] +2, $rows[$i] + $j )->getValue() );
					$data['Schedulex']['deploy_name'] = str_replace("・", "･", $deploy_name);
					
					$data['Schedulex']['note'] = $note = trim( $sheet->getCellByColumnAndRow( $cols[$i] +3, $rows[$i] + $j )->getValue() );

					if($site_name1 <> ""){
						//$site_names = explode("／", $site_name1);
						$j++;
//debug($site_names);
//debug( count($site_names) );
						$site_time1 = trim( $sheet->getCellByColumnAndRow( $cols[$i] -1, $rows[$i] + $j )->getValue() );
						$site_times = $this->explode_time($site_time1);

						for($k=0; $k<count($site_names); $k++){		//1行分割
							$data['Schedulex']['site_name'] = $site_name = $site_names[$k];
							if( isset($site_colors[$k]) )
								$site_color = $site_colors[$k];
							else
								$site_color = $site_color1;

							$data['Schedulex']['site_color'] = $site_color;

							if($site_name <> ""){
								list($data['Schedulex']['site_time1'], $data['Schedulex']['site_time2'])
									= $this->guess_site_time( $site_names, $site_times, count($site_names), count($site_times), $k );
								$data['Schedulex']['id'] = null;
//debug($data);
//exit();
								if(!$this->Schedulex->save($data)){		//追加
									$errors = $this->Schedulex->invalidFields();
									$mes = '';
									foreach($errors as $field => $message){
										$mes .= $field." : ".$message."<br />\n";
									}
									debug('error_message:'.$mes);
								}
							}
						}
//debug($sh);
//debug($i);
//debug($j);

						
					}else{
						$j++;
					}
				}//end of for $j	1日分
//if($date_val== '2023-01-06')
//	exit();

			}//end of for $i	１シート
//exit();						
		}//end of for $sh　　シート
		
		// メモリの解放
		$book->disconnectWorksheets();
		unset($book);

//exit();

		//$this->redirect(array('controller'=>'schedulex','action'=>'search'));

//	https://ameblo.jp/program-se-nikki/entry-12425034289.html

	}


	function time_sort($t){
		$n = count($t);
		if($n <=1)
			return $t;
		for($i=0; $i<$n; $i++)
			$t1[$i] = strtotime($t[$i]);

		sort($t1);
		for($i=0; $i<$n; $i++)
			$t2[$i] = date("H:i", $t1[$i]);

		return $t2;
	
	}

	function guess_site_time($site_names, $site_times, $count_names, $count_times, $k){
/*
		if(!isset($site_times[$k]))
			return array("", "");
		if($site_times[$k] == "")
			return array("", "");
*/
		if(!isset($site_names[$k]))
			return array("", "");
		if($site_names[$k] == "")
			return array("", "");

		if($count_names == 1 ){
			if(isset($site_times[$k]))
				return array($site_times[$k], "16:30");
			else
				return array("9:30", "16:30");
		}
			
		if($count_names == 2 and $count_times == 0 and $k == 0)
			return array("9:30", "12:00");
		if($count_names == 2 and $count_times == 0 and $k == 1)
			return array("13:00", "16:30");

		if($count_names == 2 and $count_times == 1){
			if( strtotime($site_times[0]) <= strtotime("9:30") and $k == 0)
				return array($site_times[0], "12:00");
			elseif( $k == 1 )
				return array($site_times[0], "16:30");
			else
				return array("13:00", "16:30");
		}
		if($count_names == 2 and $count_times == 2){
			if( strtotime($site_times[0]) <= strtotime("9:30") and $k == 0)
				return array($site_times[0], "12:00");
			elseif( $k == 1 )
				return array($site_times[1], "16:30");
			else
				return array("13:00", "16:30");
		}

		if($count_names == 3 and $count_times == 0 and $k == 0)
			return array("9:30", "12:00");
		if($count_names == 3 and $count_times == 0 and $k == 1)
			return array("13:00", "15:00");
		if($count_names == 3 and $count_times == 0 and $k == 2)
			return array("15:00", "16:30");

		if($count_names == 3 and $k<$count_times-1)
			return array($site_times[$k], $site_times[$k+1]);

		if($count_names == 3 and $k == $count_times-1){
			if(strtotime($site_times[$k]) < strtotime("13:30"))
				return array($site_times[$k], "15:00");
			elseif(strtotime($site_times[$k]) < strtotime("16:30"))
				return array($site_times[$k], "16:30");
			else
				return array($site_times[$k], "");
		}

		if($count_names == 3 and $k > $count_times-1)
			return array("", "");

		
		if($count_names == 4 and $count_times == 0 and $k == 0)
			return array("9:30", "10:00");
		if($count_names == 4 and $count_times == 0 and $k == 1)
			return array("10:00", "12:00");
		if($count_names == 4 and $count_times == 0 and $k == 2)
			return array("13:00", "15:00");
		if($count_names == 4 and $count_times == 0 and $k == 2)
			return array("15:00", "16:30");

		if($count_names == 4 and $k<$count_times-1)
			return array($site_times[$k], $site_times[$k+1]);
		if($count_names == 4 and $k == $count_times-1){
			if(strtotime($site_times[$k]) < strtotime("16:30"))
				return array($site_times[$k], "16:30");
			else
				return array($site_times[$k], "");
		}
		if($count_names == 4 and $k > $count_times-1)
			return array("", "");


		if($count_names == 5 and $count_times == 0 and $k == 0){
			return array("9:30", "10:00");
		}elseif($count_names == 5 and $count_times == 0 and $k == 1){
			return array("10:00", "12:00");
		}elseif($count_names == 5 and $count_times == 0 and $k == 2){
			return array("13:00", "14:00");
		}elseif($count_names == 5 and $count_times == 0 and $k == 3){
			return array("14:00", "15:00");
		}elseif($count_names == 5 and $count_times == 0 and $k == 4){
			return array("15:00", "16:30");


		}elseif($count_names == 6 and $count_times == 0 and $k == 0){
			return array("9:30", "10:00");
		}elseif($count_names == 6 and $count_times == 0 and $k == 1){
			return array("10:00", "11:00");
		}elseif($count_names == 6 and $count_times == 0 and $k == 2){
			return array("11:00", "12:00");
		}elseif($count_names == 6 and $count_times == 0 and $k == 3){
			return array("13:00", "14:00");
		}elseif($count_names == 6 and $count_times == 0 and $k == 4){
			return array("14:00", "15:00");
		}elseif($count_names == 6 and $count_times == 0 and $k == 5){
			return array("15:00", "16:30");

		}elseif($count_names == 7 and $count_times == 0 and $k == 0){
			return array("9:30", "10:00");
		}elseif($count_names == 7 and $count_times == 0 and $k == 1){
			return array("10:00", "10:30");
		}elseif($count_names == 7 and $count_times == 0 and $k == 2){
			return array("10:30", "11:00");
		}elseif($count_names == 7 and $count_times == 0 and $k == 3){
			return array("11:00", "12:00");
		}elseif($count_names == 7 and $count_times == 0 and $k == 4){
			return array("13:00", "14:30");
		}elseif($count_names == 7 and $count_times == 0 and $k == 5){
			return array("14:30", "15:00");
		}elseif($count_names == 7 and $count_times == 0 and $k == 6){
			return array("15:00", "16:30");
		
		}else{
debug($site_names);
debug($site_times);
debug("count_names=".$count_names);
debug("count_times=".$count_times);
debug("k=".$k);
exit();
		}
	
	}
	
	function explode_time($t){
		$t = trim($t);
		if($t == "")
			return array();
		$t = str_replace(array("　", "～"), " ", $t);
		$t1 = mb_convert_kana( $t, "ask");
		$a = explode(" ", $t1);
//debug($t1);
//debug($a);
//exit();

		$j = 0;
		for($i=0; $i<count($a); $i++){
//debug($a[$i]);
			if($a[$i] <> ""){
				$b[$j] = $this->Common->ConvTime( trim($a[$i]) );
//debug($b[$j]);
				$j++;
			}
		}
//debug($b);
//exit();

//if( ($this->data['Schedulex']['work_date'] == "2022-08-29") and ( strstr($this->data['Schedulex']['site_name'], "ヴァンベールA・B")) ){
//if( ($this->data['Schedulex']['work_date'] == "2022-08-07") and ( strstr($this->data['Schedulex']['site_name'], "朝日シティパリオ西巣鴨")) ){
//	debug($b);
//	debug($this->data['Schedulex']['work_date']);
//	debug($this->data['Schedulex']['site_name']);
//	exit();
//}
		return $b;
	}



	

	/* =================== 予定表(点検)詳細 ======================= */
	function search_detail($arg=""){
		$user0 = $this->Auth->user();
		$error_msg = "";
		if($user0['category'] == 0){
			$error_msg = "このメニューは利用ができません。";
			//$this->redirect(array('controller'=>'schedulex','action'=>'index'));
		}

		$this->set('main_title', '予定表(点検)');
		$this->set('sub_title', '予定表(点検)　＞　詳細');

		if($arg){
			$this->Schedulex->id = $arg;
			$this->Quotation->id = $arg;
		}else{
			$this->Schedulex->id = $this->Common->getPost($this, 'Schedulex', 'id');
		}
		if(empty($this->data)){
			$this->data = $this->Schedulex->read();	//読み出し
			$this->data2 = $this->Quotation->read();	//読み出し
//print_r($this->data);
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
			$this->set('data2', $this->data2);
		}else{
		}
		$this->set('login_category', $user0['category']);
		$this->set('error_msg', $error_msg);
	}
	
	/* =================== 予定表(点検)修正 ======================= */
	function edit($arg=""){
		$arg1 = $arg;
//debug($arg);
//debug($arg1);

		$user0 = $this->Auth->user();

		$this->set('main_title', '予定表(点検)');
		$this->set('sub_title', '予定表(点検)　＞　修正');

		if($arg)
			$this->Schedulex->id = $arg;
		else
			$this->Schedulex->id = $this->Common->getPost($this, 'Schedulex', 'id');
//exit();
		if(empty($this->data)){
			$this->data = $this->Schedulex->read();	//読み出し
			$this->set('data', $this->data);
		}else{
			$button2 = $this->Common->getPost($this, 'Schedulex', 'button2');

//debug($button2);			
//debug($deploy_name3);			
			$a = array();
			$n = 0;
			for($i=0; $i<8;  $i++){
				$s = $this->request->data['Schedulex']['deploy_name'. $i];
				if($s<>"" and !in_array($s, $a)){
					$a[$n++] = $s;
				}
			}
			$deploy_name = implode("･", $a);

			if(strstr($button2,"選択値更新")){
				//$deploy_name = $this->ConvDeployName($deploy_name1.",".$deploy_name3);

				$data = $this->Schedulex->read();	//読み出し
				$data['Schedulex']['deploy_name'] = $deploy_name;
//debug($data);
				$this->Schedulex->save($data['Schedulex']);
				$data = $this->Schedulex->read();	//読み出し
				$this->set('data', $data);

//debug($this->request->data);
//debug($names);
//exit();

			}elseif(strstr($button2,"更新")){
				//$this->data['Schedulex']['deploy_name'] = $deploy_name;
				
				$temp = $this->data;
				$temp['Schedulex']['work_interval'] = "";
				$temp['Schedulex']['deploy_name'] = $deploy_name;
				$this->data = $temp;
//debug($this->data);
//exit();
				if(!$this->Schedulex->save($this->data['Schedulex'])){		//更新
					$errors = $this->Schedulex->invalidFields();
					$mes = '';
					foreach($errors as $field => $message){
						$mes .= $field." : ".$message."<br />\n";
					}
					$this->set('error_message', $mes);

					//$this->data = $this->Common->utf82sjis($this->data);
					$this->set('data', $this->data);
				}else{
					//$this->redirect(array('controller'=>'schedulex','action'=>'search'));
				}
			}
			$data = $this->Schedulex->read();	//読み出し
			if(isset($deploy_name))
				$data['Schedulex']['deploy_name'] = $deploy_name;
			$this->set('data', $data);
		}
		
		$this->set('user_names', $this->GetUser3All(1));
		$this->set('login_category', $user0['category']);
		$this->set('next_site_time1', $this->GetNextSiteTime1($arg1, $this->data));
		$this->set('main_menu_no');
	}
	
	private function GetUser3All($division=0){
		$ret = $this->User->find('all', array('fields' => array('name1', 'name2', 'initial'), 
				'conditions' => array('division' => array($division, 3)), 
				'order' => array('id' => 'asc')));
		$count = count($ret);
//debug($count);
		for($i=0; $i<$count; $i++){
			$names[0][$i] = $ret[$i]['User']['name1']. " " . $ret[$i]['User']['name2'];
			$names[1][$i] = $ret[$i]['User']['initial'];
		}
//debug($names);
		return $names;
	}



	function ConvDeployName($deploy_names){
		$a = explode(",", $deploy_names);
		for($i=0; $i<count($a); $i++){
			$b = explode(" ", $a[$i]);
			if($i == 0){
				$e = $b[0];
				$f = $b[1];
			}else{
				$c[$i-1] = $b[0];
				$d[$i-1] = $b[1];
			}
		}
		
		$ret1 = $this->User->find('first', array('fields' => array('initial'), 'conditions' => array('name1' => $e, 'name2' => $f)));
//debug($ret1);
		$n[0] = $ret1['User']['initial'];
		if(count($a)==1)
			return $n[0];

		$ret = $this->User->find('all', array('fields' => array('initial'), 'conditions' => array('name1' => $c, 'name2' => $d)));
		for($i=0; $i<count($ret); $i++){
			$n[$i+1] = $ret[$i]['User']['initial'];
		}
		return implode("･", $n);
	}
	
	
	
	function GetNextSiteTime1($arg1, $data1){
//debug($arg1);
		$data2 = $this->Schedulex->find('first', array('conditions' => array('id' => $arg1)));
//debug($data1);
//debug($data2);
//exit();
		if($data2['Schedulex']['work_date'] == $data1['Schedulex']['work_date']){
			if(isset($data2['Schedulex']['work_group']) and isset($data1['Schedulex']['work_group'])){
				if($data2['Schedulex']['work_group'] == $data1['Schedulex']['work_group']){
					return $data2['Schedulex']['site_time1'];
				}
			}
		}
		return "";
	}

	/* =================== 予定表(点検)削除 ======================= */
	function delete($arg=""){
		$user0 = $this->Auth->user();
		if($user0['category'] < 5){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'Schedulex','action'=>'index'));
		}

		$this->set('main_title', '予定表(点検)');
		$this->set('sub_title', '予定表(点検)　＞　削除');

		if($arg)
			$this->Schedulex->id = $arg;
		else
			$this->Schedulex->id = $this->Common->getPost($this, 'Schedulex', 'id');

		if(empty($this->data)){
			$this->data = $this->Schedulex->read();	//読み出し
			$this->set('data', $this->data);
		}else{
			$this->set('data', $this->data);

			if(!$this->Schedulex->delete($this->Schedulex->id)){		//削除
				$errors = $this->Schedulex->invalidFields();
				$mes = '';
				foreach($errors as $field => $message){
					$mes .= $field." : ".$message."<br />\n";
				}
				$this->set('error_message', $mes);
			}else
				$this->redirect(array('controller'=>'schedulex','action'=>'search'));
		}
		$this->set('login_category', $user0['category']);
	}
	/* =================== 予定表(点検)新規作成 ======================= */
	function search_new($arg=""){
		if($arg)
			$this->Schedulex->id = $arg;
		else
			$this->Schedulex->id = $this->Common->getPost($this, 'Schedulex', 'id');

		$user0 = $this->Auth->user();

		$this->set('main_title', '予定表(点検)');
		$this->set('sub_title', '予定表(点検)　＞　新規作成');

		if(empty($this->data)){
			$lastID = $this->Schedulex->getLastInsertID();
			if($lastID <= 0){
				$d = $this->Schedulex->find('first', array('fields' => array('Max(id) as max_id')));
				$lastID = $d[0]['max_id'];
			}
			$this->data = $this->Schedulex->find('first', array('conditions' => array('id' => $lastID)));

		}else{
			$button2 = $this->Common->getPost($this, 'Schedulex', 'button2');
			$deploy_name1 = $this->Common->getPost($this, 'Schedulex', 'deploy_name1');
			$deploy_name2 = $this->Common->getPost($this, 'Schedulex', 'deploy_name2');
			$deploy_name3 = $this->Common->getPost($this, 'Schedulex', 'deploy_name3');

//debug($button2);			
//debug($deploy_name3);			
			$a = array();
			$n = 0;
			for($i=0; $i<8;  $i++){
				$s = $this->request->data['Schedulex']['deploy_name'. $i];
				if($s<>"" and !in_array($s, $a)){
					$a[$n++] = $s;
				}
			}
			$deploy_name = implode("･", $a);

			if(strstr($button2, "選択値更新")){

				$data = $this->Schedulex->read();	//読み出し
				$data['Schedulex']['deploy_name'] = $deploy_name;
//debug($data);
				$this->Schedulex->save($data['Schedulex']);
				$data = $this->Schedulex->read();	//読み出し
				$this->set('data', $data);
				
			}else{
				$temp = $this->data;
				$temp['Schedulex']['work_interval'] = "";
				$temp['Schedulex']['deploy_name'] = $deploy_name;
				$this->data = $temp;

				$temp = $this->data;
				$temp['Schedulex']['id'] = null;
				$this->data = $temp;

//debug($this->data['Schedulex']);
//exit();

				if(!$this->Schedulex->save($this->data)){		//新規作成
					$errors = $this->Schedulex->invalidFields();
					$mes = '';
					foreach($errors as $field => $message){
						$mes .= $field." : ".$message."<br />\n";
					}
					$this->set('error_message', $mes);

					$this->set('data', $this->data);
				}else{
					$this->redirect(array('controller'=>'schedulex','action'=>'search'));

					$lastID = $this->Schedulex->getLastInsertID();
					if($lastID <= 0){
						$d = $this->Schedulex->find('first', array('fields' => array('Max(id) as max_id')));
						$lastID = $d[0]['max_id'];
					}
					$this->data = $this->Schedulex->find('first', array('conditions' => array('id' => $lastID)));
				}
			}
		}
		$this->set('data', $this->data);
		$this->set('user_names', $this->GetUser3All(1));
		$this->set('login_category', $user0['category']);
	}



	public function upload() {
		if(isset($_POST['submit'])) {
    		if(isset($_FILES['uploadFile']['name']) && $_FILES['uploadFile']['name'] != "") {
        		$allowedExtensions = array("xls","xlsx");
        		$ext = pathinfo($_FILES['uploadFile']['name'], PATHINFO_EXTENSION);
		
				if(in_array($ext, $allowedExtensions)) {
//debug($ext);
//exit();
					// Uploaded file
               		
					$file = WWW_ROOT."files/schedulex/R/".$_FILES['uploadFile']['name'];
//debug($ext);
//exit();
					
               		$isUploaded = copy($_FILES['uploadFile']['tmp_name'], $file);
			   		// check uploaded file
               		if($isUploaded) {
//debug($isUploaded);
//exit();
//debug($file);
//exit();
						$this->search_import($file);
						$this->MakeWorkIntervalTime();
//debug($ext);
//exit();
						$this->redirect(array('controller'=>'schedulex','action'=>'search'));
					}
//debug($ext);
//exit();
	            	unlink($file);
                    echo '<span class="msg">File not uploaded!</span>';
					exit();
                } else {
                    echo '<span class="msg">File not uploaded!</span>';
					exit();
                }
//debug($ext);
//exit();
        	} else {
            	echo '<span class="msg">Please upload excel sheet1.</span>';
				exit();
        	}
    	} else {
        	echo '<span class="msg">Please upload excel file2.</span>';
			exit();
    	}
	}

	private function xlsx_save_proc($up_file){
		//e(Classes."phpexcel/PHPExcel.php");
		/** Main Class */
//		require_once Classes."phpexcel/PHPExcel.php";
		/** IO Class */
//		require_once Classes."phpexcel/PHPExcel/IOFactory.php";

		//Configure::write('debug', 2);  // debugコードを出す
		$sql = "TRUNCATE TABLE `schedulex`";
		$this->Schedulex->query($sql);

        //データの読み込み
//		$readData = $this->Excel->readXls($up_file, 9);	
		$reader = new Reader();
		$book = $reader->load($up_file);

		// param string $filepath,  int $colCount (Optional),  int $rowCount (Optional),  mix $sheetIndex (Optional)
//debug($readData[0]['data']);
		$k = 0;
		$data = array();
		for($i=2; $i<=count($readData[0]['data']); $i++){
			$data['Schedulex'][] = array(
						'year' => $readData[0]['data'][$i][0],
						'month' => $readData[0]['data'][$i][1],
						'day' => $readData[0]['data'][$i][2],
						'from_time' => $this->Excel->num2time( $readData[0]['data'][$i][3] ),
						'to_time' => $this->Excel->num2time( $readData[0]['data'][$i][4] ),
						'title' => $readData[0]['data'][$i][5],
						'member' => $readData[0]['data'][$i][6],
						'mail' => $readData[0]['data'][$i][7],
						'place' => $readData[0]['data'][$i][8],
						'message' => $readData[0]['data'][$i][9]
						);
			
			$k++;
		}
//debug($data);
		if(!$this->Schedulex->saveAll($data['Schedulex'], array('atomic' => false))){		//更新
			$errors = $this->Schedulex->invalidFields();
			$mes = '';
			foreach($errors as $field => $message){
				$mes .= $field." : ".$message."<br />\n";
			}
			$this->set('error_message', $mes);
		}else{
			if($this->Schedulex->find('count') > 0){
				$this->set('error_message', "ファイル・アップロードに成功しました。");
			}else{
				$this->set('error_message', "ファイル・アップロードに失敗しました。");
debug($this->Schedulex->getAffectedRows());
			}

		}

	}

	private function csv_save_proc($up_file){
		$sql = "TRUNCATE TABLE `schedulex`";
//		$this->Schedulex->query($sql);

		$handle = @fopen($up_file, "r");
		if ($handle) {
			$line = "";
		    while (!feof($handle)) {
		        $buf = fgets($handle, 4096);
//echo "buf=[".$buf."]<hr>";
				$last = substr($buf, -3);
//echo "last=[".$last."]<hr>";
//echo "last=[".bin2hex($last)."]<hr>";
				if(($last == "\x22\x0d\x0a") || ($last == "\x22\x0a")){
					$line .= "\x22";
//echo $line."<hr>";
		//			$this->Common->save_csv_line($this->Schedulex, $line);
					$line = "";
				}else
					$line .= $buf;
		    }
		    fclose($handle);
			$this->set('error_message', "ファイル・アップロードに成功しました。");
		}
	}

	public function today(){

		if(isset($this->request->data['day_add'])){
//debug($this->request->data);
			$today = $this->request->data['today'];
//debug($today);
			$day = new DateTime(date("Y/m/d"));
			$day2 = new DateTime($today);
			$diff = $day->diff($day2);

			$day_add = $diff->days;
			if($day > $day2)
				$day_add = $day_add * -1;
//debug($day_add);
			
			if($this->request->data['day_add'] == 1)
				$day_add++;
			elseif($this->request->data['day_add'] == -1)
				$day_add--;
			else
				$day_add = 0;
		}else{
			$today = date("Y年m月d日");
			$day_add = 0;
		}

//debug($today);
//debug($day_add);
		$today = date("Y-m-d", strtotime(" +".$day_add." day"));

		$weeks = array( "日", "月", "火", "水", "木", "金", "土" );
		$week = $weeks[date("w", strtotime($today))];

		$this->set('main_title', $today."(".$week.") の予定表(点検)");
		$this->set('sub_title', '予定表(点検)　＞　'.$today."(".$week.")");

		$first_date = $today." 00:00:00";
		$last_date  = $today." 23:59:59";

		$conditions = array( 'work_date BETWEEN ? AND ?' => array($first_date, $last_date));
		$order = ['work_date'=>'asc', 'work_group'=>'asc', "CAST(replace(site_time1, ':', '') AS UNSIGNED)" =>'asc', 'id'=>'asc'];
		
		/* ページネーションの作成 */
		$this->paginate = array(
			'Schedulex' => array(
				'page' => 1,
				'limit' => 20,
				'order' => $order,
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('Schedulex');
//debug($data);
		$this->set('data', $data);
		$this->set('today', $today);
	}

	public function upload2() {
		if(isset($_POST['submit'])) {
    		if(isset($_FILES['uploadFile']['name']) && $_FILES['uploadFile']['name'] != "") {
        		$allowedExtensions = array("xls","xlsx");
        		$ext = pathinfo($_FILES['uploadFile']['name'], PATHINFO_EXTENSION);
		
				if(in_array($ext, $allowedExtensions)) {
					// Uploaded file
               		
					$file = WWW_ROOT."files/schedulex/".$_FILES['uploadFile']['name'];
					
               		$isUploaded = copy($_FILES['uploadFile']['tmp_name'], $file);
			   		// check uploaded file
               		if($isUploaded) {
//debug($file);
//exit();
						$this->search_import2($file);
						$this->MakeWorkIntervalTime();
						$this->redirect(array('controller'=>'schedulex','action'=>'today'));
					}
	            	unlink($file);
                    echo '<span class="msg">File not uploaded!</span>';
					exit();
                } else {
                    echo '<span class="msg">File not uploaded!</span>';
					exit();
                }
        	} else {
            	echo '<span class="msg">Please upload excel sheet1.</span>';
				exit();
        	}
    	} else {
        	echo '<span class="msg">Please upload excel file2.</span>';
			exit();
    	}
	}

	function search_import2($xcellFile0){
		$xcellFile = str_replace("\\", "/", $xcellFile0);
//debug($xcellFile);
//exit();
		if(file_exists($xcellFile) == false){
			debug("ファイルが存在しない：".$xcellFile);
			exit();
		}

		$fn = basename($xcellFile);
		$y = substr($fn, 0, 4);
		$m = substr($fn, 4, 2);
		$d = substr($fn, 6, 2);
		$dt = $y."-".$m."-".$d;
//debug($dt);
		$conditions = array('work_date LIKE' => $dt);
		$this->Schedulex->deleteAll($conditions);

		$reader = new Reader();
		$book = $reader->load($xcellFile);

		$n = 0;
		$old_deploy_name = "";
		$site_colors = array();
		
		if($book->sheetNameExists("Sheet1") === false){
		    die("指定されたシートは存在しません [".$sh."]");
		}
//debug("Sheet1");
		$sheet = $book->getSheetByName("Sheet1");
		//$sheet = $book->getActiveSheet();
		//-----------------------------------------------
		$date1 = $sheet->getCell('B1')->getValue();
//debug($date1);
		$date1 = $sheet->getCellByColumnAndRow( 2, 1)->getValue();
//debug($date1);
//exit();
		foreach ($sheet->getRowIterator() as $row) {
			$n = $sheet->getCellByColumnAndRow( 1, $row->getRowIndex() )->getValue();
//debug($n);
			if($n == "日付" or $n == "連番")
				continue;
			if($n == null)
				break;
			if($n > 0){
				$data['site_name'] = trim( $sheet->getCellByColumnAndRow( 2, $row->getRowIndex() )->getValue());
//debug($data['site_name']);
				$data['site_color'] = $sheet->getStyleByColumnAndRow( 2, $row->getRowIndex() )->getFont()->getColor()->getRGB();
				//$data['site_color'] = $sheet->getStyle('B3')->getFill()->getStartColor()->getRGB();
//debug($data['site_color']);
//exit();

				$data['site_time1'] = $this->get_time( $sheet->getCellByColumnAndRow( 3, $row->getRowIndex() )->getValue());
				$data['site_time2'] = $this->get_time( $sheet->getCellByColumnAndRow( 4, $row->getRowIndex() )->getValue());
//debug($data['site_time1']);
//debug($data['site_time2']);

				$data['work_time'] = $this->time_diff($data['site_time1'], $data['site_time2']);

				$site_time1a = $this->get_time( $sheet->getCellByColumnAndRow( 3, $row->getRowIndex() +1 )->getValue() );
				if(strlen($site_time1a) > 1){
					$deploy_name1 = $sheet->getCellByColumnAndRow( 9, $row->getRowIndex() )->getValue();
					$deploy_name2 = $sheet->getCellByColumnAndRow( 9, $row->getRowIndex() +1 )->getValue();
					if($deploy_name1 == $deploy_name2){
						$data['work_interval'] = $this->time_diff($data['site_time2'], $site_time1a);
					}else{
						$data['work_interval'] = "";
					}
				}else{
					$data['work_interval'] = "";
				}

				$data['car_no'] = trim( $sheet->getCellByColumnAndRow( 7, $row->getRowIndex() )->getValue() );

				$data['work_group'] = trim( $sheet->getCellByColumnAndRow( 8, $row->getRowIndex() )->getValue() );
				$data['deploy_name'] = trim( $sheet->getCellByColumnAndRow( 9, $row->getRowIndex() )->getValue() );
				$data['note'] = trim( $sheet->getCellByColumnAndRow( 10, $row->getRowIndex() )->getValue() );
				
				$data['work_date'] = $dt;
				$data['id'] = null;
//debug($data);
//exit();
				if(!$this->Schedulex->save($data)){		//更新
					debug("DBエラー");
				}
			}
//debug($data);
//exit();
		}
					// 000000 黒
					// 92D050 緑
					// 00B0F0 青
					// FFC000 橙
					// 000000 黒
					
		// メモリの解放
		$book->disconnectWorksheets();
		unset($book);
//exit();
		$this->redirect(array('controller'=>'schedulex','action'=>'today'));
	}



	function get_time($t){
		if(strstr($t, ":"))
			return $t;

//debug($t);
//debug(PhpOffice\PhpSpreadsheet\Shared\Date::excelToTimestamp($t) + strtotime("2022/1/1"));
		$t1 = date('H:i', PhpOffice\PhpSpreadsheet\Shared\Date::excelToTimestamp($t)  + strtotime("2022/1/1"));
//debug($t1);
//exit();
		return $t1;
	
	}

	function db_clear(){
		$this->autoRender = false;	//View File なし
//		$sql = "TRUNCATE TABLE `schedulex`";
//		$this->Schedulex->query($sql);

		$this->Schedulex->truncate();
		$this->redirect(array('controller'=>'schedulex','action'=>'search'));
	}


	function mbtrim($str) {
    	return preg_replace("/(^\s+)|(\s+$)/u", "", $str);
	}


}