<?php
//	http://localhost:81/inabou/purchase/
//  http://p7.inabous.net/inabou/purchase/


// Excel出力用ライブラリ
//App::import( 'Vendor', 'PHPExcel', array('file'=>'phpexcel' . DS . 'PHPExcel.php') );
//App::import( 'Vendor', 'PHPExcel_IOFactory', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'IOFactory.php') );
//App::import( 'Vendor', 'PHPExcel_Cell_AdvancedValueBinder', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Cell' . DS . 'AdvancedValueBinder.php') );
// Excel95用ライブラリ
//App::import( 'Vendor', 'PHPExcel_Writer_Excel5', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Writer' . DS . 'Excel5.php') );
//App::import( 'Vendor', 'PHPExcel_Reader_Excel5', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Reader' . DS . 'Excel5.php') );

// Excel2007用ライブラリ
//App::import( 'Vendor', 'PHPExcel_Writer_Excel2007', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Writer' . DS . 'Excel2007.php') );
//App::import( 'Vendor', 'PHPExcel_Reader_Excel2007', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Reader' . DS . 'Excel2007.php') );


if(file_exists('D:\xampp\htdocs\vendor\autoload.php'))
	require 'D:\xampp\htdocs\vendor\autoload.php';
else
	require '/home/enzbaoev/public_html/p7/vendor/autoload.php';

//use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx as Writer;
use PhpOffice\PhpSpreadsheet\Reader\Xlsx as Reader;
use PhpOffice\PhpSpreadsheet\RichText\RichText as RichText; //RichTextAPIを使用
use PhpOffice\PhpSpreadsheet\Style;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;


App::uses('AppController', 'Controller');
App::import('Vendor', 'util/common');


class PurchaseController extends AppController {
	public $name = 'Purchase';
	public $uses = array('User', 'Purchase', 'Quotation', 'Logs', 'Delicom', 'Delicom2');
	//public $layout = 'dafault';
	public $layout = 'purchase';
	//public $layout = 'delivery';

	public $components = array('Auth', 'Common');	//'Session', , 'Mail', 'Email' , 'Qdmail', 'Excel'
	public $helpers = array('Common');	//'Javascript', , 'Tabular' , 'Calender', 'Holiday', 'Html', 'Form'

	public $_dir = "/inabou/";
	public $_url = "";
	public $_path = WWW_ROOT;

	public $URL_SELF;
	private $debug = false;

	public $_debug = true;

    function beforeFilter() {

		$this->set('main_title', "発注書");
		$this->set('error_message', null);
		$this->set('data_error', false);
		$this->set('data_error_msg', "");
		//parent::beforeFilter();
		//$this->Auth->allow();
		date_default_timezone_set('Asia/Tokyo');

		$this->_dir = "/inabou/";
		$this->set('_dir', $this->_dir);
		
		$this->_url = FULL_BASE_URL.$this->_dir;
		$this->set('_url', $this->_url);

		$this->_path = WWW_ROOT;
		$this->set('_path', $this->_path);

		$main_title = "発注メニュー管理";
		$this->set('main_title', $main_title);

		if(strstr($_SERVER['SERVER_NAME'], "localhost"))
			$this->URL_SELF = "http://localhost:81".$this->_dir;
		else
			$this->URL_SELF = "http://".$_SERVER['SERVER_NAME'].$this->_dir;
    }

	public function index($main_menu="", $main_year=""){
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);
exit();
		date_default_timezone_set('Asia/Tokyo');
		$this->Purchase->updateAll(
			array( 'accessed' => "'" . date("Y-m-d H:i:s") . "'", 'ip_address' => "'" . $_SERVER["REMOTE_ADDR"] . "'"),
			array( 'id' => $this->Auth->user('id'))
		);
		
		$fp = fopen("./log/purchase_log.txt","a");
		fwrite($fp, $this->Auth->user('username') . "," . $this->Auth->user('name1') . "," . $this->Auth->user('name2') . "," . date("Y-m-d H:i:s") . "," . $_SERVER["REMOTE_ADDR"] . "\n");
		fclose($fp);
		$this->save_logs();
		$this->redirect(array('controller'=>'purchase','action'=>'search'));
	}

	private function save_logs(){
		$count = $this->Logs->find('count', array('conditions' => array(
				'username LIKE' => $this->Auth->user('username'),
				'contents LIKE' => "発注書",
				'accessed >' => date("Y-m-d H:i:s",strtotime("-30 minute"))
				)));
		if($count){
			//debug("1時間以上経ってない");
			return;
		}

		$this->data['Logs']['id'] = null;
		$this->data['Logs']['contents'] = "発注書";
		$this->data['Logs']['username'] = $this->Auth->user('username');
		$this->data['Logs']['name1'] = $this->Auth->user('name1');
		$this->data['Logs']['name2'] = $this->Auth->user('name2');
		$this->data['Logs']['accessed'] = date("Y-m-d H:i:s");
		$this->data['Logs']['ip_address'] = $_SERVER['REMOTE_ADDR'];
//print_r($this->data); echo "<br>";
		if(!$this->Logs->save($this->data)){		//新規作成
			$errors = $this->Logs->invalidFields();
			$mes = '';
			foreach($errors as $field => $message){
				$mes .= $field." : ".$message."<br />\n";
			}
			$this->set('error_message', $mes);
			$this->set('data', $this->data);
		}
	}




	/* =================== 　発注書検索　 ======================= */
	public function search($main_menu="", $main_year="") {
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);
		$error_msg = $this->Common->CheckIP();
		if($error_msg){
			echo $error_msg;
			exit();
		}

		$user0 = $this->Auth->user();
//		if($user0['User']['category'] == 0){
//			$this->set('error_message', "このメニューは利用ができません。");
//			//$this->redirect(array('controller'=>'purchase','action'=>'index'));
//		}

		$this->set('main_title', '発注書(検索)');
		$this->set('sub_title', '検索');

		/* 検索単語の取得 */
		$search['id'] = "";
		$search['Applicant'] = "";
		$search['ApplicationDate1'] = "";
		$search['ApplicationDate2'] = "";
		$search['Subject'] = "";
		$search['Supplier'] = "";
		$search['ProductName'] = "";

		if($this->request->data and $mode==0){
			if(isset($this->request->data['Purchase'])){
				$search = $this->request->data['Purchase'];
			}
		}
		$search['ApplicationDate1'] = $this->Purchase->field('MIN(ApplicationDate) as ApplicationDate1');
		$search['ApplicationDate2'] = $this->Purchase->field('MAX(ApplicationDate) as ApplicationDate2');
		$conditions = $this->GetPostData($search);

//debug($conditions);

		$this->paginate = array(
			'Purchase' => array(
				'page' => 1,
				'limit' => 20,
				'order' => array('ApplicationDate Desc'), 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('Purchase');
		$this->set('data', $data);
		$this->set('search', $search);
		$this->set('error_msg', $error_msg);

		$Applicants = $this->Common->GetArrayData('Purchase', 'Applicant');
//debug($Applicants);
		$this->set('Applicants', $Applicants);

		$Subjects = $this->Common->GetArrayData('Purchase', 'Subject');
		$this->set('Subjects', $Subjects);

		$Suppliers = $this->Common->GetArrayData('Purchase', 'Supplier');
		$this->set('Suppliers', $Suppliers);

//debug($this->Auth->user());
		$user0 = $this->Auth->User();
		$this->set('category', $user0['category']);
		$this->set('user_id', $user0['id']);
		$this->set('login_user', $user0);

		$this->set('ExportDateY', date("Y"));
		$this->set('ExportDateM', date("m"));
	}


	private function GetPostData($search){
		$conditions = array();
		if($search['id'])
			$conditions['id'] = $search['id'];
		if($search['Applicant'])
			$conditions['Applicant'] = $search['Applicant'];
		if($search['Subject'])
			$conditions['Subject'] = $search['Subject'];
		if($search['Supplier'])
			$conditions['Supplier'] = $search['Supplier'];

		if($search['ProductName']){
			$conditions['OR'] = array('ProductName LIKE' => '%'.$search['ProductName'].'%',
										 'ModelNo LIKE' => '%'.$search['ProductName'].'%',
										 'ProductCode LIKE' => '%'.$search['ProductName'].'%');
		}
		if($search['ApplicationDate1'] and $search['ApplicationDate2']){
			$conditions['ApplicationDate BETWEEN ? and ?'] = array($search['ApplicationDate1'], $search['ApplicationDate2']);
		}
		return $conditions;
	}



	public function search_update(){
		$this->autoRender = false;	//View File なし
	
		$sql = "set @n:=0";
		$ret = $this->Purchase->query($sql);
		$sql = "update `purchase` set id=@n:=@n+1"; 
		$ret = $this->Purchase->query($sql);
		
		$this->redirect(array('controller'=>'purchase','action'=>'search'));
	}


	/* =================== 　発注書検索　 ======================= */
	public function search2($main_menu="", $main_year="") {
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);

		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'purchase','action'=>'index'));
		}
		$this->set('main_title', '商品検索2・請求書');
		$this->set('sub_title', '検索');

		/* 検索単語の取得 */
		$search = $this->Common->getPost($this, 'Purchase2', 'search');
		$id = $this->Common->getPost($this, 'Purchase2', 'id');
		$Supplier = $this->Common->getPost($this, 'Purchase2', 'Supplier');
		$ProductName = $this->Common->getPost($this, 'Purchase2', 'ProductName');
		$ProductCode = $this->Common->getPost($this, 'Purchase2', 'ProductCode');

		/* pagenation引数取得 */
		$page = $this->Common->getPost($this, 'Purchase2', 'page');
		$direction = $this->Common->getPost($this, 'Purchase2', 'direction');
		$sort = $this->Common->getPost($this, 'Purchase2', 'sort');

		/* 検索単語に基づき条件作成 */
		$condition = array();
		if($id)
			$condition = array_merge_recursive($condition, array("id" => $id));
		if($Supplier)
			$condition = array_merge_recursive($condition, array( "Supplier like" => '%'.$Supplier.'%'));

		if($ProductName)
			$condition = array_merge_recursive($condition, array( "ProductName like" => '%'.$ProductName.'%'));

		if($ProductCode)
			$condition = array_merge_recursive($condition, array( "ProductCode like" => '%'.$ProductCode.'%'));

		$this->set('condition', $condition);

		/* 検索単語に基づき引数作成 */
		$searchword = array();
		$searchword = array("search" => $search,
					 "id" => urlencode($id),
				     "Supplier" => urlencode($Supplier),
				     "ProductName" => urlencode($ProductName),
				     "ProductCode" => urlencode($ProductCode),
		);
		/* ページネーションの作成 */
		$this->paginate = array('Purchase2' => array('conditions' => $condition, 'limit'=>100, 'sort'=>$sort, 'direction'=>$direction));
		$this->data = $this->paginate('Purchase2');

		$this->set('searchword', $searchword);
		$this->set('argument', $this->Common->array_to_string($searchword));

		$this->set('data', 	$this->data);
		$this->set('category', $user0['category']);
		$this->set('user_id', $user0['id']);
		$this->set('login_user', $user0);
	}



	/* =================== 発注書修正 ======================= */
	function search_edit($arg=""){
		$user0 = $this->Auth->user();

		$this->set('main_title', '発注書(編集)');
		$this->set('sub_title', '発注書　＞　編集');

		if($arg)
			$this->Purchase->id = $arg;
		else
			$this->Purchase->id = $this->Common->getPost($this, 'Purchase', 'id');

		if(empty($this->data)){
			$this->data = $this->Purchase->read();	//読み出し
			$this->set('data', $this->data);
		}else{

			$data1['ApplicationDate'] = $this->data['Purchase']['ApplicationDate'];
			$data1['Applicant'] = $this->data['Purchase']['Applicant'];	//?????
			
			if(isset($this->data['Purchase']['ApprovalDate']))
				$data1['ApprovalDate'] = $this->data['Purchase']['ApprovalDate'];
			else
				$data1['ApprovalDate'] = null;

			$data1['OrderDate'] = $this->data['Purchase']['OrderDate'];
			$data1['OrderName'] = $this->data['Purchase']['OrderName'];
			$data1['OrderNo'] = $this->data['Purchase']['OrderNo'];
			$data1['Supplier'] = $this->data['Purchase']['Supplier'];
			$data1['Supplier1'] = $this->data['Purchase']['Supplier1'];
			$data1['SupplierName1'] = $this->data['Purchase']['SupplierName1'];
			$data1['Subject'] = $this->data['Purchase']['Subject'];
			$data1['Subject1'] = $this->data['Purchase']['Subject1'];

			$data1['DeliveryTime'] = $this->data['Purchase']['DeliveryTime'];
			$data1['PaymentTerms'] = $this->data['Purchase']['PaymentTerms'];
			$data1['PaymentTerms1'] = $this->data['Purchase']['PaymentTerms1'];
			$data1['EstimateNo'] = $this->data['Purchase']['EstimateNo'];
			$data1['EstimateNo1'] = $this->data['Purchase']['EstimateNo1'];

			$data1['SubTotal'] = $this->data['Purchase']['SubTotal'];
			$data1['Tax'] = $this->data['Purchase']['Tax'];
			$data1['Total'] = $this->data['Purchase']['Total'];
			$data1['Note'] = $this->data['Purchase']['Note'];

			$a = $this->Common->getPost($this, 'Purchase', 'ProductName');
//debug($ProductName);
			$b = $this->Common->getPost($this, 'Purchase', 'ModelNo');
			$c = $this->Common->getPost($this, 'Purchase', 'ProductCode');
			
			$d = $this->Common->getPost($this, 'Purchase', 'Qty');
			$data1['Qty'] = implode("|", $d);
			$e = $this->Common->getPost($this, 'Purchase', 'UnitPrice');
			$data1['UnitPrice'] = implode("|", $e);
			$t = 0;
			for($i=0; $i<count($a); $i++){
				if(strlen($a[$i]) == 0)
					break;
				$a1[$i] = trim($a[$i]);
				$b1[$i] = trim($b[$i]);
				$c1[$i] = trim($c[$i]);
				$d1[$i] = trim(mb_convert_kana($d[$i], "as"));
				$e1[$i] = trim(mb_convert_kana($e[$i], "as"));
				$f1[$i] = $d1[$i] * $e1[$i];
				$t += $f1[$i];
			}
			$data1['ProductName'] = mb_convert_kana( implode("|", $a1), "KVa");
			$data1['ModelNo']     = mb_convert_kana( implode("|", $b1), "KVa");
			$data1['ProductCode'] = mb_convert_kana( implode("|", $c1), "KVa");
			$data1['Qty'] = implode("|", $d1);
			$data1['UnitPrice'] = implode("|", $e1);
			$data1['Amount'] = implode("|", $f1);
			
			$data1['SubTotal'] = $t;
			$data1['Tax'] = floor($t * 0.1);
			$data1['Total'] = $t + $data1['Tax'];
			
			if(isset($data1['Approval'])){
			 	if($data1['Approval'] == 1){
			 		$data1['ApprovalDate'] = date("Y-m-d");
					//$this->send_mail($data1);
				}
			}
			
			$Supplier = $this->Common->getPost($this, 'Purchase', 'Supplier');
			$Supplier = $this->Common->mb_str_replace("㈱","(株)",$Supplier,"UTF-8");
			$data1['Supplier'] =  mb_convert_kana($Supplier, "KVa");

			$SupplierName = $this->Common->getPost($this, 'Purchase', 'SupplierName');
			$SupplierName = $this->Common->mb_str_replace("㈱","(株)",$SupplierName,"UTF-8");
			$data1['SupplierName'] =  mb_convert_kana($SupplierName, "KVa");

			$Subject = $this->Common->getPost($this, 'Purchase', 'Subject');
			$data1['Subject'] =  mb_convert_kana($Subject, "KVa");

			$PaymentTerms = $this->Common->getPost($this, 'Purchase', 'PaymentTerms');
			$data1['PaymentTerms'] =  mb_convert_kana($PaymentTerms, "KVa");

			$EstimateNo = $this->Common->getPost($this, 'Purchase', 'EstimateNo');
			$data1['EstimateNo'] =  mb_convert_kana($EstimateNo, "KVa");


debug($data1);
//exit();

			if(!$this->Purchase->save($data1)){		//更新
				$errors = $this->Purchase->invalidFields();
				$mes = '';
				foreach($errors as $field => $message){
					$mes .= $field." : ".$message."<br />\n";
				}
				$this->set('error_message', $mes);
				$this->set('data', $data1);
			}else{
			  	if(!isset($data1['ApprovalDate'])){
					$data1['ApprovalDate'] = "0000-00-00";
				}
				if(strtotime($data1['ApprovalDate']) < strtotime("2021-01-05")){
					if(isset($data1['Approval'])){
						if($data1['Approval'] == 1)
							$this->send_mail($data1);
					}
				}
				$this->redirect(array('controller'=>'purchase','action'=>'search'));
				//$data1 = $this->Purchase->read();	//読み出し
				//$this->set('data', $data1);
			}
		}

		$this->set('GetUser2All', $this->Common->GetUser2All());
		$this->set('delicom2s', $this->Common->GetArrayData('Delicom2', 'delicom2'));
		$this->set('SupplierNames', $this->Common->GetArrayData('Purchase', 'SupplierName'));
		$this->set('Subjects', $this->Common->GetArrayData('Purchase', 'Subject'));
		$this->set('PaymentTerms', $this->Common->GetArrayData('Purchase', 'PaymentTerms'));
		$this->set('EstimateNos', $this->Common->GetArrayData('Purchase', 'EstimateNo'));

		$this->set('GetUser2All', $this->Common->GetUser2All());
		$this->set('category', $user0['category']);
		$this->set('user_id', $user0['id']);
		$this->set('login_user', $user0);
	}

	/* =================== 発注書削除 ======================= */
	function search_delete($arg=""){
		$user0 = $this->Auth->user();

		$this->set('main_title', '発注書(削除)');
		$this->set('sub_title', '発注書　＞　削除');

		if($arg)
			$this->Purchase->id = $arg;
		else
			$this->Purchase->id = $this->Common->getPost($this, 'Purchase', 'id');

		if(empty($this->data)){
			$this->data = $this->Purchase->read();	//読み出し
			$this->set('data', $this->data);
		}else{
			$this->set('data', $this->data);

			if(!$this->Purchase->delete($this->Purchase->id)){		//削除
				$errors = $this->Purchase->invalidFields();
				$mes = '';
				foreach($errors as $field => $message){
					$mes .= $field." : ".$message."<br />\n";
				}
				$this->set('error_message', $mes);
			}else
				$this->redirect(array('controller'=>'purchase','action'=>'search'));
		}

		$this->set('GetUser2All', $this->Common->GetUser2All());
		$this->set('category', $user0['category']);
		$this->set('user_id', $user0['id']);
		$this->set('login_user', $user0);
	}
	
	
	
	/* =================== 発注書新規作成 ======================= */
	function search_new(){
		$user0 = $this->Auth->user();

		$this->set('main_title', '発注書(新規作成)');
		$this->set('sub_title', '発注書　＞　新規作成');

		if(empty($this->data)){
			$lastID = $this->Purchase->getLastInsertID();
//echo $lastID."<br>";
			if($lastID <= 0){
				$d = $this->Purchase->find('first', array('fields' => array('Max(id) as max_id')));
//print_r($d);
//echo $d[0]['max_id'];
				$lastID = $d[0]['max_id'];
			}
			$this->data = $this->Purchase->find('first', array('conditions' => array('id' => $lastID)));
			$this->set('data', $this->data);
		}else{
			$data1['ApplicationDate'] = $this->data['Purchase']['ApplicationDate'];
			$data1['Applicant'] = $this->data['Purchase']['Applicant'];	//?????
			$data1['ApprovalDate'] = $this->data['Purchase']['ApprovalDate'];

			$data1['OrderDate'] = $this->data['Purchase']['OrderDate'];
			$data1['OrderName'] = $this->data['Purchase']['OrderName'];
			$data1['OrderNo'] = $this->data['Purchase']['OrderNo'];
			$data1['Supplier'] = $this->data['Purchase']['Supplier'];
			$data1['Supplier1'] = $this->data['Purchase']['Supplier1'];
			$data1['SupplierName1'] = $this->data['Purchase']['SupplierName1'];
			$data1['Subject'] = $this->data['Purchase']['Subject'];
			$data1['Subject1'] = $this->data['Purchase']['Subject1'];

			$data1['DeliveryTime'] = $this->data['Purchase']['DeliveryTime'];
			$data1['PaymentTerms'] = $this->data['Purchase']['PaymentTerms'];
			$data1['PaymentTerms1'] = $this->data['Purchase']['PaymentTerms1'];
			$data1['EstimateNo'] = $this->data['Purchase']['EstimateNo'];
			$data1['EstimateNo1'] = $this->data['Purchase']['EstimateNo1'];

			$data1['SubTotal'] = $this->data['Purchase']['SubTotal'];
			$data1['Tax'] = $this->data['Purchase']['Tax'];
			$data1['Total'] = $this->data['Purchase']['Total'];
			$data1['Note'] = $this->data['Purchase']['Note'];

			$a = $this->Common->getPost($this, 'Purchase', 'ProductName');
//debug($ProductName);
			$b = $this->Common->getPost($this, 'Purchase', 'ModelNo');
			$c = $this->Common->getPost($this, 'Purchase', 'ProductCode');
			
			$d = $this->Common->getPost($this, 'Purchase', 'Qty');

			$data1['Qty'] = implode("|", $d);

			$e = $this->Common->getPost($this, 'Purchase', 'UnitPrice');
//debug($e);
//exit();
			$data1['UnitPrice'] = implode("|", $e);
			$t = 0;
			for($i=0; $i<count($a); $i++){
				if(strlen($a[$i]) == 0)
					break;
				$a1[$i] = trim($a[$i]);
				$b1[$i] = trim($b[$i]);
				$c1[$i] = trim($c[$i]);
				$d1[$i] = trim(mb_convert_kana($d[$i], "as"));
				$e1[$i] = trim(mb_convert_kana($e[$i], "as"));
				$f1[$i] = $d1[$i] * $e1[$i];
				$t += $f1[$i];
			}
			$data1['ProductName'] = mb_convert_kana( implode("|", $a1), "KVa");
			$data1['ModelNo']     = mb_convert_kana( implode("|", $b1), "KVa");
			$data1['ProductCode'] = mb_convert_kana( implode("|", $c1), "KVa");

			$data1['Qty'] = implode("|", $d1);
			$data1['UnitPrice'] = implode("|", $e1);
			$data1['Amount'] = implode("|", $f1);
			
			$data1['SubTotal'] = $t;
			$data1['Tax'] = floor($t * 0.1);
			$data1['Total'] = $t + $data1['Tax'];
			
			if(isset($data1['Approval'])){
			 if($data1['Approval'] == 1)
			 	$data1['ApprovalDate'] = date("Y-m-d");
			}
			
			$Supplier = $this->Common->getPost($this, 'Purchase', 'Supplier');
			$Supplier = $this->Common->mb_str_replace("㈱","(株)",$Supplier,"UTF-8");
			$data1['Supplier'] =  mb_convert_kana($Supplier, "KVa");

			$SupplierName = $this->Common->getPost($this, 'Purchase', 'SupplierName');
			$SupplierName = $this->Common->mb_str_replace("㈱","(株)",$SupplierName,"UTF-8");
			$data1['SupplierName'] =  mb_convert_kana($SupplierName, "KVa");

			$Subject = $this->Common->getPost($this, 'Purchase', 'Subject');
			$data1['Subject'] =  mb_convert_kana($Subject, "KVa");
			
			$PaymentTerms = $this->Common->getPost($this, 'Purchase', 'PaymentTerms');
			$data1['PaymentTerms'] =  mb_convert_kana($PaymentTerms, "KVa");

			$EstimateNo = $this->Common->getPost($this, 'Purchase', 'EstimateNo');
			$data1['EstimateNo'] =  mb_convert_kana($EstimateNo, "KVa");

//debug($data1);
//exit();
			$data1['id'] = null;

			if(!$this->Purchase->save($data1)){		//更新
				$errors = $this->Purchase->invalidFields();
				$mes = '';
				foreach($errors as $field => $message){
					$mes .= $field." : ".$message."<br />\n";
				}
				$this->set('error_message', $mes);
				$this->set('data', $data1);
			}else{
				$this->redirect(array('controller'=>'purchase','action'=>'search'));
				
			//	$data1['id'] = $this->Purchase->getLastInsertID();
			//	$data1 = $this->Purchase->read();	//読み出し
			//	$this->set('data', $data1);
			}
		}
		$this->set('GetUser2All', $this->Common->GetUser2All());
		$this->set('delicom2s', $this->Common->GetArrayData('Delicom2', 'delicom2'));
		$this->set('SupplierNames', $this->Common->GetArrayData('Purchase', 'SupplierName'));
		$this->set('Subjects', $this->Common->GetArrayData('Purchase', 'Subject'));
		$this->set('PaymentTerms', $this->Common->GetArrayData('Purchase', 'PaymentTerms'));
		$this->set('EstimateNos', $this->Common->GetArrayData('Purchase', 'EstimateNo'));
//debug($user0);
		$this->set('category', $user0['category']);
		$this->set('user_id', $user0['id']);
		$this->set('login_user', $user0);
	}


	function send_mail($data){
		$this->autoRender = false;	//View File なし
//debug($data);
		$user0 = $this->Auth->user();
		
		$a = explode(" ", $data['Applicant']);
		$ret = $this->User->find('first', array('fields' => array('email'), 'conditions' => array('name1' => $a[0], 'name2' => $a[1])));

		$from = "yn.inabou@docomo.ne.jp";
		$from_name = "奈良部 義彦";
//debug($from);
//debug($from_name);
//exit();
		//if(strstr($_SERVER['SERVER_NAME'], "p5.yoshikura.com")){
		//if($this->_debug === false){
		if(false){
			$to = $ret['User']['email'];
			$to_name = $data['Applicant'];
			$cc = "nakanishi@inabou.co.jp";		//"yoshikura@inabous.net";	//"nakanishi@inabou.co.jp"
			$bcc = "admin@inabous.net";		//"yoshikura229@icloud.com";		//"yoshikura3@gmail.com";
		}else{
			$to = "admin@inabous.net";
			$to_name = $data['Applicant'];
			$cc = "admin@inabous.net";		//"yoshikura@inabous.net";	//"nakanishi@inabou.co.jp"
			$bcc = "yoshikura@inabous.net";		//"yoshikura229@icloud.com";		//"yoshikura3@gmail.com";
		}
//debug($to);

		$subject = "発注内容が承認されました。";

		$mailbody = $from."\r\n".$from_name."\r\n";
		$mailbody .= "ID= ".$data['id']."\r\n";
		$mailbody .= "☆☆☆発注内容☆☆☆"."\r\n";
		
		$mailbody .= "登録日= ".$data['ApplicationDate']."\r\n";
		$mailbody .= "登録者= ".$data['Applicant']."\r\n";
		$mailbody .= "承認日= ".$data['ApprovalDate']."\r\n";
		$mailbody .= "材料使用日= ".$data['OrderDate']."\r\n";
		$mailbody .= "発注者= ".$data['Supplier']."\r\n";
		$mailbody .= "発注分類= ".$data['OrderNo']."\r\n";
		$mailbody .= "発注先= ".$data['Supplier']."\r\n";
		$mailbody .= "請求先= ".$data['SupplierName']."\r\n";
		$mailbody .= "件名= ".mb_convert_kana($data['Subject'],'K','utf-8')."\r\n";
		$mailbody .= "納期= ".$data['DeliveryTime']."\r\n";
		$mailbody .= "支払方法= ".$data['PaymentTerms']."\r\n";
		$mailbody .= "見積書No= ".$data['EstimateNo']."\r\n";
		$mailbody .= "品名= ".mb_convert_kana($data['ProductName'],'K','utf-8')."\r\n";
		$mailbody .= "型番= ".mb_convert_kana($data['ModelNo'],'K','utf-8')."\r\n";
		$mailbody .= "コード= ".mb_convert_kana($data['ProductCode'],'K','utf-8')."\r\n";
		
		$mailbody .= "数量= ".$this->Common->number_format2( $data['Qty'] )."\r\n";
		$mailbody .= "単価= ".$this->Common->number_format2( $data['UnitPrice'] )."\r\n";
		$mailbody .= "金額= ".$this->Common->number_format2( $data['Amount'] )."\r\n";
		
		$mailbody .= "小計= ".number_format( $data['SubTotal'] )."\r\n";
		$mailbody .= "税金= ".number_format( $data['Tax'] )."\r\n";
		$mailbody .= "合計金額= ".number_format( $data['Total'] )."\r\n";
		$mailbody .= "備考= ".$data['Note']."\r\n";

/*
		if( $data['Attachment'] <> "" ){
			$mailbody .= "添付= ".$data['Attachment']."\r\n";
		}
*/

		$return_flag = $this->Common->cake_sendmail($from, $from_name, $to, $to_name, $subject, $mailbody, $cc, $bcc);

/*
		//$from_name .= "<".$from.">";

		//$this->set('send_mail', nl2br($to."\n------------------\n".$subject."\n-----------------\n".$mailbody."\n-----------------\n"));

		// $this->Qdmail->debug = $debug;
		$param = array(
		    'host' => 'ssl://mail.inabous.net',	//メールサーバー
		    'port' => 465,					//これはSMTPAuthの例。認証が必要ないなら　25　でＯＫ。
			'from' => 'admin@inabous.net',	//　Return-path: になります。
			'protocol' => 'SMTP_AUTH',		// 認証が必要ないなら、'SMTP'
		    'user' => 'admin@inabous.net',	//SMTPサーバーのユーザーID
		    'pass' => 'es10Um818'			//SMTPサーバーの認証パスワード
		);
		$this->Qdmail->smtpServer($param);
		$this->Qdmail->to( $to, $to_name );
		$this->Qdmail->cc( $cc, '中西' );
		$this->Qdmail->bcc( $bcc, 'bcc管理者' );
		
		$this->Qdmail->replyto($from, $from_name );
		$this->Qdmail->subject($subject);
		$this->Qdmail->from($from, $from_name );
		$this->Qdmail->text( $mailbody );
		$return_flag = $this->Qdmail->send();
		//debug($return_flag);

		if(!$return_flag){
			$this->set('error_message', "メール送信エラー");
debug("メール送信エラー");
			//return false;
		}else{
			//$this->set('error_message', "メール送信完了");
//debug("メール送信完了");
			//return true;
		}
//exit();
//		$this->redirect(array('controller'=>'users','action'=>'login'));
*/



	}

	
	public function search_app_mail($id){
		//$this->autoRender = false;	//View File なし

		$data = $this->Purchase->find('first', array( 'conditions' => array('id' => $id)));
//debug($data);

		$a = explode(" ", $data['Purchase']['Applicant']);
//debug($a);
//exit();

		$ret = $this->User->find('first', array('fields' => array('email'), 'conditions' => array('name1' => $a[0], 'name2' => $a[1])));
		$from = $ret['User']['email'];
		$from_name = $data['Purchase']['Applicant'];
//debug($_SERVER['SCRIPT_URI']);	//D:/xampp/htdocs/inabou/app/webroot/index.php
//exit();
		//if($this->_debug === false){
		if(false){
			$to = "yn.inabou@docomo.ne.jp";
			$to_name = "奈良部 義彦";
		}else{
			$to = "admin@inabous.net";
			$to_name = "奈良部 義彦";
		}
//debug($to);
		$cc = "yoshikura3@gmail.com";		//"admin@inabous.net";		//"yoshikura@inabous.net";	//"nakanishi@inabou.co.jp"
		$bcc = "yoshikura@inabous.net";		//"yoshikura229@icloud.com";		//"yoshikura3@gmail.com";

		$subject = "発注承認依頼";

		$mailbody = $this->html_mail_body($data['Purchase'], $from, $from_name);

		$return_flag = $this->Common->cake_sendmail($from, $from_name, $to, $to_name, $subject, $mailbody, $cc, $bcc);

		if(!$return_flag){
			$this->set('error_message', "メール送信エラー");
debug("メール送信エラー");
			//return false;
		}
		
		if( $id > 0 ){
			$this->Purchase->id = $id;
			$this->Purchase->saveField('AppMailed', $data['Purchase']['AppMailed'] + 1);
		}else{
			$this->set('error_message', "IDエラー");
debug("メール送信エラー");
		
		}
//exit();
		//$this->redirect(array('controller'=>'purchase','action'=>'search'));
	}




	function html_mail_body($data, $from, $from_name){

		$mailbody = "\r\n登録者：".$from_name."<".$from.">\r\n\r\n";
	
		$mailbody .= "ID= ".$data['id']."\r\n";
		$mailbody .= "登録日= ".$data['ApplicationDate']."\r\n";
		$mailbody .= "登録者= ".$data['Applicant']."\r\n";
		$mailbody .= "承認日= ".$data['ApprovalDate']."\r\n";
		$mailbody .= "材料使用日= ".$data['OrderDate']."\r\n";
		$mailbody .= "発注者= ".$data['Supplier']."\r\n";
		$mailbody .= "発注分類= ".$data['OrderNo']."\r\n";
		$mailbody .= "発注先= ".$data['Supplier']."\r\n";
		$mailbody .= "請求先= ".$data['SupplierName']."\r\n";
		$mailbody .= "件名= ".mb_convert_kana($data['Subject'],'K','utf-8')."\r\n";
		$mailbody .= "納期= ".$data['DeliveryTime']."\r\n";
		$mailbody .= "支払方法= ".$data['PaymentTerms']."\r\n";
		$mailbody .= "見積書No= ".$data['EstimateNo']."\r\n";
		$mailbody .= "品名= ".mb_convert_kana($data['ProductName'],'K','utf-8')."\r\n";
		$mailbody .= "型番= ".mb_convert_kana($data['ModelNo'],'K','utf-8')."\r\n";
		$mailbody .= "コード= ".mb_convert_kana($data['ProductCode'],'K','utf-8')."\r\n";
		
		$mailbody .= "数量= ".$this->Common->number_format2( $data['Qty'] )."\r\n";
		$mailbody .= "単価= ".$this->Common->number_format2( $data['UnitPrice'] )."\r\n";
		$mailbody .= "金額= ".$this->Common->number_format2( $data['Amount'] )."\r\n";
		
		$mailbody .= "小計= ".number_format( $data['SubTotal'] )."\r\n";
		$mailbody .= "税金= ".number_format( $data['Tax'] )."\r\n";
		$mailbody .= "合計金額= ".number_format( $data['Total'] )."\r\n";
		$mailbody .= "備考= ".$data['Note']."\r\n";
/*
		if( $data['Attachment'] <> "" ){
			$mailbody .= "添付= ".$data['Attachment']."\r\n";
		}else{
			$mailbody .= "添付= なし"."\r\n";
		}
*/
		$mailbody .= "\r\n";

		$mailbody .= "承認のリンク：".$this->URL_SELF."appmail/yes/".$data['id']."\r\n\r\n";
		$mailbody .= "否認のリンク：".$this->URL_SELF."appmail/no/".$data['id']."\r\n";
		$mailbody .= "\r\n";
//debug($mailbody);
//exit();
		return $mailbody;
	}


	function search_export(){
		$year = $this->Common->getPost($this, 'Purchase', 'ExportDateY');
		if($year == "")
			$year = "2022";
		// 月を指定
		$month = $this->Common->getPost($this, 'Purchase', 'ExportDateM');
		if($month == "")
			$month = '04';
		$first_date = date('Y-m-d', strtotime('first day of ' . $year."-".$month));
//debug($first_date);
		$week_num = date("w", strtotime($first_date));
//debug($week_num);
		if ($week_num == 0){
			//日曜日だった場合
  			$monday1 = date('Y/m/d', strtotime("-6 day", strtotime($first_date)));
		}else{
  			$monday1 = date('Y/m/d', strtotime("-{$week_num} day", strtotime($first_date) + 24*60*60));
		}
//debug($monday1);
//exit();
		$last_date = date('Y-m-d', strtotime('last day of ' . $year."-".$month));
//debug("指定月の初日：" . $first_date);
//debug("指定月の末日：" . $last_date);

		//App::import('Helper', 'Html');
        //$html = new HtmlHelper();

		$output_file_path0 = "purchase.xlsx";
		$xcellFile0 = $this->Common->ConvPath( WWW_ROOT."files/purchase/ORG/".$output_file_path0);
		if(file_exists($xcellFile0) == false){
			debug("No exists ExcelFile:".$xcellFile0);
			exit();
		}
//debug($xcellFile0);
		//$output_file_path = date("YmdHis")."_".$output_file_path0;
		$outputFile = date("Ym", strtotime($first_date))."_".$output_file_path0;

		$xcellFile = $this->Common->ConvPath( WWW_ROOT."files/purchase/".$outputFile);
		//$xcellFile = $this->Common->ConvPath( WWW_ROOT."files/purchase/20210516_".$output_file_path0);
		if(file_exists($xcellFile)){
			unlink($xcellFile);
		}
		copy($xcellFile0, $xcellFile);
//debug($xcellFile);

		// 文字コード変換
		$output_file_path = mb_convert_encoding($xcellFile, "SJIS", "UTF-8");
//debug($output_file_path);
//exit();

		$data = $this->Purchase->find('all', array('conditions' => array( 'ApplicationDate BETWEEN ? AND ?' => array($first_date, $last_date)), 
					'order' => ['ApplicationDate'=>'asc', 'id'=>'asc'] ));
		
		//$sql = "SELECT * FROM `purchase` WHERE `ApplicationDate` BETWEEN '".$first_date."' and '".$last_date."' ORDER BY `ApplicationDate` asc, `deploy_name` asc, CAST(replace(site_time1, ':', '') AS UNSIGNED) asc, `id` asc ";
		//$data = $this->Purchase->query($sql);

//$log = $this->Purchase->getDataSource()->getLog(false, false);       
//debug($log);
		$data_count = count($data);
//debug($data_count);
//debug($data);
//exit();

		$sh=0;
		//for($sh=0; $sh<5; $sh++){
			// シートの設定を行う
			//$book->setActiveSheetIndex($sh);
			//$sheet = $book->getActiveSheet();

			//$book = new PHPExcel();
			//$reader = new Reader();
			
			$book = new Spreadsheet();
			$sheet = $book->getActiveSheet();
			
			//$book = $reader->load($xcellPath1);

			//$sheet->setTitle(date("Y年m月d日"));
			$sheet->setTitle($outputFile);
			//$sheet = $book->getActiveSheet();
			$items = array("id", "申請日", "申請者", "承認日", "承認", "発注日", "発注者", "発注No.",
						"発注先", "ご担当", "件名", "納期", "支払条件", "見積No", "品名", "型番", "コード",
						"数量", "単価", "金額", "小計", "消費税", "合計金額", "備考", "承認メール", 
						"添付ファイル");

			for($i=0; $i<count($items); $i++){
				$sheet->setCellValueByColumnAndRow( $i + 1, 1, $items[$i] );
			}

			//-----------------------------------------------
			for($i=0; $i<$data_count; $i++){
				// セルに値をセットする
				$sheet->setCellValueByColumnAndRow( 0, $i + 2,  $i+1 );
				$sheet->setCellValueByColumnAndRow( 1, $i + 2,  $data[$i]['Purchase']['id']);
				$sheet->setCellValueByColumnAndRow( 2, $i + 2,  $data[$i]['Purchase']['ApplicationDate']);
				$sheet->setCellValueByColumnAndRow( 3, $i + 2,  $data[$i]['Purchase']['Applicant']);
				$sheet->setCellValueByColumnAndRow( 4, $i + 2,  $data[$i]['Purchase']['ApprovalDate']);
				
				$Approval = $data[$i]['Purchase']['Approval'];
//debug($Approval);
				if($Approval === "1"){
					$sheet->setCellValueByColumnAndRow( 5, $i + 2,  "承認");
				}elseif($Approval === "0"){
					$sheet->setCellValueByColumnAndRow( 5, $i + 2,  "否認");
					//$sheet->getStyleByColumnAndRow( 5, $i + 2)->getFont()->getColor()->setARGB(PHPExcel_Style_Color::COLOR_RED);
					$sheet->getStyleByColumnAndRow( 5, $i + 2)->getFont()->getColor()->setARGB('FF0000'); 
				}else{
					$sheet->setCellValueByColumnAndRow( 5, $i + 2,  "未承認");
					//$sheet->getStyleByColumnAndRow( 5, $i + 2)->getFont()->getColor()->setARGB(PHPExcel_Style_Color::COLOR_GREEN);
					$sheet->getStyleByColumnAndRow( 5, $i + 2)->getFont()->getColor()->setARGB('00FF00'); 
				}

				$sheet->setCellValueByColumnAndRow( 6, $i + 2,  $data[$i]['Purchase']['OrderDate']);
				$sheet->setCellValueByColumnAndRow( 7, $i + 2,  $data[$i]['Purchase']['OrderName']);
				$sheet->setCellValueByColumnAndRow( 8, $i + 2,  $data[$i]['Purchase']['OrderNo']);
				$sheet->setCellValueByColumnAndRow( 9, $i + 2,  $data[$i]['Purchase']['Supplier']);
				$sheet->setCellValueByColumnAndRow( 10, $i + 2,  $data[$i]['Purchase']['SupplierName']);
				$sheet->setCellValueByColumnAndRow( 11, $i + 2,  mb_convert_kana($data[$i]['Purchase']['Subject'],'K','utf-8'));
				$sheet->setCellValueByColumnAndRow( 12, $i + 2,  $data[$i]['Purchase']['DeliveryTime']);
				$sheet->setCellValueByColumnAndRow( 13, $i + 2,  $data[$i]['Purchase']['PaymentTerms']);
				$sheet->setCellValueByColumnAndRow( 14, $i + 2,  $data[$i]['Purchase']['EstimateNo']);
				$sheet->setCellValueByColumnAndRow( 15, $i + 2,  mb_convert_kana($data[$i]['Purchase']['ProductName'],'K','utf-8'));
				$sheet->setCellValueByColumnAndRow( 16, $i + 2,  mb_convert_kana($data[$i]['Purchase']['ModelNo'],'K','utf-8'));
				$sheet->setCellValueByColumnAndRow( 17, $i + 2,  mb_convert_kana($data[$i]['Purchase']['ProductCode'],'K','utf-8'));
				$sheet->setCellValueByColumnAndRow( 18, $i + 2,  $data[$i]['Purchase']['Qty']);
				$sheet->setCellValueByColumnAndRow( 19, $i + 2,  $data[$i]['Purchase']['UnitPrice']);
				$sheet->setCellValueByColumnAndRow( 20, $i + 2,  $data[$i]['Purchase']['Amount']);
				$sheet->setCellValueByColumnAndRow( 21, $i + 2,  $data[$i]['Purchase']['SubTotal']);
				$sheet->setCellValueByColumnAndRow( 22, $i + 2,  $data[$i]['Purchase']['Tax']);
				$sheet->setCellValueByColumnAndRow( 23, $i + 2,  $data[$i]['Purchase']['Total']);
				$sheet->setCellValueByColumnAndRow( 24, $i + 2,  $data[$i]['Purchase']['Note']);

				$sheet->setCellValueByColumnAndRow( 25, $i + 2,  $data[$i]['Purchase']['AppMailed']);
				$sheet->setCellValueByColumnAndRow( 26, $i + 2,  $data[$i]['Purchase']['Attachment']);
//break;
			}
			//-----------------------------------------------
		
		//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
		$writer = new Writer($book);
		$writer->save($output_file_path);
//debug($output_file_path);
//exit();
		// ダウンロード
	    header('Content-Type: application/octet-stream');
	    header('Content-Disposition: attachment;filename="' . $outputFile . '"');
	    header('Cache-Control: max-age=0');
 
	    //$book->setActiveSheetIndex(0);
    	//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
    	$writer->save('php://output'); 
    	exit;
	}
	


	/* =================== 発注書詳細 ======================= */
	function search_detail($arg=""){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'purchase','action'=>'index'));
		}

		$this->set('main_title', '発注書');
		$this->set('sub_title', '発注書　＞　詳細');
		$this->set('sub_title2', '見積書　＞　詳細');

		if($arg){
			$this->Purchase->id = $arg;
			$this->Quotation->id = $arg;
		}else{
			$this->Purchase->id = $this->Common->getPost($this, 'Purchase', 'id');
		}
		if(empty($this->data)){
			$this->data = $this->Purchase->read();	//読み出し
			$this->data2 = $this->Quotation->read();	//読み出し
//print_r($this->data);
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
			$this->set('data2', $this->data2);
		}else{
			//$this->data = $this->Common->sjis2utf8($this->data);
			
			$count = $this->Purchase->find('count', array('conditions' => array('category LIKE' => $this->data['Purchase']['category'],
																		'id !=' => $this->Purchase->id)));
			if($count){
				//$this->data = $this->Common->utf82sjis($this->data);
				$this->set('data', $this->data);
				$this->set('error_message', "データが既に存在しています。");
				return;
			}
			
//echo $this->Common->getPost($this, 'Purchase', 'password')."<br>";
//print_r($this->data);
			//$this->data = $this->Common->sjis2utf8($this->data);
			
			if(false){
				if(!$this->Purchase->save($this->data)){		//更新
					$errors = $this->Purchase->invalidFields();
					$mes = '';
					foreach($errors as $field => $message){
						$mes .= $field." : ".$message."<br />\n";
					}
					$this->set('error_message', $mes);

					//$this->data = $this->Common->utf82sjis($this->data);
					$this->set('data', $this->data);
				}else{
					$this->redirect(array('controller'=>'purchase','action'=>'search'));
				}
			}
		}
		$this->set('category', $user0['User']['category']);
	}

	
	function download($arg=""){
		$this->set('main_title', "ダウンロード");
		$this->set('sub_title',  '');
		
		if($arg){
			$this->Purchase->id = $arg;
			$this->Quotation->id = $arg;
		}else{
			$this->Quotation->id = $this->Purchase->id = $this->Common->getPost($this, 'Purchase', 'id');
		}
		if(empty($this->data)){
			$this->data = $this->Purchase->read();	//読み出し
			$this->data2 = $this->Quotation->read();	//読み出し
			$this->xlsx_write_proc();
		}else{
		
		}
//debug($up_file);
		$this->set('data', $this->data);
	}

	function xlsx_write_proc(){
		$path0 = $this->Common->ConvPath( WWW_ROOT."files/purchase/excel/ORG/" );
		$path = $this->Common->ConvPath( WWW_ROOT."files/purchase/excel/" );
		//$outputFile = "purchase_form.xlsx";
		$outputFile = "purchase_form.xlsx";

		$output_file_path = $path.$outputFile;
		if(file_exists($output_file_path))
			unlink($output_file_path);
		copy($path0.$outputFile, $output_file_path);
		
		//$book = new PHPExcel();
		//$book->getActiveSheet()->setTitle(date("Y年m月d日"));
		//$sheet = $book->getActiveSheet();

		$book = new Spreadsheet();
		$sheet = $book->getActiveSheet();
		$sheet->setTitle(date("Y年m月d日"));

		$sheet->setCellValue('B6', $this->data2['Quotation']['dest_up']);
		$sheet->setCellValue('B7', $this->data2['Quotation']['dest_low']);
		$sheet->setCellValue('M7', $this->data2['Quotation']['address']);

		$sheet->setCellValue('B14', $this->data2['Quotation']['OrderNo_up']);
		$sheet->setCellValue('B17', $this->data2['Quotation']['OrderNo_mid']);
		$sheet->setCellValue('B20', $this->data2['Quotation']['OrderNo_low']);
		
		$sheet->setCellValue('V2', $this->data2['Quotation']['EstimateNo']);
		$sheet->setCellValue('Q6', date('Y年m月d日', strtotime($this->data['Purchase']['DeliveryTime'])));
		$sheet->setCellValue('R26', $this->data2['Quotation']['OrderNo']);
		
		$sheet->setCellValue('M28', $this->data2['Quotation']['Total_Amount']);
		
		$a = explode("/", $this->data2['Quotation']['ProductName']);
		$b = explode("/", $this->data2['Quotation']['quantity']);
		$c = explode("/", $this->data2['Quotation']['Qty_assist']);
		$d = explode("/", $this->data2['Quotation']['price']);
		$e = explode("/", $this->data2['Quotation']['Amount_line']);
		$f = explode("/", $this->data2['Quotation']['remark']);

//debug(count($a));
		if(count($a) >= 12)
			$n = 11;
		else
			$n = count($a);

		for($i=0; $i<$n; $i++){
			if(trim($a[$i].$b[$i].$c[$i].$d[$i].$e[$i]) != ""){
	        	$sheet->setCellValueByColumnAndRow(2, 34+$i, $this->zero_check( $a[$i] )); //C24
	        	$sheet->setCellValueByColumnAndRow(9, 34+$i, $this->zero_check( $b[$i] )); //J24
	        	$sheet->setCellValueByColumnAndRow(11, 34+$i, $this->zero_check( $c[$i] )); //L24
	        	$sheet->setCellValueByColumnAndRow(13, 34+$i, $this->zero_check( $d[$i] )); //N24
	        	$sheet->setCellValueByColumnAndRow(16, 34+$i, $this->zero_check( $e[$i] )); //Q24
	        	$sheet->setCellValueByColumnAndRow(20, 34+$i, $this->zero_check( $f[$i] )); //U24
			}
		}
		
		$sheet->setCellValue('I47', $this->zero_check($this->data2['Quotation']['labor_cost']));
		$sheet->setCellValue('I48', $this->zero_check($this->data2['Quotation']['other_expense']));
		$sheet->setCellValue('I43', $this->zero_check($this->data2['Quotation']['discount']));

		$sheet->setCellValue('S47', $this->zero_check($this->data2['Quotation']['subTotal']));
		$sheet->setCellValue('S48', $this->zero_check($this->data2['Quotation']['Tax_calc_frame']));
		$sheet->setCellValue('S49', $this->zero_check($this->data2['Quotation']['Total_Amount']));

		//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
		$writer = new Writer($book);
		$writer->save($output_file_path);

		// ダウンロード
	    header('Content-Type: application/octet-stream');
	    header('Content-Disposition: attachment;filename="' . $outputFile . '"');
	    header('Cache-Control: max-age=0');
 
	    $book->setActiveSheetIndex(0);
    	//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');

		$writer = new Writer($book);
    	$writer->save('php://output'); 
    	exit;		//return $outputFile;
	}

	function zero_check($n){
		if($n == "")
			return "";
		elseif(is_numeric($n))
			return number_format(intval( $n ));
		else
			return $n;
	}
	

	public function upload(){
		$id = $this->Common->getPost($this, 'Purchase', 'id');
		if(isset($_POST['submit']) and ($id > 0)){
    		if(isset($_FILES['uploadFile']['name']) && $_FILES['uploadFile']['name'] != "") {
        		$allowedExtensions = array("pdf", "jpg", "xls", "xlsx");
        		$ext = pathinfo($_FILES['uploadFile']['name'], PATHINFO_EXTENSION);
//debug($ext);		
				if(in_array($ext, $allowedExtensions)) {
					// Uploaded file
					$upfile = $id."_".$_FILES['uploadFile']['name'];
       				
					//if(strstr($_SERVER['SCRIPT_URI'], "p5.yoshikura.com/"))
					if($this->_debug === false)
						$file = WWW_ROOT."files/purchase/upload/".$upfile;
					else
						$file = WWW_ROOT."files/purchase/upload/".$this->Common->to_sjis( $upfile );
					if(file_exists($file))
						unlink($file);
           			$isUploaded = copy($_FILES['uploadFile']['tmp_name'], $file);
		   			// check uploaded file
   	       			if($isUploaded) {
						$this->Purchase->id = $id;
						$this->Purchase->saveField('Attachment', $upfile);
//debug($file);
//debug($id);
//exit();
						$this->redirect(array('controller'=>'purchase','action'=>'search_edit', $id));
					}else{
	                    echo '<span class="msg">File not uploaded!</span>';
						debug($ext);
						exit();
					}
                } else {
                    echo '<span class="msg">File not uploaded!</span>';
					exit();
                }
        	} else {
            	echo '<span class="msg">Please upload excel sheet1.</span>';
				exit();
        	}
    	} else {
        	echo '<span class="msg">Please upload excel file2.</span>';
			exit();
    	}
	}
	
	public function attach_delete($id=0){
		if($id == 0)
			$id = $this->Common->getPost($this, 'Purchase', 'id');
		if($id > 0){
			$this->Purchase->id = $id;
			$this->Purchase->saveField('Attachment', "");
			$this->redirect(array('controller'=>'purchase','action'=>'search_edit', $id));
        } else {
            echo '<span class="msg">IDがない!</span>';
			exit();
		}
	}





	//http://localhost/inabou/purchase/summary1
	public function summary1(){
		$ret = $this->Purchase->find('first', array('fields' => array('Min(ApplicationDate) as min_ApplicationDate')));
		$start_date = $ret[0]['min_ApplicationDate'];
//debug($start_date);
		$a = explode("-", $start_date);
		$year = intval($a[0]);
		$month = intval($a[1]);

		$ret = $this->Purchase->find('first', array('fields' => array('Max(ApplicationDate) as max_ApplicationDate')));
		$end_date = $ret[0]['max_ApplicationDate'];
//debug($end_date);

		$month1   = date('Y', strtotime($start_date)) * 12 + date('m', strtotime($start_date));
		$month2   = date('Y', strtotime($end_date)) * 12 + date('m', strtotime($end_date));
		$sabun    = $month2 - $month1 + 1;
//debug($sabun);
		$suppliers = $this->GetSupplier();
//debug(count($suppliers));

		for($i=0; $i < $sabun; $i++){
			if(($month + $i) > 12){
				$year += 1;
				$month = ($i * -1) + 1;  		//???????????????要Check
//debug($i);
//debug($month);
//exit();
				$yearmonth = $year."-01"; //nullでも構いません
			}else{
				$yearmonth = $year."-".($month + $i); //nullでも構いません
			}
//debug($yearmonth);
			$data1[$i][0] = $yearmonth;
			$data2[$i][0] = $yearmonth;

			$firstDate = date('Y-m-d', strtotime('first day of ' . $yearmonth));
			$lastDate = date('Y-m-d', strtotime('last day of ' . $yearmonth));
//debug($firstDate);
//debug($lastDate);

			$sql = "SELECT COUNT(*) AS `count`, SUM(`Total`) as `sum` FROM `purchase` ";
			$sql .= "WHERE `ApplicationDate` BETWEEN '".$firstDate."' AND '".$lastDate."'";
			$ret = $this->Purchase->query($sql);
			$data1[$i][1] = $ret[0][0]['count'];
			$data2[$i][1] = $ret[0][0]['sum'];

			for($j=0; $j<count($suppliers); $j++){
				$sql = "SELECT COUNT(*) AS `count`, SUM(`Total`) as `sum` FROM `purchase` ";
				$sql .= "WHERE `ApplicationDate` BETWEEN '".$firstDate."' AND '".$lastDate."'";
				$sql .= " AND `Supplier` LIKE '%".$suppliers[$j]."%'";
				$ret = $this->Purchase->query($sql);
				
				$data1[$i][$j+2] = $ret[0][0]['count'];
				$data2[$i][$j+2] = $ret[0][0]['sum'];
			}
//debug($data1);
//debug($data2);
//exit();
		
		}
//debug($data1);
//debug($data2);
//exit();
		$outputFile = $this->xlsx_write_proc2($data1, $data2, $suppliers);
		echo($outputFile);
exit();
	}



	//http://localhost/inabou/purchase/summary2
	public function summary2(){
		$ret = $this->Purchase->find('first', array('fields' => array('Min(ApplicationDate) as min_ApplicationDate')));
		$start_date = $ret[0]['min_ApplicationDate'];
//debug($start_date);
		$a = explode("-", $start_date);
		$year = intval($a[0]);
		$month = intval($a[1]);

		$ret = $this->Purchase->find('first', array('fields' => array('Max(ApplicationDate) as max_ApplicationDate')));
		$end_date = $ret[0]['max_ApplicationDate'];
//debug($end_date);

		$month1   = date('Y', strtotime($start_date)) * 12 + date('m', strtotime($start_date));
		$month2   = date('Y', strtotime($end_date)) * 12 + date('m', strtotime($end_date));
		//$sabun    = $month2 - $month1;
		$sabun    = $month2 - $month1 + 1;
//debug($sabun);
		$applicants = $this->GetApplicant();
//debug(count($applicants));

		for($i=0; $i < $sabun; $i++){
			if(($month + $i) > 12){
				$year += 1;
				$month = ($i * -1) + 1;  		//???????????????要Check
//debug($i);
//debug($month);
//exit();
				$yearmonth = $year."-01"; //nullでも構いません
			}else{
				$yearmonth = $year."-".($month + $i); //nullでも構いません
			}
//debug($yearmonth);
			$data1[$i][0] = $yearmonth;
			$data2[$i][0] = $yearmonth;

			$firstDate = date('Y-m-d', strtotime('first day of ' . $yearmonth));
			$lastDate = date('Y-m-d', strtotime('last day of ' . $yearmonth));
//debug($firstDate);
//debug($lastDate);

			$sql = "SELECT COUNT(*) AS `count`, SUM(`Total`) as `sum` FROM `purchase` ";
			$sql .= "WHERE `ApplicationDate` BETWEEN '".$firstDate."' AND '".$lastDate."'";
			$ret = $this->Purchase->query($sql);
			$data1[$i][1] = $ret[0][0]['count'];
			$data2[$i][1] = $ret[0][0]['sum'];

			for($j=0; $j<count($applicants); $j++){
				$sql = "SELECT COUNT(*) AS `count`, SUM(`Total`) as `sum` FROM `purchase` ";
				$sql .= "WHERE `ApplicationDate` BETWEEN '".$firstDate."' AND '".$lastDate."'";
				$sql .= " AND `Applicant` LIKE '%".$applicants[$j]."%'";
				$ret = $this->Purchase->query($sql);
				
				$data1[$i][$j+2] = $ret[0][0]['count'];
				$data2[$i][$j+2] = $ret[0][0]['sum'];
			}
//debug($data1);
//debug($data2);
//exit();
		
		}
//debug($data1);
//debug($data2);
//exit();
		$outputFile = $this->xlsx_write_proc3($data1, $data2, $applicants);
		echo($outputFile);
exit();
	}



	function xlsx_write_proc2($data1, $data2, $suppliers){
		$count = count($suppliers);
//debug($count);
		$path0 = $this->Common->ConvPath( WWW_ROOT."files/purchase/ORG/" );
		$path = $this->Common->ConvPath( WWW_ROOT."files/purchase/" );
		//$outputFile = "summary.xlsx";
		$outputFile = "summary1.xlsx";

		$output_file_path = $path.$outputFile;
		if(file_exists($output_file_path))
			unlink($output_file_path);
		copy($path0.$outputFile, $output_file_path);
		
//debug(count($data1));
		$offset = count($data1) + 4;


		//$book = new PHPExcel();
		//$book->getActiveSheet()->setTitle(date("Y年m月d日"));
		//$sheet = $book->getActiveSheet();

		$book = new Spreadsheet();
		$sheet = $book->getActiveSheet();
		$sheet->setTitle(date("Y年m月d日"));

		$sheet->setCellValueByColumnAndRow(0, 1, "年月");
		$sheet->setCellValueByColumnAndRow(0, 1+$offset, "年月");
		$sheet->setCellValueByColumnAndRow(1, 1, "月件数");
		$sheet->setCellValueByColumnAndRow(1, 1+$offset, "月金額");
		for($i=0; $i<$count; $i++){
			$sheet->setCellValueByColumnAndRow($i+2, 1, 		$suppliers[$i]);
			$sheet->setCellValueByColumnAndRow($i+2, 1+$offset, $suppliers[$i]);
		}
		for($rowIndex=2; $rowIndex<count($data1)+2; $rowIndex++){
			for($columnIndex=0; $columnIndex<$count+2; $columnIndex++){
//debug(($rowIndex-2) . "--" . $columnIndex);
//debug($data1[$rowIndex-2][$columnIndex]);
				$sheet->setCellValueByColumnAndRow($columnIndex, $rowIndex, 		$data1[$rowIndex-2][$columnIndex]);
				$sheet->setCellValueByColumnAndRow($columnIndex, $rowIndex+$offset, $data2[$rowIndex-2][$columnIndex]);
//break;
			}
//break;
		}
//debug($data1);

		//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
		$writer = new Writer($book);
		$writer->save($output_file_path);

		// ダウンロード
	    header('Content-Type: application/octet-stream');
	    header('Content-Disposition: attachment;filename="' . $outputFile . '"');
	    header('Cache-Control: max-age=0');
 
	    //$book->setActiveSheetIndex(0);
    	//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
    	$writer->save('php://output'); 
    	exit;
		return $outputFile;
	}



	function xlsx_write_proc3($data1, $data2, $applicants){
		$count = count($applicants);
//debug($count);
		$path0 = $this->Common->ConvPath( WWW_ROOT."files/purchase/ORG/" );
		$path = $this->Common->ConvPath( WWW_ROOT."files/purchase/" );
		//$outputFile = "summary.xlsx";
		$outputFile = "summary2.xlsx";

		$output_file_path = $path.$outputFile;
		if(file_exists($output_file_path))
			unlink($output_file_path);
		copy($path0.$outputFile, $output_file_path);
		
		//$book = new PHPExcel();
		//$book->getActiveSheet()->setTitle(date("Y年m月d日"));
		//$sheet = $book->getActiveSheet();

		$book = new Spreadsheet();
		$sheet = $book->getActiveSheet();
		$sheet->setTitle(date("Y年m月d日"));

//debug(count($data1));
		$offset = count($data1) + 4;

		$sheet->setCellValueByColumnAndRow(0, 1, "年月");
		$sheet->setCellValueByColumnAndRow(0, 1+$offset, "年月");
		$sheet->setCellValueByColumnAndRow(1, 1, "月件数");
		$sheet->setCellValueByColumnAndRow(1, 1+$offset, "月金額");
		for($i=0; $i<$count; $i++){
			$sheet->setCellValueByColumnAndRow($i+2, 1, 		$applicants[$i]);
			$sheet->setCellValueByColumnAndRow($i+2, 1+$offset, $applicants[$i]);
		}
		for($rowIndex=2; $rowIndex<count($data1)+2; $rowIndex++){
			for($columnIndex=0; $columnIndex<$count+2; $columnIndex++){
//debug(($rowIndex-2) . "--" . $columnIndex);
//debug($data1[$rowIndex-2][$columnIndex]);
				$sheet->setCellValueByColumnAndRow($columnIndex, $rowIndex, 		$data1[$rowIndex-2][$columnIndex]);
				$sheet->setCellValueByColumnAndRow($columnIndex, $rowIndex+$offset, $data2[$rowIndex-2][$columnIndex]);
//break;
			}
//break;
		}
//debug($data1);

		//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
		$writer = new Writer($book);
		$writer->save($output_file_path);

		// ダウンロード
	    header('Content-Type: application/octet-stream');
	    header('Content-Disposition: attachment;filename="' . $outputFile . '"');
	    header('Cache-Control: max-age=0');
 
	    //$book->setActiveSheetIndex(0);
    	//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
    	$writer->save('php://output'); 
    	exit;
		return $outputFile;
	}



	function GetSupplier(){
		$sql = "SELECT sum(`Total`) as sum, `Supplier` FROM `purchase` WHERE `Supplier` != '' GROUP by `Supplier`";
		$ret = $this->Purchase->query($sql);
		//$ret = $this->Purchase->find('all', array('fields' => array('DISTINCT Supplier'), 'conditions' => array('Supplier <>' => ""), 'order' => array('Supplier' => 'asc')));
		//$ret = $this->Purchase->find('all', array('fields' => array('DISTINCT Supplier'), 'order' => array('Supplier' => 'asc')));
//debug($ret);
		$count = count($ret);
//debug($count);
		for($i=0; $i<$count; $i++){
			$d[$i] = array('Sum' => $ret[$i][0]['sum'], 'Supplier' => $ret[$i]['purchase']['Supplier']);
		}
//debug($d);
		$sorted_array = $this->sortByKey('Sum', SORT_DESC, $d);
//debug($sorted_array);
//exit();
		for($i=0; $i<$count; $i++){
			$names[$i] = $sorted_array[$i]['Supplier'];
		}
		return $names;
	}


	function GetApplicant(){
		$sql = "SELECT sum(`Total`) as sum, `Applicant` FROM `purchase` WHERE `Applicant` != '' GROUP by `Applicant`";
		$ret = $this->Purchase->query($sql);
		//$ret = $this->Purchase->find('all', array('fields' => array('DISTINCT Applicant'), 'conditions' => array('Applicant <>' => ""), 'order' => array('Applicant' => 'asc')));
		//$ret = $this->Purchase->find('all', array('fields' => array('DISTINCT Applicant'), 'order' => array('Applicant' => 'asc')));
//debug($ret);
		$count = count($ret);
//debug($count);
		for($i=0; $i<$count; $i++){
			$d[$i] = array('Sum' => $ret[$i][0]['sum'], 'Applicant' => $ret[$i]['purchase']['Applicant']);
		}
//debug($d);
		$sorted_array = $this->sortByKey('Sum', SORT_DESC, $d);
//debug($sorted_array);
//exit();
		for($i=0; $i<$count; $i++){
			$names[$i] = $sorted_array[$i]['Applicant'];
		}
		return $names;
	}


	function sortByKey($key_name, $sort_order, $array) {
    	foreach ($array as $key => $value) {
        	$standard_key_array[$key] = $value[$key_name];
    	}
	    array_multisort($standard_key_array, $sort_order, $array);
    	return $array;
	}



}