<?php
//	http://localhost/psp/staff/top_menu/1/1/平野
//	http://localhost/psp/staff/test
//  http://s.piearson.shop/psp/staff/top_menu/1/1/平野

App::uses('AppController', 'Controller');

class StaffController extends AppController {
	public $name = 'Staff';
	public $uses = array('Check', 'OldCheck', 'Store', 'Menu', 'Cart', 'OldCart');	//
	public $layout = 'staff';
	public $helpers = array('Common', 'Html');
	public $components = array('Common');		//'Auth'

	public $_dir = "/psp/";
	public $_my_url = "";

	public $_store_id = 1;
	public $_store_name = "カラオケX";
	public $_staff_id = 1;
	public $_staff_name = "平野";
	
	public $_room_no = 1;
	public $_table_no = 1;

	public $_kind = "";
	public $_error_msg = "";
	public $_staff_call_flag = 0;

	public function beforeFilter(){
		//parent::beforeFilter();
		//$this->Auth->allow();
		date_default_timezone_set('Asia/Tokyo');
		$this->set('_dir', $this->_dir);

		$this->_my_url = FULL_BASE_URL.$this->_dir;
		$this->set('_my_url', $this->_my_url);

		//$this->SetPublicData();

	}

	public function index($store_id=1, $staff_id=1, $staff_name="平野"){
		$this->redirect(array('controller' => 'staff', 'action' => 'top_menu' , $store_id."/".$staff_id."/".$staff_name));
	}

	public function test(){
	
	}


	public function top_menu($store_id=1, $staff_id=1, $staff_name="平野"){
		$this->reset_check_cart_id();
		$this->_store_id = $store_id;
		$this->_staff_id = $staff_id;
		$this->_staff_name = $staff_name;
		
		$this->GetStore();
		$this->SetPublicData();
		$this->MakeHidden();
	}
	

	public function checkin(){
		$this->SetPublicData();
//debug($this->request->data);
		if($this->request->data){
			$post = $this->request->data;
			$this->_store_id = $post['store_id'];
		}
		$this->set('_store_id', $this->_store_id);

		$h = date("H");
		$m = date("i");
//debug($h);
//debug($m);
		$data['checkin_time1']=(int)substr($h, 0, 1);
		$data['checkin_time2']=(int)substr($h, 1, 1);
		$data['checkin_time3']=(int)substr($m, 0, 1);
		$data['checkin_time4']=(int)substr($m, 1, 1);

		$h = date("H", strtotime("+1 hour"));
		$m = date("i");
		$data['checkout_time1']=(int)substr($h, 0, 1);
		$data['checkout_time2']=(int)substr($h, 1, 1);
		$data['checkout_time3']=(int)substr($m, 0, 1);
		$data['checkout_time4']=(int)substr($m, 1, 1);
//debug($data);
		$this->set('data', $data);
		$this->MakeHidden();
	}

	function print_qr_code(){
		$this->SetPublicData();
		$save_array = array();
//debug($this->request->data);
		if($this->request->data){
			$post = $this->request->data;
			$this->_store_id = $post['store_id'];
			if($post['kind']=="chekin"){
				$kind = $post['kind'];
				$store_id = $post['store_id'];

				$checkin_hour = (int)$post['checkin_time1'] * 10 + (int)$post['checkin_time2'];
				$checkin_minute = (int)$post['checkin_time3'] * 10 + (int)$post['checkin_time4'];
				$checkin_time = date("Y-m-d ").$checkin_hour.":".$checkin_minute.":00";
//debug($checkin_time);
				if($post['checkout_time1'] == 3){
					$checkout_time = NULL;
				}else{
					$checkout_hour = (int)$post['checkout_time1'] * 10 + (int)$post['checkout_time2'];
					$checkout_minute = (int)$post['checkout_time3'] * 10 + (int)$post['checkout_time4'];
					$checkout_time = date("Y-m-d ").$checkout_hour.":".$checkout_minute.":00";
				}
//debug($checkout_time);
				$time1 = new DateTime($checkin_time);
				$time2 = new DateTime($checkout_time);
				if($time2 < $time1)
					$checkout_time = date("Y-m-d H:i:s", strtotime("+1 day", strtotime($checkout_time)));
				
				$room_no = (int)$post['room_no1'] * 10 + (int)$post['room_no2'];
				
				$people = (int)$post['people1'] * 10 + (int)$post['people2'];
				$child = (int)$post['child1'] * 10 + (int)$post['child2'];
				
				if(isset($post['drink_free']))
					$drink_free = $post['drink_free'];
				else
					$drink_free = 0;

				if(isset($post['discount']))
					$discount = $post['discount'];
				else
					$discount = 0;

				$course = $post['course'];
				if($course > 0){
					$checkout_time = date("Y-m-d H:i:s", strtotime("+".$course." hour", strtotime($checkin_time)));
					$time1 = new DateTime($checkin_time);
					$time2 = new DateTime($checkout_time);
					if($time2 < $time1)
						$checkout_time = date("Y-m-d H:i:s", strtotime("+1 day", strtotime($checkout_time)));
				}
				
				$check_id = dechex(strtotime('now').sprintf('%02d', $room_no));
//debug($check_id);
				$this->_store_id = $store_id;
				$this->_room_no = $room_no;
				$this->_check_id = $check_id;

				$save_array = array('id'=>NULL, 'check_id'=>$check_id, 'store_id'=>$store_id, 'checkin_time'=>$checkin_time, 
						'checkout_time0'=>$checkout_time, 'room_no'=>$room_no, 'people'=>$people, 
						'child'=>$child, 'drink_free'=>$drink_free, 'course'=>$course, 'discount'=>$discount,
						'staff_id'=>$post['staff_id'], 'staff_name'=>$post['staff_name'] );
				/********************************/
				$this->Check->save($save_array);
				/********************************/
				$conditions = array('check_id'=>$check_id);
				$check = $this->Check->find('first', array('conditions'=>$conditions));
				
				$check['Check']['decode_check_id'] = $this->Common->DecodeCheckID($this->_check_id);
				$url = "https://s.pierson.shop".$this->_dir."order/order_login/".$this->_store_id."/".$this->_room_no."/".$this->_check_id;			
				$check['Check']['url'] = $url;
			}
		}
//debug($save_array);				
		$this->set('data', $check['Check']);
		
		$this->GetStore();
		$this->MakeHidden();
	}

	public function undeliver(){
		$this->SetPublicData();
		$store = $this->GetStore();
//debug($this->data);

		if($this->data['kind']=="update"){
			for($i=0; $i<$this->data['count']; $i++){
//debug($this->data);
				if(isset($this->data['undeliver'][$i])){
					if($this->data['undeliver'][$i] > 0){
						//更新
						$save_array = array('id' => $this->data['id'][$i], 'deliver_send'=>2, 'deliver_time'=>date("Y-m-d H:i:s"));
//debug($save_array);
						$ret = $this->Cart->save($save_array);
					}
				
				}
			}
		}

		$cart = $this->GetCartData("order_history2");
		$this->set('cart', $cart);
//debug($cart);
		$this->MakeHidden();
	}


	public function checkout(){
		$this->SetPublicData();
		$this->GetStore();
//debug($this->data);

		if(isset($this->data['room_no1']) and isset($this->data['room_no2'])){
			$room_no = (int)$this->data['room_no1'] * 10 + (int)$this->data['room_no2'];
			
			if($room_no > 0){
				$this->_room_no = $room_no;
			}
		}else{
			$room_no=0;
		}
		if($room_no > 0){
			$cart = $this->GetCartData("order_history3");
			if($cart != array()){
				$this->set('cart', $cart);
//debug($cart);
				$conditions = array('check_id'=>$cart[0]['Cart']['check_id']);
				$check = $this->Check->find('first', array('conditions'=>$conditions));
				if($check != array()){
					$this->set('check', $check['Check']);
//debug($check);
					$data['checkin_time'] = $check['Check']['checkin_time'];
					$n = sprintf('%02d', $check['Check']['people']);
					$data['people1']=(int)substr($n, 0, 1);
					$data['people2']=(int)substr($n, 1, 1);

					$n = sprintf('%02d', $check['Check']['child']);
					$data['child1']=(int)substr($n, 0, 1);
					$data['child2']=(int)substr($n, 1, 1);

					$h = date("H");
					$m = date("i");
					$data['checkout_time1']=(int)substr($h, 0, 1);
					$data['checkout_time2']=(int)substr($h, 1, 1);
					$data['checkout_time3']=(int)substr($m, 0, 1);
					$data['checkout_time4']=(int)substr($m, 1, 1);
//debug($data);
					$data['course']=$check['Check']['course'];
					$data['drink_free']=$check['Check']['drink_free'];
					$data['discount']=$check['Check']['discount'];
			
					$data['check_id'] = $check['Check']['check_id'];
				}else{
					$data = array();
				}
			}else{
				$data = array();
			}
			$this->set('data', $data);
		}
		$this->set('room_no', $room_no);
		$this->MakeHidden();
	}

	public function print_checkout(){
		$this->SetPublicData();
		$this->GetStore();
//debug($this->data);
		$save_array = array();
//debug($this->request->data);
		if($this->request->data){
			$post = $this->request->data;
			$this->_store_id = $post['store_id'];
			if($post['kind']=="chekout2"){
				$kind = $post['kind'];
				$store_id = $post['store_id'];
				$checkin_time = $post['checkin_time'];
//debug($checkin_time);
				/***************/
				if($post['checkout_time1'] == 3){
					$checkout_time = NULL;
				}else{
					$checkout_hour = (int)$post['checkout_time1'] * 10 + (int)$post['checkout_time2'];
					$checkout_minute = (int)$post['checkout_time3'] * 10 + (int)$post['checkout_time4'];
					$checkout_time = date("Y-m-d ").$checkout_hour.":".$checkout_minute.":00";
				}
//debug($checkout_time);
				$time1 = new DateTime($checkin_time);
				$time2 = new DateTime($checkout_time);
				if($time2 < $time1)
					$checkout_time = date("Y-m-d H:i:s", strtotime("+1 day", strtotime($checkout_time)));
				/***************/
				$room_no = $post['room_no'];
				
				$people = (int)$post['people1'] * 10 + (int)$post['people2'];
				$child = (int)$post['child1'] * 10 + (int)$post['child2'];
				
				if(isset($post['drink_free']))
					$drink_free = $post['drink_free'];
				else
					$drink_free = 0;

				if(isset($post['discount']))
					$discount = $post['discount'];
				else
					$discount = 0;

				$course = $post['course'];
				if($course > 0){
					$checkout_time = date("Y-m-d H:i:s", strtotime("+".$course." hour", strtotime($checkin_time)));
					$time1 = new DateTime($checkin_time);
					$time2 = new DateTime($checkout_time);
					if($time2 < $time1)
						$checkout_time = date("Y-m-d H:i:s", strtotime("+1 day", strtotime($checkout_time)));
				}
				$this->_check_id = $post['check_id'];
				$this->set('check_id', $this->_check_id);

				$data = array('checkout_time'=>$checkout_time, 'people'=>$people, 'child'=>$child, 
					'drink_free'=>$drink_free, 'course'=>$course, 'discount'=>$discount);
				$conditions = array('check_id'=>$this->_check_id);
				$this->Cart->updateAll($data, $conditions);
				/***************/

				$data = array('checkout_time' => $checkout_time);
				$conditions = array('check_id'=>$this->_check_id);
				$this->Cart->updateAll($data, $conditions);
				/***************/
				
				$conditions = array('check_id'=>$this->_check_id);
				$check = $this->Check->find('first', array('conditions'=>$conditions));
				/*********************/
//debug($this->_check_id);
				$save_array['id'] = $check['Check']['id'];			
				$save_array['check_id'] = $this->_check_id;		//$this->Check->getLastInsertID();

				$conditions = array('store_id' => $this->_store_id, 'check_id'=>$this->_check_id, 
						'order_send '=>2, 'deliver_send'=>2);
				$cart = $this->Cart->find('all', array('conditions' => $conditions));
				/*********************/
				$this->set('cart', $cart);

				$this->MoveOldData();
				/*********************/
			}
		}
//debug($save_array);				
		$this->set('data', $save_array);

		$this->MakeHidden();
	}

	public function staff_call(){
		$this->SetPublicData();
		$this->GetStore();

		if($this->data['kind']=="update"){
			for($i=0; $i<$this->data['count']; $i++){
//debug($this->data);
				if(isset($this->data['staff_call'][$i])){
					if($this->data['staff_call'][$i] > 0){
						//更新
						$save_array = array('id' => $this->data['id'][$i], 'staff_call'=>0);	//, 'staff_call_time'=>NULL
//debug($save_array);
						$ret = $this->Check->save($save_array);
					}
				
				}
			}
		}

		$this->CheckStaffCall();
		
		$this->MakeHidden();
	}











	private function GetStore(){
		$store = $this->Store->find('first', array('conditions' => array('Store.id' => $this->_store_id)));
		//if (! $this->data){ throw new NotFoundException(); }
		if(!$store){ echo "エラーGetStore"; debug("Error!!!"); }
//debug($store);
		$this->_store_id = $store['Store']['id'];
		$this->set('_store_id', $this->_store_id);

		$this->_store_name = $store['Store']['store_name'];
		$this->set('_store_name', $this->_store_name);

		$this->set('store', $store['Store']);
	}

	private function GetCartData($mode = ""){
//id, `store_id`,`room_no`,`table_no`,`menu_id`,`menu_name`,`unit_price`,`qty`,`amount`,`tax`,`total`,
//`order_send`,`order_time`,`deliver_send`,
		if($mode == "")
			$conditions = array('store_id' => $this->_store_id, 'check_id'=>$this->_check_id);
		elseif($mode == "cart")
			$conditions = array('store_id' => $this->_store_id, 'check_id'=>$this->_check_id,
				'order_send <'=>2);

		elseif($mode == "order_history1")
			$conditions = array('store_id' => $this->_store_id, 'check_id'=>$this->_check_id,
				'order_send <'=>2, 'deliver_send <'=>2);

		elseif($mode == "order_history2")		//'room_no'=>$this->_room_no, 
			$conditions = array('store_id' => $this->_store_id, 'check_id'=>$this->_check_id, 
				'order_send'=>2, 'deliver_send <'=>2);

		elseif($mode == "order_history3")
			$conditions = array('store_id' => $this->_store_id, 'check_id'=>$this->_check_id, 
				'order_send '=>2, 'deliver_send'=>2);

		elseif($mode == "order_send")
			$conditions = array('store_id' => $this->_store_id, 'check_id'=>$this->_check_id, 
				'order_send <'=>2, 'deliver_send <'=>2);
		elseif($mode == "check")
			$conditions = array('store_id' => $this->_store_id, 'check_id'=>$this->_check_id, 
				'order_send'=>2, 'deliver_send'=>2);

//debug($conditions);

		$cart = $this->Cart->find('all', array('conditions' => $conditions));
//debug($cart);
		if(count($cart) == 0){
			$this->set('cart', $cart);
			return array();
		}
		$this->set('cart', $cart);
		return $cart;
	}







	private function MoveOldData(){
		$conditions = array('check_id' => $this->_check_id);
		$data = $this->Check->find('first', array('conditions' => $conditions));
		if($data==array()){
			debug($this->_check_id." のCheckID データがない");
			exit();
		}
//debug($data);
//debug($this->_check_id);
		$id = $data['Check']['id'];
		$data['Check']['id'] = NULL;
		$save_array = $data['Check'];
//debug($save_array);
//debug($id);
		$this->OldCheck->save($save_array);
		$this->Check->delete($id);
		/***************/
		
		
		$conditions = array('check_id' => $this->_check_id);
		$data = $this->Cart->find('all', array('conditions' => $conditions));
		if($data==array()){
			debug($this->_check_id." のCheckID データがない");
			exit();
		}
		for($i=0; $i<count($data); $i++){
			$id = $data[$i]['Cart']['id'];
			$data[$i]['Cart']['id'] = NULL;
			$save_array = $data[$i]['Cart'];
//debug($save_array);
//debug($id);
			$this->OldCart->save($save_array);
			$this->Cart->delete($id);
			/***************/
		}
		$this->reset_check_cart_id();
	}



	private function SetPublicData(){
//debug($this->data);
//debug($this->_room_no);
//exit();
		if(isset($this->data['store_id']))
			$this->_store_id = $this->data['store_id'];
		if($this->_store_id == 0){
			$error_msg = "エラー　店舗番号が0です。";
			$this->redirect(array('controller' => 'staff', 'action' => 'top_menu', $this->_store_id."/".$this->_room_no."/".$error_msg));
		}
		$this->set('_store_id', $this->_store_id);

		if(isset($this->data['store_name']))
			$this->_store_name = $this->data['store_name'];
		if($this->_store_name == ""){
			$error_msg = "エラー　店舗名がないです。";
			$this->redirect(array('controller' => 'staff', 'action' => 'top_menu', $this->_store_id."/".$this->_room_no."/".$error_msg));
		}
		$this->set('_store_name', $this->_store_name);

		if(isset($this->data['room_no']))
			$this->_room_no = $this->data['room_no'];
		if($this->_room_no == 0){
			$error_msg = "エラー　ルーム番号が0です。";
			$this->redirect(array('controller' => 'staff', 'action' => 'top_menu', $this->_store_id."/".$this->_room_no."/".$error_msg));
		}
		$this->set('_room_no', $this->_room_no);

		//if(isset($this->data['table_no']))
		//	$this->_table_no = $this->data['table_no'];
		//$this->set('_table_no', $this->_table_no);

		if(isset($this->data['staff_id']))
			$this->_staff_id = $this->data['staff_id'];
		$this->set('_staff_id', $this->_staff_id);

		if(isset($this->data['staff_name']))
			$this->_staff_name = $this->data['staff_name'];
		$this->set('_staff_name', $this->_staff_name);

		if(isset($this->data['kind']))
			$this->_kind = $this->data['kind'];
		$this->set('_kind', $this->_kind);

		if(isset($this->data['error_msg']))
			$this->_error_msg = $this->data['error_msg'];
		$this->set('_error_msg', $this->_error_msg);

	}
	
	private function MakeHidden(){
		$hidden  = "<input type=\"hidden\" name=\"store_id\" value=\"".$this->_store_id."\">\r\n";
		$hidden  .= "<input type=\"hidden\" name=\"store_name\" value=\"".$this->_store_name."\">\r\n";

		$hidden .= "<input type=\"hidden\" name=\"room_no\"  value=\"".$this->_room_no."\">\r\n";
		//$hidden .= "<input type=\"hidden\" name=\"table_no\"  value=\"".$this->_table_no."\">\r\n";
		
		$hidden .= "<input type=\"hidden\" name=\"staff_id\" value=\"".$this->_staff_id."\">\r\n";
		$hidden .= "<input type=\"hidden\" name=\"staff_name\" value=\"".$this->_staff_name."\">\r\n";

		$hidden .= "<input type=\"hidden\" name=\"kind\" value=\"".$this->_kind."\">\r\n";
//debug($hidden);		
		$this->set('hidden', $hidden);
		$this->CheckStaffCall();
	}

	private function reset_check_cart_id(){
		$sql = "set @n:=0;";
		$rtn = $this->Check->query($sql);
		
		$sql = "update `checks` set id=@n:=@n+1;";
		$rtn = $this->Check->query($sql);

		$sql = "set @n:=0;";
		$rtn = $this->Cart->query($sql);
		
		$sql = "update `checks` set id=@n:=@n+1;";
		$rtn = $this->Cart->query($sql);
	}


	private function CheckStaffCall(){
		$conditions = array('staff_call' => 2);
		$data = $this->Check->find('all', array('conditions' => $conditions));
		$this->set('staff_call', $data);
		if(count($data) > 0){
			$this->_staff_call_flag = 2;
		}
		$this->set('staff_call_flag', $this->_staff_call_flag);
		return $data;
	}

	private function DecodeCheckID(){
		$s = hexdec($this->_check_id);
//debug($s);
		$st = substr($s, 0, strlen($s)-2);
		$dt = date("Y-m-d H:i:s", (int)$st);
//debug($dt);
		$r = (int)substr($s, strlen($s)-2, 2);
//debug($r);
		return "(".$dt." ".$r.")";
	
	}

}
