<?php
//	http://localhost/psp/admin/menu
//  http://s.piearson.shop/psp/admin/menu

// Excel出力用ライブラリ
App::import( 'Vendor', 'PHPExcel', array('file'=>'phpexcel' . DS . 'PHPExcel.php') );
App::import( 'Vendor', 'PHPExcel_IOFactory', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'IOFactory.php') );
App::import( 'Vendor', 'PHPExcel_Cell_AdvancedValueBinder', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Cell' . DS . 'AdvancedValueBinder.php') );
// Excel95用ライブラリ
//App::import( 'Vendor', 'PHPExcel_Writer_Excel5', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Writer' . DS . 'Excel5.php') );
//App::import( 'Vendor', 'PHPExcel_Reader_Excel5', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Reader' . DS . 'Excel5.php') );

// Excel2007用ライブラリ
App::import( 'Vendor', 'PHPExcel_Writer_Excel2007', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Writer' . DS . 'Excel2007.php') );
App::import( 'Vendor', 'PHPExcel_Reader_Excel2007', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Reader' . DS . 'Excel2007.php') );

App::uses('AppController', 'Controller');

class AdminController extends AppController {
	public $name = 'Admin';
	public $uses = array('Store', 'Menu', 'Cart', 'OldCart', 'Check', 'OldCheck');
	public $layout = 'admin';
	public $helpers = array('Html', 'Common');		//'Common', 'Html', , 'QrCode'
	public $components = array('Common');		//'Auth'

	public $_dir = "/psp/";
	public $_my_url = "";

	public $_cart_id = 0;
	public $_store_id = 1;
	public $_room_no = 0;

	public $_order_send = 0;
	public $_order_time = NULL;

	public $_deliver_send = 0;
	public $_deliver_time = NULL;

	public $_checkin_time = NULL;
	public $_checkout_time = NULL;

	public $_menu_id = 0;
	public $_menu_name = "";
	public $_room_use = 0;

	public $_category1 = "";
	public $_category2 = "";
	public $_photo_file = "";

	public $_open_time = NULL;
	public $_close_time = NULL;
	public $_page_pattern = 0;
	public $_max_room_no = 10;

	public function beforeFilter($store_id=0, $room_no=0, $error_msg=""){
		//parent::beforeFilter();
		//$this->Auth->allow();
		date_default_timezone_set('Asia/Tokyo');
		$this->set('_dir', $this->_dir);
		$this->set('_store_id', $this->_store_id);
		
		$this->_my_url = FULL_BASE_URL.$this->_dir;
		$this->set('_my_url', $this->_my_url);
		
		$main_title = "メニュー管理";
		$this->set('main_title', $main_title);
	}

	public function index(){
		$this->redirect(array('controller' => 'admin', 'action' => 'room_use'));
	}

	public function room_use(){
		$error_msg = "";
		$targetTime = $this->EvaluateTime($mode="open");
		$checkin_time = date('Y-m-d H:i:s', strtotime("-6 hour", $targetTime));
//debug($checkin_time);

		$conditions['store_id'] = $this->_store_id;
		$conditions['checkin_time >'] = $checkin_time;
		$conditions['checkout_time'] = NULL;
//debug($conditions);
		$this->paginate = array(
			'Check' => array(
				//'fields' => array(),
				'page' => 1,
				'limit' => 20,
				'order' => 'room_no', 		// desc
				'conditions' => $conditions, 
				//'group' => array('room_no', 'checkin_time'),
			), 
		);
//exit();
		$data = $this->paginate('Check');
		$this->set('data', $data);

		$this->set('error_msg', $error_msg);
//debug($data);
	}

	public function menu(){
		//$this->show_constants();
		//debug(FULL_BASE_URL);
		$error_msg = "";
		
		$this->set('main_title', "メニュー管理");
		$conditions = $this->GetMenuRequestData();
		//$this->Paginator->sort(‘文字列(カラム名）’,'キー’,'オプション配列’);
		
		$this->paginate = array(
			'Menu' => array(
				'page' => 1,
				'limit' => 20,
				'order' => 'Menu.id', 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('Menu');
		$this->set('data', $data);

		//**********************
		$fields = array('category1');
		$conditions = array('store_id'=>$this->_store_id);
		$group = array('category1');
		$orders = array('id');
		$menu = $this->Menu->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
//debug($menu);
		if(count($menu) > 0){
			for($i=0; $i<count($menu); $i++)
				$category1_array[$i] = $menu[$i]['Menu']['category1'];
			$this->set('category1_array', $category1_array);
		}
		//$category1_array = array("DRINK","FOOD");
		//**********************

		//**********************
		$fields = array('category2');
		if(isset($search['category1'])){
			if($search['category1'])
				$conditions = array('store_id'=>$store_id, 'category1' => $search['category1']);
		}else
			$conditions = array('store_id'=>$this->_store_id);
		$group = array('category2');
		$orders = array('id');
		$menu = $this->Menu->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
//debug($menu);
		if(count($menu) > 0){
			for($i=0; $i<count($menu); $i++)
				$category2_array[$i] = $menu[$i]['Menu']['category2'];
			$this->set('category2_array', $category2_array);
		}
		//**********************

		$this->set('error_msg', $error_msg);


/*
$this->Paginator->numbers(array(
'first' => '', //ページ数が多いとき最初のページを出すか（数字で指定）
'last' => '',//ページ数が多いとき最後のページを出すか（数字で指定）
'before'=>'',//ページ番号の前に出力する文字を指定
'after'=>'',//ページ番号の後に出力する文字を指定
'modulus'=>'',//ページ番号を幾つ表示するか（デフォルト値：8）
'separator'=>'',//ページ番号を区切る文字列（デフォルト値：|）
'ellipsis'=>'',//省略される時に表示される文字列（デフォルト値：・・・）
'tag'=>'',//ページ番号を囲むタグ（デフォルト値：設定無し）
'class'=>'',//上記タグのクラス名を設定（デフォルト値：設定無し）
'currentTag'=>'',//表示中のページ番号のタグを設定（デフォルト値：null）
'currentClass'=>'',//表示中のページ番号のクラスを設定（デフォルト値：current）
)
);
*/
	}


	public function menu_edit($menu_id=0){
		$error_msg = "";

		if($this->request->data){
			if($this->request->data['submit'] == "更新"){
//debug($this->request->data);
//debug($this->request->data['Menu']);
				$menu = $this->request->data['Menu'];
				if (isset($menu['id'])){
					if($menu['id'] > 0){
						$menu_id = $menu['id'];
						$save_array = array (
							'id'=>$menu_id, 'category1'=>$menu['category1'], 'category2'=>$menu['category2'], 
							'menu_name'=>$menu['menu_name'], 'unit_price'=>$menu['unit_price'], 
							'photo_file'=>$menu['photo_file'], 'not_use'=>$menu['not_use']);
						$ret = $this->Menu->save($save_array);
					}
  				}
			}
			$menu_id = $this->request->data['Menu']['id'];
			$store_id = $this->request->data['Menu']['store_id'];
			$cat1_no = $this->request->data['Menu']['cat1_no'];
			$cat2_no = $this->request->data['Menu']['cat2_no'];

			if(strstr($this->request->data['submit'], "アップロード")){
				if ($this->request->is('post')) {
//debug($this->request->data['Post']);
					$post = $this->request->data['Post']['image'];
					$tmp=$post['tmp_name'];
//debug($tmp);
					if(is_uploaded_file($tmp)) {
						$file_name = basename($post['name']);
						if(strstr($this->request->data['submit'], "商品"))
							$file = WWW_ROOT.'img'.DS.$store_id.DS.'item'.DS.$cat1_no.DS.$file_name;
						elseif(strstr($this->request->data['submit'], "カテゴリ2"))
							$file = WWW_ROOT.'img'.DS.$store_id.DS.'mcate'.DS.$cat1_no.DS.$cat2_no.".jpg";
						elseif(strstr($this->request->data['submit'], "カテゴリ1"))
							$file = WWW_ROOT.'img'.DS.$store_id.DS.'lcate'.DS.$cat1_no.".jpg";
						elseif(strstr($this->request->data['submit'], "ページHEADER"))
							$file = WWW_ROOT.'img'.DS.$store_id.DS.'main'.DS."header.jpg";
						elseif(strstr($this->request->data['submit'], "ページTOP"))
							$file = WWW_ROOT.'img'.DS.$store_id.DS.'main'.DS."main.jpg";
						else
							debug("");
//debug($file);
						if (move_uploaded_file($tmp, $file)) {
							if(strstr($this->request->data['submit'], "商品")){
								$this->Menu->set('id', $menu_id);
								$this->Menu->saveField('photo_file', $file_name);
							}
						}else{
							debug("Upload Error");
							$error_msg = "Upload Error";
						}
					}
				}
			}
		}
//debug($menu_id);
		if($menu_id > 0){
			$conditions = array('id'=>$menu_id);
			$data = $this->Menu->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}




	public function order(){
		$this->set('main_title', "注文管理(今日)");
		$error_msg = "";

		$conditions = $this->GetCartRequestData();
		$targetTime = $this->EvaluateTime("close");
		//$conditions['Cart.checkin_time >'] = date('Y-m-d H:i:s', strtotime("+1 hour", $targetTime));		//06:00

		//$this->Paginator->sort(‘文字列(カラム名）’,'キー’,'オプション配列’);
		
		$this->paginate = array(
			'Cart' => array(
				'page' => 1,
				'limit' => 20,
				'order' => array('Cart.room_no', 'Cart.id'), 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('Cart');
		$this->set('data', $data);

		$this->set('error_msg', $error_msg);
	}

	public function old_order(){
		$this->set('main_title', "注文管理(過去)");
		$error_msg = "";
		$cart_id = 0;
		$conditions = $this->GetCartRequestData();
		//$targetTime = $this->EvaluateTime("close");
		//$conditions['OldCart.checkin_time <'] = date('Y-m-d H:i:s', strtotime("+1 hour", $targetTime));		//06:00

//debug($conditions);
		//$this->Paginator->sort(‘文字列(カラム名）’,'キー’,'オプション配列’);
		
		$this->paginate = array(
			'OldCart' => array(
				'page' => 1,
				'limit' => 20,
				'order' => array('OldCart.room_no', 'OldCart.id'), 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('OldCart');
		$this->set('data', $data);

		$this->set('error_msg', $error_msg);
	}


	public function order_edit($order_id=0, $mdel="Cart"){
		$this->set('main_title', "注文管理");
		$error_msg = "";
		$store_id = 1;
//debug($this->request->data);

		if($this->request->data){
			$order = $this->request->data['Cart'];
			if(strstr($this->request->data['submit'], "更新")){
				if(isset($order['id'])){
					if($order['id'] > 0){
						$order_id = $order['id'];
						$save_array = array (
						'id'=>$order_id, 'unit_price'=>$order['unit_price'], 'qty'=>$order['qty'],
						'amount'=>$order['amount'], 'tax'=>$order['tax'], 'total'=>$order['total'], 
						'order_send'=>$order['order_send'],	'order_time'=>$order['order_time'],
						'deliver_send'=>$order['deliver_send'], 'deliver_time'=>$order['deliver_time'],
						'urgent'=>$order['urgent']);
//debug($save_array);
						if($mdel=="OldCart")
							$ret = $this->OldCart->save($save_array);
						else
							$ret = $this->Cart->save($save_array);
					}
				}
			}elseif(strstr($this->request->data['submit'], "削除")){
				if($mdel=="OldCart")
					$ret = $this->OldCart->delete($order['id']);
				else
					$ret = $this->Cart->delete($order['id']);
			}
		}
//debug($order_id);
		if($order_id > 0){
			$conditions = array('id'=>$order_id);
			if($mdel=="OldCart")
				$data = $this->OldCart->find('first', array('conditions'=>$conditions));
			else
				$data = $this->Cart->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
//debug($conditions);
		if($mdel=="OldCart")
			$data['Cart'] = $data['OldCart'];
//debug($data);
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}


	
	public function store(){
		$this->set('main_title', "店舗管理");
		$error_msg = "";
		$store_id = 1;
		
		$conditions = array();
//debug($this->request->data);
		if($this->request->data){
			$search = $this->request->data['Store'];
			if (isset($search['store_id'])){
				if($search['store_id'] > 0){
					$store_id = $search['store_id'];
					$conditions['Store.id'] = $store_id;
				}
			}

		}
		
		$this->paginate = array(
			'Store' => array(
				'page' => 1,
				'limit' => 20,
				'order' => 'Store.id', 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('Store');
		$this->set('data', $data);

		$this->set('error_msg', $error_msg);
	}

	public function store_edit($store_id=0){
		$error_msg = "";
		$store_id = 1;
//debug($this->request->data);
		if($this->request->data){
			$store = $this->request->data['Store'];
			if (isset($store['id'])){
				if($store['id'] > 0){
					$store_id = $store['id'];
					$save_array = array (
						'id'=>$store_id, 'store_name'=>$store['store_name'],
						'open_time'=>$store['open_time'], 'close_time'=>$store['close_time'],
						'page_pattern'=>$store['page_pattern'], 'max_room_no'=>$store['max_room_no'],
						'tel'=>$store['tel'], 'note1'=>$store['note1'], 'note2'=>$store['note2']);
					$ret = $this->Store->save($save_array);
				}
			}

		}
		if($store_id > 0){
			$conditions = array('id'=>$store_id);
			$data = $this->Store->find('first', array('conditions'=>$conditions));
			$error_msg = "";
		}else{
			$data = array();
			$error_msg = "データがない";
		}
		$this->set('data', $data);
		$this->set('error_msg', $error_msg);
	}

//	http://localhost/psp/admin/undeliver
//  http://s.piearson.shop/psp/admin/undeliver
	public function undeliver(){
		$this->set('main_title', "未配・飲食管理");
		$error_msg = "";

		$cart_id = 0;

		$conditions = array();
		
		$conditions['order_send'] = 2;
		$conditions['order_time >'] = date("Y-m-d H:i:s",strtotime("-10 hour"));//10時間前
		$conditions['deliver_send <'] = 2;
		$conditions['deliver_time'] = NULL;

		if ($this->request->data){
//debug($this->request->data);
			for($i=0; $i<count($this->request->data); $i++){
				$post = $this->request->data[$i]['Cart'];
				if(isset($post['deliver_send'])){
					$deliver_send = $post['deliver_send'];
					$deliver_time = date("Y-m-d H:i:s");
				}else{
					$deliver_send = 1;
					$deliver_time = NULL;
				}

				$save_array = array ('id' => $this->request->data[$i]['Cart']['id'],
							'deliver_send' => $deliver_send, 'deliver_time' => $deliver_time);
//debug($save_array);
				$ret = $this->Cart->save($save_array);
			}

		}
//debug($conditions);
		//$this->Paginator->sort(‘文字列(カラム名）’,'キー’,'オプション配列’);
		
		$this->paginate = array(
			'Cart' => array(
				'page' => 1,
				'limit' => 20,
				'order' => array('Cart.room_no', 'Cart.id'), 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('Cart');
		$this->set('data', $data);

		$this->set('error_msg', $error_msg);
	}



//	http://localhost/psp/admin/cron_proc
//  http://s.piearson.shop/psp/admin/cron_proc
	public function cron_proc(){
		$this->autoRender = false;	//View File なし
		$this->MoveOldData();
		exit();
	}


	private function EvaluateTime($mode="close"){
		$open_time = $this->Store->field("open_time", array('id'=>$this->_store_id));
		$close_time = $this->Store->field("close_time", array('id'=>$this->_store_id));
		if($mode=="open")
			$targetTime = strtotime(date("Y-m-d ".$open_time));
		else
			$targetTime = strtotime(date("Y-m-d ".$close_time));

		$time1 = new DateTime(date("H:i:s"));
		$time2 = new DateTime('00:00:00');
		$time3 = new DateTime($close_time);
		if(($time1 > $time2) and ($time1 < $time3))
			$targetTime = strtotime("-1 day", $targetTime);
		return $targetTime;
	}


	private function MoveOldData(){
		$targetTime = $this->EvaluateTime("close");
		$conditions['checkin_time <'] = date('Y-m-d H:i:s', strtotime("+60 minute", $targetTime));
//debug($conditions);
		$check = $this->Check->find('all', array('conditions' => $conditions));
//debug($check);

		for($i=0; $i<count($check); $i++){
			$conditions = array('check_id' => $check[$i]['Check']['check_id']);
			$cart = $this->Cart->find('all', array('conditions' => $conditions));
			for($j=0; $j<count($cart); $j++){
				$cart_data = $cart[$i]['Cart'];
				$cart_id = $cart_data['id'];
				$cart_data['id'] = NULL;
debg($cart_data);
				$ret = $this->OldCart->save($cart_data);
				$ret = $this->Cart->delete($cart_id);
			}

			$check_data = $check[$i]['Check'];
			$id = $check_data['id'];
			$check_data['id'] = NULL;
debg($check_data);
			$ret = $this->OldCheck->save($check_data);
			$ret = $this->Check->delete($id);
		}

	}

//	http://localhost/psp/admin/export_excel
//  http://s.piearson.shop/psp/admin/export_excel
	public function export_excel($model=''){
		//$this->autoRender = false;	//View File なし
		if($model == "Menu")
			$outputFile = "_menus.xlsx";
		elseif($model == "Cart")
			$outputFile = "_carts.xlsx";
		else{
			debug("Error");
			exit();
		}
			
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'psp'.DS.$outputFile;
		//$output_file_path = str_replace('/', '\\', $output_file_path);
 
		// 文字コード変換
		$output_file_path = mb_convert_encoding($output_file_path, "SJIS", "UTF-8");
		///////////////////////////////////////////////////////////////////////////
		
		if($model == "Menu"){
			$fields = array();
			$conditions = array('store_id'=>$this->_store_id);
			$group = array();
			$orders = array('id');
			$data = $this->Menu->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
			//$items = array('id','store_id','category1','cat1_no','category2','cat2_no','category3','cat3_no','menu_name','unit_price','photo_file','not_use');
			$items = array('id','店舗id','カテゴリ1','cat1_no','カテゴリ2','cat2_no','カテゴリ3','cat3_no','商品名','単価','写真ファイル','未使用');
		}elseif($model == "Cart"){
//debug($this->_menu_id);
//exit();
			$conditions = $this->GetCartRequestData();

			$fields = array();
			//$conditions = array('store_id'=>$this->_store_id);
			$group = array();
			$orders = array('id');
			$data = $this->Cart->find('all', array('fields'=>$fields, 'conditions'=>$conditions, 'group'=>$group, 'order'=>$orders ));
			$items = array('id','受付id','店舗id','部屋番号','テーブル番号','メニューid','メニュー名','単価','数量','金額','税金','合計',
				'注文済','注文時間','配膳済','配膳時間','催促');
		}

		$book = new PHPExcel();
		$book->getActiveSheet()->setTitle(date("Y年m月d日"));
		$sheet = $book->getActiveSheet();

		$row = 1;
		foreach ($items as $col => $value) {
//debug($value);
//debug($col);
//exit();
        	$sheet->setCellValueByColumnAndRow($col, $row, $value);
		}

		$rowOffset = 2;
		foreach ($data as $row => $menu) {
//debug($menu);
//debug($row);
		    foreach ($menu as $no => $fields) {
//debug($fields);
//debug($no);
				$col = 0;
			    foreach ($fields as $field => $value) {
//debug($value);
//debug($field);
        			$sheet->setCellValueByColumnAndRow($col++, $row + $rowOffset, $value);
				}
//exit();
    		}
		}

		$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
		$writer->save($output_file_path);

		// ダウンロード
	    header('Content-Type: application/octet-stream');
	    header('Content-Disposition: attachment;filename="' . $outputFile . '"');
	    header('Cache-Control: max-age=0');
 
	    $book->setActiveSheetIndex(0);
    	$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
    	$writer->save('php://output'); 
    	exit;
	}

	public function import_excel(){
		$this->autoRender = false;	//View File なし
		if ($this->request->data){
//debug($this->request->data);
			$post = $this->request->data['Post']['image'];
			$tmp=$post['tmp_name'];
//debug($tmp);
			if(is_uploaded_file($tmp)) {
				$file_name = basename($post['name']);
				$file = WWW_ROOT.'files'.DS.'psp'.DS.$file_name;
//debug($file);
//exit();
				if (move_uploaded_file($tmp, $file)) {
					$this->ReadExcel($file);
				}else{
					debug("Upload Error");
					$error_msg = "Upload Error";
				}
			}
		}
	
	}

	private function ReadExcel($file){
//debug($file);
		$reader = PHPExcel_IOFactory::createReader('Excel2007');
		// 読み込む
		$excel = $reader->load($file);
		// D:\xampp\htdocs\psp\app\Vendor\phpexcel\PHPExcel\CellDefaultValueBinder.php変更

		// 最初のシートを取得
		$sheet = $excel->getActiveSheet();
		$rows = 0;
		$i = 0;
		// 行
		foreach ($sheet->getRowIterator() as $row){
			if($rows++ > 0){
				$items = array('id','store_id','category1','cat1_no','category2','cat2_no','category3','cat3_no','menu_name','unit_price','photo_file','not_use');
				$j = 0;
				// セル
				foreach ($row->getCellIterator() as $cell){
				    // 各セルの値を取得
					$data[$i]['Menu'][$items[$j++]] = $cell->getValue();
//debug($cell->getValue());
//debug($data);
//exit();
				}
				$i++;
//debug($data);
//exit();
		  	}
		}
		//テーブル内容消去
		$this->Menu->truncate();
//debug($data);
		$this->Menu->saveAll($data);
//debug("OK");
		$this->redirect(array('controller' => 'admin', 'action' => 'menu'));
exit();
	}

	private function GetMenuRequestData(){
		$conditions = array();
//debug($this->request->data);
		if ($this->request->data){
			$search = $this->request->data['Menu'];
			if (isset($search['store_id'])){
				if($search['store_id'] > 0){
					$this->_store_id = $search['store_id'];
					$conditions['Menu.store_id'] = $this->_store_id;
				}
			}
			if (isset($search['menu_id'])){
				if($search['menu_id'] > 0){
					$this->_menu_id = $search['menu_id'];
					$conditions['Menu.id'] = $this->_menu_id;
				}
			}
			if (isset($search['category1'])){
				if($search['category1']){
					$this->_category1 = $search['category1'];
					$conditions['Menu.category1 like'] = $this->_category1;
				}
			}
			if (isset($search['category2'])){
				if($search['category2']){
					$this->_category2 = $search['category2'];
					$conditions['Menu.category2 like'] = $this->_category2;
				}
			}
			if (isset($search['menu_name'])){
				if($search['menu_name']){
					$this->_menu_name = $search['menu_name'];
					$conditions['Menu.menu_name like'] = '%'.$this->_menu_name.'%';
				}
			}
			if (isset($search['photo_file'])){
				if($search['photo_file']){
					$this->_photo_file = $search['photo_file'];
					$conditions['Menu.photo_file like'] = '%'.$this->_photo_file.'%';
				}
			}
		}
		$this->set('store_id', $this->_store_id);
		$this->set('menu_id', $this->_menu_id);
		$this->set('menu_name', $this->_menu_name);
		$this->set('category1', $this->_category1);
		$this->set('category2', $this->_category2);
		$this->set('photo_file', $this->_photo_file);
//debug($conditions);
		return $conditions;
	}

	private function GetCartRequestData(){
		$conditions = array();
		$conditions['room_no >'] = 0;
//debug($this->request->data);
		if ($this->request->data){
			$search = $this->request->data['Cart'];
//debug($search);
			if (isset($search['submit'])){
				if(strstr($search['submit'], "データ移動")){
					$this->MoveOldData();
				}
			}

			if (isset($search['cart_id'])){
				if($search['cart_id'] > 0){
					$this->_cart_id = $search['cart_id'];
					$conditions['id'] = $this->_cart_id;
				}
			}
			if (isset($search['store_id'])){
				if($search['store_id'] > 0){
					$this->_store_id = $search['store_id'];
					$conditions['store_id'] = $this->_store_id;
				}
			}
			if (isset($search['room_no'])){
				if($search['room_no'] > 0){
					$this->_room_no = $search['room_no'];
					$conditions['room_no'] = $this->_room_no;
				}
			}
			if (isset($search['menu_id'])){
				if($search['menu_id'] > 0){
					$this->_menu_id = $search['menu_id'];
					$conditions['menu_id'] = $this->_menu_id;
//debug($this->_menu_id);
				}
			}
			if (isset($search['menu_name'])){
				if($search['menu_name'] != ""){
//debug($search);
					$this->_menu_name = $search['menu_name'];
					$conditions['menu_name like'] = '%'.$this->_menu_name.'%';
				}
			}
			if (isset($search['order_send'])){
				if($search['order_send'] > 0){
					$this->_order_send = $search['order_send'];
					$conditions['order_send'] = $this->_order_send;
				}
			}
			if (isset($search['deliver_send'])){
				if($search['deliver_send'] > 0){
					$this->_deliver_send = $search['deliver_send'];
					$conditions['deliver_send'] = $this->_deliver_send;
				}
			}
			if (isset($search['room_use'])){
				if($search['room_use'] > 0){
					$this->_room_use = $search['room_use'];
					$conditions['room_use'] = $this->_room_use;
				}
			}

		}
		$this->set('cart_id', $this->_cart_id);
		$this->set('store_id', $this->_store_id);
		$this->set('room_no', $this->_room_no);
		
		$this->set('menu_id', $this->_menu_id);
		$this->set('menu_name', $this->_menu_name);
		
		$this->set('order_send', $this->_order_send);
		$this->set('deliver_send', $this->_deliver_send);
		$this->set('room_use', $this->_room_use);

//debug($conditions);
		return $conditions;
	}

	private function array_to_string($arr){
		$s = "";
//debug($arr);
		foreach ($arr as $key => $value)
			$s .= "/".$key.":".$value;
		return $s;
	}














	private function GetStore(){
		$store = $this->Store->find('first', array('conditions' => array('Store.id' => $this->_store_id)));
		//if (! $this->data){ throw new NotFoundException(); }
		if(!$store){ echo "エラーGetStore"; debug("Error!!!"); }
//debug($store);
		$this->_store_id = $store['Store']['id'];
		$this->set('_store_id', $this->_store_id);

		$this->_store_name = $store['Store']['store_name'];
		$this->set('_store_name', $this->_store_name);

		$this->_page_pattern = $store['Store']['page_pattern'];
		$this->set('_page_pattern', $this->_page_pattern);

		//$_max_room_no = $store['Store']['max_room_no'];
		//$this->set('_max_room_no', $this->_max_room_no);

		$this->set('store', $store);
	}

	public function show_constants(){
		debug(APP);
		debug(APP_DIR);
		debug(APPLIBS);
		debug(CACHE);
		debug(CAKE);
		debug(CAKE_CORE_INCLUDE_PATH);
		debug(CORE_PATH);
		debug(CSS);
		debug(CSS_URL);
		debug(DS);
		debug(FULL_BASE_URL);
		debug(IMAGES);
		debug(IMAGES_URL);
		debug(JS);
		debug(JS_URL);
		debug(LOGS);
		debug(ROOT);
		debug(TESTS);
		debug(TMP);
		debug(VENDORS);
		debug(WEBROOT_DIR);
		debug(WWW_ROOT);
		debug();
		debug(TIME_START);
	}
	

}
