<?php
//	http://localhost/inabou/kitaro

// Excel出力用ライブラリ
//App::import( 'Vendor', 'PHPExcel', array('file'=>'phpexcel' . DS . 'PHPExcel.php') );
//App::import( 'Vendor', 'PHPExcel_IOFactory', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'IOFactory.php') );
//App::import( 'Vendor', 'PHPExcel_Cell_AdvancedValueBinder', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Cell' . DS . 'AdvancedValueBinder.php') );
// Excel95用ライブラリ
//App::import( 'Vendor', 'PHPExcel_Writer_Excel5', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Writer' . DS . 'Excel5.php') );
//App::import( 'Vendor', 'PHPExcel_Reader_Excel5', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Reader' . DS . 'Excel5.php') );

// Excel2007用ライブラリ
//App::import( 'Vendor', 'PHPExcel_Writer_Excel2007', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Writer' . DS . 'Excel2007.php') );
//App::import( 'Vendor', 'PHPExcel_Reader_Excel2007', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Reader' . DS . 'Excel2007.php') );



if(file_exists('D:\xampp\htdocs\vendor\autoload.php'))
	require 'D:\xampp\htdocs\vendor\autoload.php';
else
	require '/home/enzbaoev/public_html/p7/vendor/autoload.php';

//use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx as Writer;
use PhpOffice\PhpSpreadsheet\Reader\Xlsx as Reader;
use PhpOffice\PhpSpreadsheet\RichText\RichText as RichText; //RichTextAPIを使用
use PhpOffice\PhpSpreadsheet\Style;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;

App::uses('AppController', 'Controller');
App::import('Vendor', 'util/common');

class KitaroController extends AppController {
	public $name = 'Kitaro';
	public $uses = array('User', 'Kitaro', 'Car');
	//public $layout = 'mailauth1';
	public $layout = 'kitaro';

	//public $autoRender = false;	// View Off
	
	public $components = array('Auth', 'Common');	//'Session', , 'Mail', 'Email', 'Qdmail', 'Excel'  
	public $helpers = array('Common', 'Html', 'Form');	//'Javascript', , 'Tabular', 'Calender', 'Holiday'
	public $URL_SELF;

	public $_dir = "/inabou/";
	public $_url = "";
	public $_path = WWW_ROOT;

	function beforeFilter(){
		define("Classes", $_SERVER["DOCUMENT_ROOT"]."/Classes/");

	//	if($this->Common->CheckUserAuth($this->Auth) == false){
		//	$this->redirect(array('controller'=>'users','action'=>'login',"メール認証に失敗しました。"));
	//	}

		$this->set('main_title', "ドライブ運行記録");
		$this->set('error_message', null);
		$this->set('data_error', false);
		$this->set('data_error_msg', "");

//		App::import('Helper', 'Html');
//      $html = new HtmlHelper();
//		$this->URL_SELF = $html->url('/', true);	// http://vps.waa.jp/Kitaro
		$this->set('URL_SELF', $this->URL_SELF);
		date_default_timezone_set('Asia/Tokyo');

		$this->_dir = "/inabou/";
		$this->set('_dir', $this->_dir);
		
		$this->_url = FULL_BASE_URL.$this->_dir;
		$this->set('_url', $this->_url);

		$this->_path = WWW_ROOT;
		$this->set('_path', $this->_path);
	}

	function index(){		//http://localhost/inabou/kitaro/

		$this->redirect(array('controller'=>'kitaro','action'=>'search'));

		//$sql = "TRUNCATE `kitaro`";
		//$ret = $this->Kitaro->query($sql);
	}

	/* =================== 　ドライブ運行記録・検索　 ======================= */
	public function search($mode=0) {
		$error_msg = "";
		$this->set('main_title', 'ドライブ運行記録');
		$this->set('sub_title', '検索');

		/* 検索単語の取得 */
		$search['id'] = "";
		$search['YearMonth'] = "";	//期間月
		$search['CarNo'] = "";	//車両番号
		$search['UserName'] = "";	//利用者名
		$search['CarName'] = "";	//車両名
		if($this->request->data and $mode==0){
			if(isset($this->request->data['Kitaro'])){
				$search = $this->request->data['Kitaro'];
			}
		}

		$conditions = $this->GetPostData($search);
//debug($conditions);
		$this->paginate = array(
			'Kitaro' => array(
				'page' => 1,
				'limit' => 20,
				'order' => array('id'), 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('Kitaro');
		$this->set('data', $data);
		$this->set('search', $search);
		$this->set('error_msg', $error_msg);
//debug($data);

		$user0 = $this->Auth->User();
		$this->set('login_id', $user0['id']);
	}




	private function GetPostData($search){
		$conditions = array();
		if($search['id'])
			$conditions['id'] = $search['id'];
		if($search['YearMonth'])
			$conditions['YearMonth'] = $search['YearMonth'];
		if($search['CarNo'])
			$conditions['CarNo'] = $search['CarNo'];
		if($search['UserName'])
			$conditions['UserName'] = $search['UserName'];
		if($search['CarName'])
			$conditions['CarName'] = $search['CarName'];
		return $conditions;
	}



	function search_export(){
		$YearMonth = $this->Common->getPost($this, 'Kitaro', 'YearMonth');
		if($YearMonth == "")
			$YearMonth = "202109";

		App::import('Helper', 'Html');
        $html = new HtmlHelper();

		$excel_file0 = "kitaro.xlsx";
		$xcellFile0 = $this->Common->ConvPath( WWW_ROOT."files/kitaro/ORG/".$excel_file0);
		if(file_exists($xcellFile0) == false){
			debug("No exists ExcelFile:".$xcellFile0);
			exit();
		}
//debug($xcellFile0);
		$excel_file = $YearMonth."_".$excel_file0;

		$xcellFile = $this->Common->ConvPath( WWW_ROOT."files/kitaro/".$excel_file);
		if(file_exists($xcellFile)){
			unlink($xcellFile);
		}
		copy($xcellFile0, $xcellFile);
//debug($xcellFile);

		//$book = new PHPExcel();
		//$book = PHPExcel_IOFactory::load($xcellFile);

		$reader = new Reader();
		$book = $reader->load($xcellFile);

		$data = $this->Kitaro->find('all', array('conditions' => array( 'YearMonth LIKE' => $YearMonth), 'order' => array('id'=>'asc')));
		
		//$sql = "SELECT * FROM `kitaro` WHERE `YearMonth` BETWEEN '".$first_date."' and '".$last_date."' ORDER BY `YearMonth` asc, `deploy_name` asc, CAST(replace(site_time1, ':', '') AS UNSIGNED) asc, `id` asc ";
		//$data = $this->Kitaro->query($sql);

//$log = $this->Kitaro->getDataSource()->getLog(false, false);       
//debug($log);
		$data_count = count($data);
//debug($data_count);
//debug($data);
//exit();

		$sh=0;
		//for($sh=0; $sh<5; $sh++){
			// シートの設定を行う
			$book->setActiveSheetIndex($sh);
			$sheet = $book->getActiveSheet();
			//-----------------------------------------------
			for($i=0; $i<$data_count; $i++){
				// セルに値をセットする
				$sheet->setCellValueByColumnAndRow( 0, $i + 2,  $i+1 );
				$sheet->setCellValueByColumnAndRow( 1, $i + 2,  $data[$i]['Kitaro']['id']);
				$sheet->setCellValueByColumnAndRow( 2, $i + 2,  $data[$i]['Kitaro']['CarName']);
				$sheet->setCellValueByColumnAndRow( 3, $i + 2,  $data[$i]['Kitaro']['CarNo']);
				$sheet->setCellValueByColumnAndRow( 4, $i + 2,  $data[$i]['Kitaro']['UserName']);
				
				$sheet->setCellValueByColumnAndRow( 5, $i + 2,  $data[$i]['Kitaro']['YearMonth']);

				$sheet->setCellValueByColumnAndRow( 6, $i + 2,  $data[$i]['Kitaro']['RecordTime']);
				$sheet->setCellValueByColumnAndRow( 7, $i + 2,  $data[$i]['Kitaro']['RunningTime']);
				
				$sheet->setCellValueByColumnAndRow( 8, $i + 2,  $data[$i]['Kitaro']['StopTime']);
				$sheet->setCellValueByColumnAndRow( 9, $i + 2,  $data[$i]['Kitaro']['StartingMileage']);

				$sheet->setCellValueByColumnAndRow( 10, $i + 2,  $data[$i]['Kitaro']['EndMileage']);
				//$sheet->setCellValueByColumnAndRow( 11, $i + 2,  mb_convert_kana($data[$i]['Kitaro']['Mileage'],'K','utf-8'));

				$sheet->setCellValueByColumnAndRow( 11, $i + 2,  $data[$i]['Kitaro']['Mileage']);
				$sheet->setCellValueByColumnAndRow( 12, $i + 2,  $data[$i]['Kitaro']['Idling']);
				$sheet->setCellValueByColumnAndRow( 13, $i + 2,  $data[$i]['Kitaro']['MaxSpeed']);
				$sheet->setCellValueByColumnAndRow( 14, $i + 2,  $data[$i]['Kitaro']['AverageSpeed']);

				//$sheet->setCellValueByColumnAndRow( 15, $i + 2,  mb_convert_kana($data[$i]['Kitaro']['SuddenBrakes'],'K','utf-8'));
				$sheet->setCellValueByColumnAndRow( 15, $i + 2,  $data[$i]['Kitaro']['SuddenBrakes']);

				//$sheet->setCellValueByColumnAndRow( 16, $i + 2,  mb_convert_kana($data[$i]['Kitaro']['SuddenAcceleration'],'K','utf-8'));
				$sheet->setCellValueByColumnAndRow( 16, $i + 2,  $data[$i]['Kitaro']['SuddenAcceleration']);

				//$sheet->setCellValueByColumnAndRow( 17, $i + 2,  mb_convert_kana($data[$i]['Kitaro']['SuddenHandles'],'K','utf-8'));
				$sheet->setCellValueByColumnAndRow( 17, $i + 2,  $data[$i]['Kitaro']['SuddenHandles']);

				$sheet->setCellValueByColumnAndRow( 18, $i + 2,  $data[$i]['Kitaro']['SafetyEvaluation']);
				$sheet->setCellValueByColumnAndRow( 19, $i + 2,  $data[$i]['Kitaro']['EcoDrivingEvaluation']);
				$sheet->setCellValueByColumnAndRow( 20, $i + 2,  $data[$i]['Kitaro']['TotalEvaluation']);
				$sheet->setCellValueByColumnAndRow( 21, $i + 2,  $data[$i]['Kitaro']['DrivingDays']);
//break;
			}
			//-----------------------------------------------
		
		//}//endfor $sh
		// Excel2007形式で保存する
		//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
		$writer = new Writer($book);
		$writer->save($excel_file);

	// メモリの解放
		$book->disconnectWorksheets();
		unset($book);
//exit();
		// ファイルのダウンロード
		$dl_file = $excel_file;
		header('Content-Type: application/force-download');
		header('Content-Length: '.filesize($xcellFile));
		header('Content-Disposition: attachment; filename="'.mb_convert_encoding($dl_file, 'SJIS-win', 'UTF-8').'"');
		readfile($xcellFile);
		//exit();
	
		$this->redirect(array('controller'=>'kitaro','action'=>'search'));
	}
	

	/* =================== 　ドライブ運行記録・検索2　 ======================= */
	public function search2($mode=0) {
		$error_msg = "";
		$this->set('main_title', 'ドライブ運行記録');
		$this->set('sub_title', '検索');

		/* 検索単語の取得 */
		$search['id'] = "";
		$search['YearMonth'] = "";	//期間月
		$search['CarNo'] = "";	//車両番号
		$search['UserName'] = "";	//利用者名
		$search['CarName'] = "";	//車両名
		if($this->request->data and $mode==0){
			if(isset($this->request->data['Kitaro'])){
				$search = $this->request->data['Kitaro'];
			}
		}

		$conditions = $this->GetPostData($search);
//debug($conditions);
		$this->paginate = array(
			'Kitaro' => array(
				'page' => 1,
				'limit' => 20,
				'order' => array('id'), 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('Kitaro');
		$this->set('data', $data);
		$this->set('search', $search);
		$this->set('error_msg', $error_msg);
//debug($data);

		$user0 = $this->Auth->User();
		$this->set('login_id', $user0['id']);	}
	

//	http://localhost/iabou/kitaro/export_excel/
//  http://http://p7.inabous.net/iabou/kitaro/export_excel/
	public function export_excel(){
		$this->autoRender = false;	//View File なし
		$outputFile = date("Ymd")."_kitaro.xlsx";
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'kitaro'.DS.$outputFile;
		//$output_file_path = str_replace('/', '\\', $output_file_path);
 
		// 文字コード変換
		$output_file_path = mb_convert_encoding($output_file_path, "SJIS", "UTF-8");
		///////////////////////////////////////////////////////////////////////////

		//$fields = array();

//debug($this->request->data);

		$search = $this->request->data['Kitaro'];
		$conditions = $this->GetPostData($search);

		//$group = array();
		$orders = array('id');
		$data = $this->Kitaro->find('all', array('conditions'=>$conditions, 'order'=>$orders ));	//'fields'=>$fields,  'group'=>$group,

		$items = array('id','車両名','	車両番号','	利用者名','集計期間','月間記録時間（分）','	月間走行時間（分）',
			'月間停止時間（分）','月間開始時距離(km)','月間終了時距離(km)','月間走行距離(km)','月間アイドリング（分）',
			'月間最高速度(km/h)	','月間平均速度(km/h)','月間急ブレーキ数','	月間急加速数','月間急ハンドル数',
			'月間安全評価(%)','月間エコドライブ評価(%)','月間総合評価(%)','乗車日数');

		//$book = new PHPExcel();
		//$book->getActiveSheet()->setTitle(date("Y年m月d日"));
		//$sheet = $book->getActiveSheet();
		$book = new Spreadsheet();
		$sheet = $book->getActiveSheet();
		$sheet->setTitle(date("Y年m月d日"));

		$row = 1;
		foreach ($items as $col => $value) {
//debug($value);
//debug($col);
//exit();
        	$sheet->setCellValueByColumnAndRow($col, $row, $value);
		}

		$rowOffset = 2;
		foreach ($data as $row => $menu) {
//debug($menu);
//debug($row);
		    foreach ($menu as $no => $fields) {
//debug($fields);
//debug($no);
				$col = 0;
			    foreach ($fields as $field => $value) {
//debug($value);
//debug($field);
        			$sheet->setCellValueByColumnAndRow($col++, $row + $rowOffset, $value);
				}
//exit();
    		}
		}

		//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
		$writer = new Writer($book);
		$writer->save($output_file_path);

		// ダウンロード
	    header('Content-Type: application/octet-stream');
	    header('Content-Disposition: attachment;filename="' . $outputFile . '"');
	    header('Cache-Control: max-age=0');
 
	    //$book->setActiveSheetIndex(0);
    	//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
    	$writer->save('php://output'); 
    	exit;
	}

/** ============================================================================================================= */
	//http://localhost/inabou/pinvoice/summary1
	public function summary1(){
		$this->autoRender = false;	//View File なし
		$outputFile = date("Ymd")."_kitaro1.xlsx";
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'kitaro'.DS.$outputFile;
		//$output_file_path = str_replace('/', '\\', $output_file_path);
 
		// 文字コード変換
		$output_file_path = mb_convert_encoding($output_file_path, "SJIS", "UTF-8");
		///////////////////////////////////////////////////////////////////////////
		$items = array('id','集計年月','車両名','利用者名',
			'月間最高速度(km/h)	','月間平均速度(km/h)','月間急ブレーキ数','	月間急加速数','月間急ハンドル数',
			'月間安全評価(%)','月間エコドライブ評価(%)','月間総合評価(%)','乗車日数');

		//$book = new PHPExcel();
		//$book->getActiveSheet()->setTitle(date("Y年m月d日"));
		//$sheet = $book->getActiveSheet();
		$book = new Spreadsheet();
		$sheet = $book->getActiveSheet();
		$sheet->setTitle(date("Y年m月d日"));
		//=============================================================
		$row = 1;
		foreach ($items as $col => $value) {
        	$sheet->setCellValueByColumnAndRow($col, $row, $value);
		}
		$yms = $this->Common->GetModelAllNum("Kitaro", "YearMonth");
		$car_names = $this->Common->GetModelAllNum("Kitaro", "CarName");
		$rowOffset = 2;
		for($i=0; $i<count($car_names); $i++){
			$conditions = array('CarName'=>$car_names[$i]);
			$group = array('YearMonth');
			$orders = array('YearMonth ASC');
			$data0 = $this->Kitaro->find('all', array('conditions'=>$conditions, 'group'=>$group, 'order'=>$orders));	//'fields'=>$fields,  
//debug($data0);
			$data = $this->ChangeData($data0, $yms);
//debug($data);
			$this->WriteExcel($sheet, $data, $rowOffset);
			$rowOffset += count($yms)+2;
//exit();
		}

		//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
		$writer = new Writer($book);
		$writer->save($output_file_path);

		// ダウンロード
	    header('Content-Type: application/octet-stream');
	    header('Content-Disposition: attachment;filename="' . $outputFile . '"');
	    header('Cache-Control: max-age=0');
 
	    //$book->setActiveSheetIndex(0);
    	//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
    	$writer->save('php://output'); 
    	exit;
	}

/** ============================================================================================================= */
	//http://localhost/inabou/pinvoice/summary1
	public function summary2(){
		$this->autoRender = false;	//View File なし
		$outputFile = date("Ymd")."_kitaro1.xlsx";
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'kitaro'.DS.$outputFile;
		//$output_file_path = str_replace('/', '\\', $output_file_path);
 
		// 文字コード変換
		$output_file_path = mb_convert_encoding($output_file_path, "SJIS", "UTF-8");
		///////////////////////////////////////////////////////////////////////////
		$items = array('id','集計年月','車両名','利用者名',
			'月間最高速度(km/h)	','月間平均速度(km/h)','月間急ブレーキ数','	月間急加速数','月間急ハンドル数',
			'月間安全評価(%)','月間エコドライブ評価(%)','月間総合評価(%)','乗車日数');

		//$book = new PHPExcel();
		//$book->getActiveSheet()->setTitle(date("Y年m月d日"));
		//$sheet = $book->getActiveSheet();
		$book = new Spreadsheet();
		$sheet = $book->getActiveSheet();
		$sheet->setTitle(date("Y年m月d日"));
		//=============================================================
		$row = 1;
		foreach ($items as $col => $value) {
        	$sheet->setCellValueByColumnAndRow($col, $row, $value);
		}
		$yms = $this->Common->GetModelAllNum("Kitaro", "YearMonth");
		$car_names = $this->Common->GetModelAllNum("Kitaro", "CarName");
		$rowOffset = 2;
		for($i=0; $i<count($car_names); $i++){
			$conditions = array('CarName'=>$car_names[$i]);
			$group = array('YearMonth');
			$orders = array('YearMonth ASC');
			$data0 = $this->Kitaro->find('all', array('conditions'=>$conditions, 'group'=>$group, 'order'=>$orders));	//'fields'=>$fields,  
//debug($data0);
			$data1 = $this->ChangeData($data0, $yms);
			$data[0] = $data1[count($data1)-1];
//debug($data);
			$this->WriteExcel($sheet, $data, $rowOffset);
			$rowOffset++;
//exit();
		}

		//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
		$writer = new Writer($book);
		$writer->save($output_file_path);

		// ダウンロード
	    header('Content-Type: application/octet-stream');
	    header('Content-Disposition: attachment;filename="' . $outputFile . '"');
	    header('Cache-Control: max-age=0');
 
	    //$book->setActiveSheetIndex(0);
    	//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
    	$writer->save('php://output'); 
    	exit;
	}


	private function WriteExcel($sheet, $data, $rowOffset){
		foreach ($data as $row => $fields) {
//debug($fields);
//debug($row);
//exit();
//		    foreach ($menu as $no => $fields) {
//debug($fields);
//debug($no);
				$col = 0;
			    foreach ($fields as $field => $value) {
//debug($row);
//debug($col);
//debug($value);
        			$sheet->setCellValueByColumnAndRow($col++, $row + $rowOffset, $value);
//exit();
				}
//exit();
//    		}
		}
	}

	private function ChangeData($data0, $yms){
//debug($yms);
//debug($yms[0]);
//debug($yms[count($yms)-1]);
		$MaxSpeed = 0;
		$AverageSpeed = 0;
		$SuddenBrakes = 0;
		$SuddenAcceleration = 0;
		$SuddenHandles = 0;
		$SafetyEvaluation = 0;
		$EcoDrivingEvaluation = 0;
		$TotalEvaluation = 0;
		$DrivingDays = 0;
		
		$p = count($yms);
		for($i=0; $i<$p; $i++){
			$k = 0;
			$data[$i][$k++] = $i + 1;
			$q = count($data0);
			for($j=0; $j<$q; $j++){
				if($data0[$j]['Kitaro']['YearMonth'] == $yms[$i]){
					$data[$i][$k++] = $data0[$j]['Kitaro']['YearMonth'];	//集計年月
					$data[$i][$k++] = $data0[$j]['Kitaro']['CarName'];	//車両名
					$CarName = $data0[$j]['Kitaro']['CarName'];

					$data[$i][$k++] = $data0[$j]['Kitaro']['UserName'];	//利用者名
					$UserName = $data0[$j]['Kitaro']['UserName'];
					
					$data[$i][$k++] = $data0[$j]['Kitaro']['MaxSpeed'];	//月間最高速度(km/h)
					$MaxSpeed += $data0[$j]['Kitaro']['MaxSpeed'];
					
					$data[$i][$k++] = $data0[$j]['Kitaro']['AverageSpeed'];	//月間平均速度(km/h)
					$AverageSpeed += $data0[$j]['Kitaro']['AverageSpeed'];
					$data[$i][$k++] = $data0[$j]['Kitaro']['SuddenBrakes'];	//月間急ブレーキ数
					$SuddenBrakes += $data0[$j]['Kitaro']['SuddenBrakes'];
					$data[$i][$k++] = $data0[$j]['Kitaro']['SuddenAcceleration'];	//月間急加速数
					$SuddenAcceleration += $data0[$j]['Kitaro']['SuddenAcceleration'];
					$data[$i][$k++] = $data0[$j]['Kitaro']['SuddenHandles'];	//月間急ハンドル数
					$SuddenHandles += $data0[$j]['Kitaro']['SuddenHandles'];
					$data[$i][$k++] = $data0[$j]['Kitaro']['SafetyEvaluation'];	//月間安全評価(%)
					$SafetyEvaluation += $data0[$j]['Kitaro']['SafetyEvaluation'];
					$data[$i][$k++] = $data0[$j]['Kitaro']['EcoDrivingEvaluation'];	//月間エコドライブ評価(%)
					$EcoDrivingEvaluation += $data0[$j]['Kitaro']['EcoDrivingEvaluation'];
					$data[$i][$k++] = $data0[$j]['Kitaro']['TotalEvaluation'];	//月間総合評価(%)
					$TotalEvaluation += $data0[$j]['Kitaro']['TotalEvaluation'];
					$data[$i][$k++] = $data0[$j]['Kitaro']['DrivingDays'];	//乗車日数
					$DrivingDays += $data0[$j]['Kitaro']['DrivingDays'];
				}
			}
		}
		$k = 0;
		$data[$i][$k++] = $p+1;
		$data[$i][$k++] = "平均";
		$data[$i][$k++] = $CarName;
		$data[$i][$k++] = $UserName;
		$data[$i][$k++] = number_format($MaxSpeed / $q, 1);
		$data[$i][$k++] = number_format($AverageSpeed / $q, 1);
		$data[$i][$k++] = number_format($SuddenBrakes / $q, 1);
		$data[$i][$k++] = number_format($SuddenAcceleration / $q, 1);
		$data[$i][$k++] = number_format($SuddenHandles / $q, 1);
		$data[$i][$k++] = number_format($SafetyEvaluation / $q, 2);
		$data[$i][$k++] = number_format($EcoDrivingEvaluation / $q, 2);
		$data[$i][$k++] = number_format($TotalEvaluation / $q, 2);
		$data[$i][$k++] = number_format($DrivingDays / $q, 1);
		
//debug($data);
//exit();
		return $data;
	}


}
?>