<?php
//	http://localhost:81/inabou/delivery/
//  http://p7.inabous.net/inabou/delivery/

// Excel出力用ライブラリ
//App::import( 'Vendor', 'PHPExcel', array('file'=>'phpexcel' . DS . 'PHPExcel.php') );
//App::import( 'Vendor', 'PHPExcel_IOFactory', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'IOFactory.php') );
//App::import( 'Vendor', 'PHPExcel_Cell_AdvancedValueBinder', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Cell' . DS . 'AdvancedValueBinder.php') );
// Excel95用ライブラリ
//App::import( 'Vendor', 'PHPExcel_Writer_Excel5', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Writer' . DS . 'Excel5.php') );
//App::import( 'Vendor', 'PHPExcel_Reader_Excel5', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Reader' . DS . 'Excel5.php') );

// Excel2007用ライブラリ
//App::import( 'Vendor', 'PHPExcel_Writer_Excel2007', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Writer' . DS . 'Excel2007.php') );
//App::import( 'Vendor', 'PHPExcel_Reader_Excel2007', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Reader' . DS . 'Excel2007.php') );


if(file_exists('D:\xampp\htdocs\vendor\autoload.php'))
	require 'D:\xampp\htdocs\vendor\autoload.php';
else
	require '/home/enzbaoev/public_html/p7/vendor/autoload.php';

//use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx as Writer;
use PhpOffice\PhpSpreadsheet\Reader\Xlsx as Reader;
use PhpOffice\PhpSpreadsheet\RichText\RichText as RichText; //RichTextAPIを使用
use PhpOffice\PhpSpreadsheet\Style;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;


App::uses('AppController', 'Controller');
App::import('Vendor', 'util/common');

class DeliveryController extends AppController {
	public $name = 'Delivery';
	public $uses = array('Delivery', 'Delivery2', 'User', 'User2');	//'Delivery'
	public $layout = 'delivery';
	public $helpers = array('Html', 'Common');		//'Common', 'Html', , 'QrCode'
	public $components = array('Common', 'Auth');		//'Auth' 

	public $_dir = "/inabou/";
	public $_url = "";
	public $_path = WWW_ROOT;

	public function beforeFilter(){
		//parent::beforeFilter();
		//$this->Auth->allow();
		date_default_timezone_set('Asia/Tokyo');

		$this->_dir = "/inabou/";
		$this->set('_dir', $this->_dir);
		
		$this->_url = FULL_BASE_URL.$this->_dir;
		$this->set('_url', $this->_url);

		$this->_path = WWW_ROOT;
		$this->set('_path', $this->_path);

		$this->set('_store_id', $this->_store_id);

		$main_title = "メニュー管理";
		$this->set('main_title', $main_title);
	}

	public function index($username=""){
		$this->redirect(array('controller' => 'delivery', 'action' => 'search', $username));
	}

	public function search($username= "", $mode=0){
//debug($this->Auth->user());
//exit();
		$this->set('main_title', "納品書検索");
		$error_msg = "";

//`id`,`DeliNum`,`DeliComName`,`ClientName`,`OrderName`,`DeliDate`,`DeliDate2`,
//`ProductName`,`ProductNum`,`ProductCode`,`Mfg`,`Qty`,`Unit`,`UnitPrice`,`Tax`,`Note`,
//`Total`,`filename`,`DeliComId`,`OrderId`, 
		$search['id'] = "";
		$search['DeliComName'] = "";
		$search['DeliDate'] = "";
		$search['ClientName'] = "";
		$search['ProductName'] = "";
		$search['OrderName'] = "";
//debug($search['DeliDate1']);

		if($this->request->data and $mode==0){
			if(isset($this->request->data['Delivery'])){
				$search = $this->request->data['Delivery'];
			}
		}
		$search['DeliDate1'] = $this->Delivery->field('MIN(DeliDate) as DeliDate1');
		$search['DeliDate2'] = $this->Delivery->field('MAX(DeliDate) as DeliDate2');
		$conditions = $this->GetPostData($search);
//debug($conditions);
		$this->paginate = array(
			'Delivery' => array(
				'page' => 1,
				'limit' => 50,
				'order' => array('DeliDate' => 'desc'),		//id'), 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('Delivery');
		$this->set('data', $data);
		$this->set('search', $search);
		$this->set('error_msg', $error_msg);

	//	$common = new Util\Common();
	//	$DeliComNames = $common->get_array_data('Delivery', 'DeliComName');
		$DeliComNames = $this->Common->GetArrayData('Delivery', 'DeliComName');
//debug($DeliComNames);
		$this->set('DeliComNames', $DeliComNames);

		$ClientNames = $this->Common->GetArrayData('Delivery', 'ClientName');
		$this->set('ClientNames', $ClientNames);

		$OrderNames = $this->Common->GetArrayData('Delivery', 'OrderName');
		$this->set('OrderNames', $OrderNames);

//debug($this->Auth->user());
		$user0 = $this->Auth->User();
		$this->set('login_id', $user0['id']);

	}

	public function search_edit($id = 0){
		$this->layout = 'delivery';

		$this->set('main_title', "納品書検索・編集");
		$this->set('sub_title', "納品書検索・編集");
		$error_msg = "";

		if($this->request->data){
//debug($this->request->data);
			$search = $this->request->data['Delivery'];
//debug($search);
			if($search['id'])
				$conditions['id'] = $search['id'];
		}
		$data = $this->Delivery->find('first', array('conditions' => array("id" => $id) ));
		
		$this->set('data', $data['Delivery']);
		$this->set('error_msg', $error_msg);
	}


//	http://localhost/iabou/delivery/export_excel/
//  http://http://p7.inabous.net/iabou/delivery/export_excel/
	public function export_excel(){
		$this->autoRender = false;	//View File なし
		$outputFile = date("Ymd")."_delivery.xlsx";
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'delivery'.DS.$outputFile;
		//$output_file_path = str_replace('/', '\\', $output_file_path);
 
		// 文字コード変換
		$output_file_path = mb_convert_encoding($output_file_path, "SJIS", "UTF-8");
		///////////////////////////////////////////////////////////////////////////

		//$fields = array();

//debug($this->request->data);
		$search = $this->request->data['Delivery'];
		$conditions = $this->GetPostData($search);

		//$group = array();
		$orders = array('id');
		$data = $this->Delivery->find('all', array('conditions'=>$conditions, 'order'=>$orders ));	//'fields'=>$fields,  'group'=>$group,

		$items = array('id','納品書番号','納品会社','件名','担当','日付','日付2',
			'品名','型番','コード','メーカー','数量','単位','単価','税金','備考','合計','ファイル名','納品会社id','担当id','フォルダ名');

		//$book = new PHPExcel();
		//$book->getActiveSheet()->setTitle(date("Y年m月d日"));
		//$sheet = $book->getActiveSheet();


		$book = new Spreadsheet();
		$sheet = $book->getActiveSheet();
		$sheet->setTitle(date("Y年m月d日"));

		$row = 1;
		foreach ($items as $col => $value) {
//debug($value);
//debug($col);
//exit();
        	$sheet->setCellValueByColumnAndRow($col, $row, $value);
		}

		$rowOffset = 2;
		foreach ($data as $row => $menu) {
//debug($menu);
//debug($row);
		    foreach ($menu as $no => $fields) {
//debug($fields);
//debug($no);
				$col = 0;
			    foreach ($fields as $field => $value) {
//debug($value);
//debug($field);
        			$sheet->setCellValueByColumnAndRow($col++, $row + $rowOffset, $value);
				}
//exit();
    		}
		}

		//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
		$writer = new Writer($book);
		$writer->save($output_file_path);

		// ダウンロード
	    header('Content-Type: application/octet-stream');
	    header('Content-Disposition: attachment;filename="' . $outputFile . '"');
	    header('Cache-Control: max-age=0');
 
	    //$book->setActiveSheetIndex(0);
    	//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
    	$writer->save('php://output'); 
    	exit;
	}

	private function GetPostData($search){
		$conditions = array();

		if(!isset($search['id']))
			return $conditions;
		if($search['id'])
			$conditions['id'] = $search['id'];
		if($search['DeliComName'])
			$conditions['DeliComName'] = $search['DeliComName'];
		if($search['ClientName'])
			$conditions['ClientName'] = $search['ClientName'];
		if($search['OrderName'])
			$conditions['OrderName'] = $search['OrderName'];

		if($search['ProductName']){
			$conditions['OR'] = array('ProductName LIKE' => '%'.$search['ProductName'].'%',
										 'ProductNum LIKE' => '%'.$search['ProductName'].'%',
										 'ProductCode LIKE' => '%'.$search['ProductName'].'%');
		}
		if($search['DeliDate1'] and $search['DeliDate2']){
			$conditions['DeliDate BETWEEN ? and ?'] = array($search['DeliDate1'], $search['DeliDate2']);
		}
		return $conditions;
	}

	public function search2($mode=0){
		$this->set('main_title', "納品書・商品検索");
		$error_msg = "";
//	`id`,`ProductName`,`ProductNum`,`ProductCode`,`Mfg`,`Qty`,`Unit`,`UnitPrice`,`Tax`,`Note`,
//	`Total`,`DeliComName`,`ClientName`,`OrderName`,`DeliDate`,`subFolder`,`filename`,`deli_id`
//`Total`,`filename`,`DeliComId`,`OrderId`, 

		$search['id'] = "";
		$search['DeliComName'] = "";
		$search['DeliDate'] = "";
		$search['ClientName'] = "";
		$search['ProductName'] = "";
		$search['OrderName'] = "";
//debug($search);

		if($this->request->data and $mode==0){
			if(isset($this->request->data['Delivery2'])){
				$search = $this->request->data['Delivery2'];
			}
		}
		$search['DeliDate1'] = $this->Delivery->field('MIN(DeliDate) as DeliDate1');
		$search['DeliDate2'] = $this->Delivery->field('MAX(DeliDate) as DeliDate2');
//debug($search);
		$conditions = $this->GetPostData2($search);
//debug($conditions);
		$this->paginate = array(
			'Delivery2' => array(
				'page' => 1,
				'limit' => 50,
				'order' => array('ProductName', 'DeliDate' => 'desc'), 		// desc
				'group' => array('ProductName'),
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('Delivery2');
		$this->set('data', $data);
		$this->set('search', $search);
		$this->set('error_msg', $error_msg);

	//	$common = new Util\Common();
	//	$DeliComNames = $common->get_array_data('Delivery2', 'DeliComName');
		$DeliComNames = $this->Common->GetArrayData('Delivery2', 'DeliComName');
//debug($DeliComNames);
		$this->set('DeliComNames', $DeliComNames);

		$ClientNames = $this->Common->GetArrayData('Delivery2', 'ClientName');
		$this->set('ClientNames', $ClientNames);

		$OrderNames = $this->Common->GetArrayData('Delivery2', 'OrderName');
		$this->set('OrderNames', $OrderNames);
	}

	public function search_edit2($id = 0){
		$this->layout = 'delivery';

		$this->set('main_title', "納品書・商品検索・編集");
		$this->set('sub_title', "納品書・商品検索・編集");
		$error_msg = "";

		if($this->request->data){
//debug($this->request->data);
			$search = $this->request->data['Delivery2'];
//debug($search);
			if($search['id'])
				$conditions['id'] = $search['id'];
		}
		$data = $this->Delivery2->find('first', array('conditions' => array("id" => $id) ));
		
		$this->set('data', $data['Delivery2']);
		$this->set('error_msg', $error_msg);
	}


//	http://localhost/iabou/delivery/export_excel/
//  http://http://p7.inabous.net/iabou/delivery/export_excel/
	public function export_excel2(){
		$this->autoRender = false;	//View File なし
		$outputFile = date("Ymd")."_delivery.xlsx";
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'delivery'.DS.$outputFile;
		//$output_file_path = str_replace('/', '\\', $output_file_path);
 
		// 文字コード変換
		$xcellFile = mb_convert_encoding($output_file_path, "SJIS", "UTF-8");
		///////////////////////////////////////////////////////////////////////////

		//$fields = array();

//debug($this->request->data);
		$search = $this->request->data['Delivery2'];
		$conditions = $this->GetPostData2($search);

		//$group = array();
		$orders = array('id');
		$data = $this->Delivery2->find('all', array('conditions'=>$conditions, 'order'=>$orders ));	//'fields'=>$fields,  'group'=>$group,

		$items = array('id','商品名','商品型番','商品コード','メーカー','数量','単位','単価','税金','備考',
			'合計','納品会社','案件名','担当','日付','フォルダ名','ファイル名','納品書ID');

		//$book = new PHPExcel();
		//$book->getActiveSheet()->setTitle(date("Y年m月d日"));
		//$sheet = $book->getActiveSheet();
		$book = new Spreadsheet();
		$sheet = $book->getActiveSheet();
		$sheet->setTitle(date("Y年m月d日"));

		$row = 1;
		foreach ($items as $col => $value) {
//debug($value);
//debug($col);
//exit();
        	$sheet->setCellValueByColumnAndRow($col, $row, $value);
		}

		$rowOffset = 2;
		foreach ($data as $row => $menu) {
//debug($menu);
//debug($row);
		    foreach ($menu as $no => $fields) {
//debug($fields);
//debug($no);
				$col = 0;
			    foreach ($fields as $field => $value) {
//debug($value);
//debug($field);
        			$sheet->setCellValueByColumnAndRow($col++, $row + $rowOffset, $value);
				}
//exit();
    		}
		}

		//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
		$writer = new Writer($book);
		$writer->save($excel_file);

	// メモリの解放
		$book->disconnectWorksheets();
		unset($book);
//exit();
		// ファイルのダウンロード
		$dl_file = $excel_file;
		header('Content-Type: application/force-download');
		header('Content-Length: '.filesize($xcellFile));
		header('Content-Disposition: attachment; filename="'.mb_convert_encoding($dl_file, 'SJIS-win', 'UTF-8').'"');
		readfile($xcellFile);
    	exit;
	}

	private function GetPostData2($search){
//debug($search);
		$conditions = array();
		if($search['id'])
			$conditions['id'] = $search['id'];
		if($search['DeliComName'])
			$conditions['DeliComName'] = $search['DeliComName'];
		if($search['ClientName'])
			$conditions['ClientName'] = $search['ClientName'];
		if($search['OrderName'])
			$conditions['OrderName'] = $search['OrderName'];

		if($search['ProductName']){
			$conditions['OR'] = array('ProductName LIKE' => '%'.$search['ProductName'].'%',
										 'ProductNum LIKE' => '%'.$search['ProductName'].'%',
										 'ProductCode LIKE' => '%'.$search['ProductName'].'%');
		}
		if($search['DeliDate1'] and $search['DeliDate2']){
			$conditions['DeliDate BETWEEN ? and ?'] = array($search['DeliDate1'], $search['DeliDate2']);
		}
		return $conditions;
	}




	//http://localhost/inabou/deliveries/summary1
	public function summary1(){
		$ret = $this->Delivery->find('first', array('fields' => array('Min(DeliDate) as min_DeliDate')));
		$start_date = $ret[0]['min_DeliDate'];
//debug($start_date);
		$a = explode("-", $start_date);
		$year = intval($a[0]);
		$month = intval($a[1]);

		$ret = $this->Delivery->find('first', array('fields' => array('Max(DeliDate) as max_DeliDate')));
		$end_date = $ret[0]['max_DeliDate'];
//debug($end_date);
		$month1   = date('Y', strtotime($start_date)) * 12 + date('m', strtotime($start_date));
		$month2   = date('Y', strtotime($end_date)) * 12 + date('m', strtotime($end_date));
		$sabun    = $month2 - $month1;
//debug($sabun);
		$suppliers1 = $this->GetDeliComName("count");
		$suppliers2 = $this->GetDeliComName('total');
//debug(count($suppliers1));
//debug(count($suppliers2));
//exit();
		for($i=0; $i < $sabun+1; $i++){
			if(($month + $i) > 12){
				$year += 1;
				$month = ($i * -1) + 1;  		//???????????????要Check
//debug($i);
//debug($month);
//exit();
				$yearmonth = $year."-01"; //nullでも構いません
			}else{
				$yearmonth = $year."-".($month + $i); //nullでも構いません
			}
//debug($yearmonth);
			$data1[$i][0] = $yearmonth;
			$data2[$i][0] = $yearmonth;

			$firstDate = date('Y-m-d', strtotime('first day of ' . $yearmonth));
			$lastDate = date('Y-m-d', strtotime('last day of ' . $yearmonth));
//debug($firstDate);
//debug($lastDate);

			$sql = "SELECT COUNT(*) AS `count`, SUM(`Total`) as `sum` FROM `deliveries` ";
			$sql .= "WHERE `DeliDate` BETWEEN '".$firstDate."' AND '".$lastDate."'";
//debug($sql);
			$ret = $this->Delivery->query($sql);

			$data1[$i][1] = $ret[0][0]['count'];
			$data2[$i][1] = $ret[0][0]['sum'];

			for($j=0; $j<count($suppliers1); $j++){
				$sql = "SELECT COUNT(*) AS `count` FROM `deliveries` ";
				$sql .= "WHERE `DeliDate` BETWEEN '".$firstDate."' AND '".$lastDate."'";
				$sql .= " AND `DeliComName` LIKE '%".$suppliers1[$j]."%'";
//debug($sql);
//exit();
				$ret = $this->Delivery->query($sql);
				$data1[$i][$j+2] = $ret[0][0]['count'];
			}

			for($j=0; $j<count($suppliers2); $j++){
				$sql = "SELECT SUM(`Total`) as `sum` FROM `deliveries` ";
				$sql .= "WHERE `DeliDate` BETWEEN '".$firstDate."' AND '".$lastDate."'";
				$sql .= " AND `DeliComName` LIKE '%".$suppliers2[$j]."%'";
//debug($sql);
//exit();
				$ret = $this->Delivery->query($sql);
				$data2[$i][$j+2] = $ret[0][0]['sum'];
			}
//debug($data1);
//debug($data2);
//exit();
		
		}
//debug($data1);
//debug($data2);
//exit();
		$filename = $this->xlsx_write_proc2($data1, $data2, $suppliers1, $suppliers2);
		echo($filename);
exit();
	}




	function xlsx_write_proc2($data1, $data2, $suppliers1, $suppliers2){
		$count = count($suppliers1);

		$this->autoRender = false;	//View File なし
		$outputFile = date("Ymd")."_delivery.xlsx";
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'delivery'.DS.$outputFile;

		//$book = new PHPExcel();
		//$book->getActiveSheet()->setTitle(date("Y年m月d日"));
		//$sheet = $book->getActiveSheet();
		$book = new Spreadsheet();
		$sheet = $book->getActiveSheet();
		$sheet->setTitle(date("Y年m月d日"));

		$offset = count($data1) + 4;

		$sheet->setCellValueByColumnAndRow(0, 1, "年月");
		$sheet->setCellValueByColumnAndRow(0, 1+$offset, "年月");
		$sheet->setCellValueByColumnAndRow(1, 1, "月件数");
		$sheet->setCellValueByColumnAndRow(1, 1+$offset, "月金額");
		for($i=0; $i<$count; $i++){
			$sheet->setCellValueByColumnAndRow($i+2, 1, 		$suppliers1[$i]);
			$sheet->setCellValueByColumnAndRow($i+2, 1+$offset, $suppliers2[$i]);
		}
		for($rowIndex=2; $rowIndex<count($data1)+2; $rowIndex++){
			for($columnIndex=0; $columnIndex<$count+2; $columnIndex++){
//debug(($rowIndex-2) . "--" . $columnIndex);
//debug($data1[$rowIndex-2][$columnIndex]);
				$sheet->setCellValueByColumnAndRow($columnIndex, $rowIndex, 		$data1[$rowIndex-2][$columnIndex]);
				$sheet->setCellValueByColumnAndRow($columnIndex, $rowIndex+$offset, $data2[$rowIndex-2][$columnIndex]);
//break;
			}
//break;
		}
//debug($data1);

		//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
		$writer = new Writer($book);
		$writer->save($output_file_path);

		// ダウンロード
	    header('Content-Type: application/octet-stream');
	    header('Content-Disposition: attachment;filename="' . $outputFile . '"');
	    header('Cache-Control: max-age=0');
 
	    //$book->setActiveSheetIndex(0);
    	//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
    	$writer->save('php://output'); 
    	exit;
	}



	function xlsx_write_proc3($data1, $data2, $applicants1, $applicants2){
		$count = count($applicants1);
//debug($count);
		$this->autoRender = false;	//View File なし
		$outputFile = date("Ymd")."_delivery.xlsx";
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'delivery'.DS.$outputFile;

		//$book = new PHPExcel();
		//$book->getActiveSheet()->setTitle(date("Y年m月d日"));
		//$sheet = $book->getActiveSheet();
		$book = new Spreadsheet();
		$sheet = $book->getActiveSheet();
		$sheet->setTitle(date("Y年m月d日"));

		$offset = count($data1) + 4;

		$sheet->setCellValueByColumnAndRow(0, 1, "年月");
		$sheet->setCellValueByColumnAndRow(0, 1+$offset, "年月");
		$sheet->setCellValueByColumnAndRow(1, 1, "月件数");
		$sheet->setCellValueByColumnAndRow(1, 1+$offset, "月金額");
		for($i=0; $i<$count; $i++){
			$sheet->setCellValueByColumnAndRow($i+2, 1, 		$applicants1[$i]);
			$sheet->setCellValueByColumnAndRow($i+2, 1+$offset, $applicants2[$i]);
		}
		for($rowIndex=2; $rowIndex<count($data1)+2; $rowIndex++){
			for($columnIndex=0; $columnIndex<$count+2; $columnIndex++){
//debug(($rowIndex-2) . "--" . $columnIndex);
//debug($data1[$rowIndex-2][$columnIndex]);
				$sheet->setCellValueByColumnAndRow($columnIndex, $rowIndex, 		$data1[$rowIndex-2][$columnIndex]);
				$sheet->setCellValueByColumnAndRow($columnIndex, $rowIndex+$offset, $data2[$rowIndex-2][$columnIndex]);
//break;
			}
//break;
		}
//debug($data1);
		//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
		$writer = new Writer($book);
		$writer->save($output_file_path);

		// ダウンロード
	    header('Content-Type: application/octet-stream');
	    header('Content-Disposition: attachment;filename="' . $outputFile . '"');
	    header('Cache-Control: max-age=0');
 
	    //$book->setActiveSheetIndex(0);
    	//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
    	$writer->save('php://output'); 
    	exit;
	}





	function GetDeliComName($mode="total"){
		if($mode == "total")
			$sql = "SELECT sum(`Total`) as sum, `DeliComName` FROM `deliveries` WHERE `DeliComName` != '' GROUP by `DeliComName`";
		else
			$sql = "SELECT count(*) as sum, `DeliComName` FROM `deliveries` WHERE `DeliComName` != '' GROUP by `DeliComName`";
		
		$ret = $this->Delivery->query($sql);

		$count = count($ret);
//debug($count);
		for($i=0; $i<$count; $i++){
			$d[$i] = array('Sum' => $ret[$i][0]['sum'], 'DeliComName' => $ret[$i]['deliveries']['DeliComName']);
		}
//debug($d);
		$sorted_array = $this->Common->sortByKey('Sum', SORT_DESC, $d);
//debug($sorted_array);
//exit();
		for($i=0; $i<$count; $i++){
			$names[$i] = $sorted_array[$i]['DeliComName'];
		}
//debug($names);
//exit();

		return $names;
	}


	//http://localhost/inabou/deliveries/summary2
	public function summary2(){
		$ret = $this->Delivery->find('first', array('fields' => array('Min(DeliDate) as min_DeliDate')));
		$start_date = $ret[0]['min_DeliDate'];
//debug($start_date);
		$a = explode("-", $start_date);
		$year = intval($a[0]);
		$month = intval($a[1]);

		$ret = $this->Delivery->find('first', array('fields' => array('Max(DeliDate) as max_DeliDate')));
		$end_date = $ret[0]['max_DeliDate'];
//debug($end_date);

		$month1   = date('Y', strtotime($start_date)) * 12 + date('m', strtotime($start_date));
		$month2   = date('Y', strtotime($end_date)) * 12 + date('m', strtotime($end_date));
		$sabun    = $month2 - $month1;
//debug($sabun);
//exit();
		$applicants1 = $this->GetOrderName("count");
		$applicants2 = $this->GetOrderName("total");
//debug(count($applicants1));
//exit();
		for($i=0; $i < $sabun+1; $i++){
			if(($month + $i) > 12){
				$year += 1;
				$month = ($i * -1) + 1;  		//???????????????要Check
//debug($i);
//debug($month);
//exit();
				$yearmonth = $year."-01"; //nullでも構いません
			}else{
				$yearmonth = $year."-".($month + $i); //nullでも構いません
			}
//debug($yearmonth);
			$data1[$i][0] = $yearmonth;
			$data2[$i][0] = $yearmonth;

			$firstDate = date('Y-m-d', strtotime('first day of ' . $yearmonth));
			$lastDate = date('Y-m-d', strtotime('last day of ' . $yearmonth));
//debug($firstDate);
//debug($lastDate);

			$sql = "SELECT COUNT(*) AS `count`, SUM(`Total`) as `sum` FROM `deliveries` ";
			$sql .= "WHERE `DeliDate` BETWEEN '".$firstDate."' AND '".$lastDate."'";
			$ret = $this->Delivery->query($sql);
			$data1[$i][1] = $ret[0][0]['count'];
			$data2[$i][1] = $ret[0][0]['sum'];

			for($j=0; $j<count($applicants1); $j++){
				$sql = "SELECT COUNT(*) AS `count`, SUM(`Total`) as `sum` FROM `deliveries` ";
				$sql .= "WHERE `DeliDate` BETWEEN '".$firstDate."' AND '".$lastDate."'";
				$sql .= " AND `OrderName` LIKE '%".$applicants1[$j]."%'";
				$ret = $this->Delivery->query($sql);
				
				$data1[$i][$j+2] = $ret[0][0]['count'];
				$data2[$i][$j+2] = $ret[0][0]['sum'];
			}
			for($j=0; $j<count($applicants2); $j++){
				$sql = "SELECT COUNT(*) AS `count`, SUM(`Total`) as `sum` FROM `deliveries` ";
				$sql .= "WHERE `DeliDate` BETWEEN '".$firstDate."' AND '".$lastDate."'";
				$sql .= " AND `OrderName` LIKE '%".$applicants2[$j]."%'";
				$ret = $this->Delivery->query($sql);
				
				$data1[$i][$j+2] = $ret[0][0]['count'];
				$data2[$i][$j+2] = $ret[0][0]['sum'];
			}
//debug($data1);
//debug($data2);
//exit();
		
		}
//debug($data1);
//debug($data2);
//exit();
		$filename = $this->xlsx_write_proc3($data1, $data2, $applicants1, $applicants2);
		echo($filename);
exit();
	}



	function GetOrderName($mode="total"){
		if($mode=="total")
			$sql = "SELECT sum(`Total`) as sum, `OrderName` FROM `deliveries` WHERE `OrderName` != '' GROUP by `OrderName`;";
		else
			$sql = "SELECT count(*) as sum, `OrderName` FROM `deliveries` WHERE `OrderName` != '' GROUP by `OrderName`;";

		$ret = $this->Delivery->query($sql);
//debug($ret);
//exit();
		$count = count($ret);
//debug($count);
		for($i=0; $i<$count; $i++){
			$d[$i] = array('Sum' => $ret[$i][0]['sum'], 'OrderName' => $ret[$i]['deliveries']['OrderName']);
		}
//debug($d);
		$sorted_array = $this->Common->sortByKey('Sum', SORT_DESC, $d);
//debug($sorted_array);
//exit();
		for($i=0; $i<$count; $i++){
			$names[$i] = $sorted_array[$i]['OrderName'];
		}
		return $names;
	}


}
