<?php
//	http://localhost:81/inabou/sinvoice/
//  http://p7.inabous.net/inabou/sinvoice/

// Excel出力用ライブラリ
App::import( 'Vendor', 'PHPExcel', array('file'=>'phpexcel' . DS . 'PHPExcel.php') );
App::import( 'Vendor', 'PHPExcel_IOFactory', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'IOFactory.php') );
App::import( 'Vendor', 'PHPExcel_Cell_AdvancedValueBinder', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Cell' . DS . 'AdvancedValueBinder.php') );
// Excel95用ライブラリ
//App::import( 'Vendor', 'PHPExcel_Writer_Excel5', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Writer' . DS . 'Excel5.php') );
//App::import( 'Vendor', 'PHPExcel_Reader_Excel5', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Reader' . DS . 'Excel5.php') );

// Excel2007用ライブラリ
App::import( 'Vendor', 'PHPExcel_Writer_Excel2007', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Writer' . DS . 'Excel2007.php') );
App::import( 'Vendor', 'PHPExcel_Reader_Excel2007', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Reader' . DS . 'Excel2007.php') );

App::uses('AppController', 'Controller');
App::import('Vendor', 'util/common');

class SinvoiceController extends AppController {
	public $name = 'Sinvoice';
	public $uses = array('Sinvoice', 'Sinvoice2');	//'Sinvoice'
	public $layout = 'sinvoice';
	public $helpers = array('Html', 'Common');		//'Common', 'Html', , 'QrCode'
	public $components = array('Common', 'Auth');		//'Auth'

	public $_dir = "/inabou/";
	public $_url = "";
	public $_path = WWW_ROOT;

	public function beforeFilter(){
		//parent::beforeFilter();
		//$this->Auth->allow();
		date_default_timezone_set('Asia/Tokyo');

		$this->_dir = "/inabou/";
		$this->set('_dir', $this->_dir);
		
		$this->_url = FULL_BASE_URL.$this->_dir;
		$this->set('_url', $this->_url);

		$this->_path = WWW_ROOT;
		$this->set('_path', $this->_path);

		$this->set('_store_id', $this->_store_id);

		$main_title = "メニュー管理";
		$this->set('main_title', $main_title);
	}

	public function index(){
		$this->redirect(array('controller' => 'sinvoice', 'action' => 'search'));
	}

	public function search($mode=0){
		$this->set('main_title', "仕入れ請求書検索");
		$error_msg = "";

//``id`,`company`,`order_date`,`order_no`,`subject`,`sinvoice_date`,`received_order`,
// `sales_slip_no`,`sales_department`,`code`,`order_name`,`list_no`,`product_name`,
// `product_code`,`qty`,`unit`,`unit_price`,`price`,`taxs`,`remarks_column`,`sub_total`,
// `tax`,`total`,`page`,`filename`,`a_unit_price`,`discount_rate` 

		$search['id'] = "";
		$search['company'] = "";
		$search['order_date'] = "";
		$search['subject'] = "";
		$search['product_name'] = "";
		$search['order_name'] = "";
//debug($search['order_date1']);

		if($this->request->data and $mode==0){
			if(isset($this->request->data['Sinvoice'])){
				$search = $this->request->data['Sinvoice'];
			}
		}
		$search['order_date1'] = $this->Sinvoice->field('MIN(order_date) as order_date1');
		$search['order_date2'] = $this->Sinvoice->field('MAX(order_date) as order_date2');
		$conditions = $this->GetPostData($search);
//debug($conditions);
		$this->paginate = array(
			'Sinvoice' => array(
				'page' => 1,
				'limit' => 20,
				'order' => array('id'), 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('Sinvoice');
		$this->set('data', $data);
		$this->set('search', $search);
		$this->set('error_msg', $error_msg);
//debug($data);
	//	$common = new Util\Common();
	//	$companys = $common->get_array_data('Sinvoice', 'company');
		$companys = $this->Common->GetArrayData('Sinvoice', 'company');
//debug($companys);
		$this->set('companys', $companys);

		$subjects = $this->Common->GetArrayData('Sinvoice', 'subject');
		$this->set('subjects', $subjects);

		$order_names = $this->Common->GetArrayData('Sinvoice', 'order_name');
		$this->set('order_names', $order_names);
//exit();

//debug($this->Auth->user());
		$user0 = $this->Auth->User();
		$this->set('login_id', $user0['id']);

	}

	public function search_edit($id = 0){
		$this->layout = 'sinvoice';

		$this->set('main_title', "請求書検索・編集");
		$this->set('sub_title', "請求書検索・編集");
		$error_msg = "";

		if($this->request->data){
//debug($this->request->data);
			$search = $this->request->data['Sinvoice'];
//debug($search);
			if($search['id'])
				$conditions['id'] = $search['id'];
		}
		$data = $this->Sinvoice->find('first', array('conditions' => array("id" => $id) ));
		
		$this->set('data', $data['Sinvoice']);
		$this->set('error_msg', $error_msg);
	}


//	http://localhost/iabou/sinvoice/export_excel/
//  http://http://p7.inabous.net/iabou/sinvoice/export_excel/
	public function export_excel(){
		$this->autoRender = false;	//View File なし
		$outputFile = date("Ymd")."_sinvoice.xlsx";
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'sinvoice'.DS.$outputFile;
		//$output_file_path = str_replace('/', '\\', $output_file_path);
 
		// 文字コード変換
		$output_file_path = mb_convert_encoding($output_file_path, "SJIS", "UTF-8");
		///////////////////////////////////////////////////////////////////////////

		//$fields = array();

//debug($this->request->data);
		$search = $this->request->data['Sinvoice'];
		$conditions = $this->GetPostData($search);

		//$group = array();
		$orders = array('id');
		$data = $this->Sinvoice->find('all', array('conditions'=>$conditions, 'order'=>$orders ));	//'fields'=>$fields,  'group'=>$group,

		$items = array('id','請求書番号','納品会社','件名','担当','日付','日付2',
			'品名','型番','コード','メーカー','数量','単位','単価','税金','備考','合計','ファイル名','納品会社id','担当id','フォルダ名');

		$book = new PHPExcel();
		$book->getActiveSheet()->setTitle(date("Y年m月d日"));
		$sheet = $book->getActiveSheet();

		$row = 1;
		foreach ($items as $col => $value) {
//debug($value);
//debug($col);
//exit();
        	$sheet->setCellValueByColumnAndRow($col, $row, $value);
		}

		$rowOffset = 2;
		foreach ($data as $row => $menu) {
//debug($menu);
//debug($row);
		    foreach ($menu as $no => $fields) {
//debug($fields);
//debug($no);
				$col = 0;
			    foreach ($fields as $field => $value) {
//debug($value);
//debug($field);
        			$sheet->setCellValueByColumnAndRow($col++, $row + $rowOffset, $value);
				}
//exit();
    		}
		}

		$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
		$writer->save($output_file_path);

		// ダウンロード
	    header('Content-Type: application/octet-stream');
	    header('Content-Disposition: attachment;filename="' . $outputFile . '"');
	    header('Cache-Control: max-age=0');
 
	    $book->setActiveSheetIndex(0);
    	$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
    	$writer->save('php://output'); 
    	exit;
	}

	private function GetPostData($search){
		$conditions = array();
		if($search['id'])
			$conditions['id'] = $search['id'];
		if($search['company'])
			$conditions['company'] = $search['company'];
		if($search['subject'])
			$conditions['subject'] = $search['subject'];
		if($search['order_name'])
			$conditions['order_name'] = $search['order_name'];

		if($search['product_name']){
			$conditions['OR'] = array('product_name LIKE' => '%'.$search['product_name'].'%',
										 'product_code LIKE' => '%'.$search['product_name'].'%');
		}
		if($search['order_date1'] and $search['order_date2']){
			$conditions['order_date BETWEEN ? and ?'] = array($search['order_date1'], $search['order_date2']);
		}
		return $conditions;
	}

	public function search2($mode=0){
		$this->set('main_title', "請求書・商品検索");
		$error_msg = "";
//	`id`,`product_name`,`product_code`,`ProductCode`,`Mfg`,`Qty`,`Unit`,`UnitPrice`,`Tax`,`Note`,
//	`total`,`company`,`subject`,`order_name`,`order_date`,`subFolder`,`filename`,`deli_id`
//`total`,`filename`,`DeliComId`,`OrderId`, 

		$search['id'] = "";
		$search['company'] = "";
		$search['order_date'] = "";
		$search['subject'] = "";
		$search['product_name'] = "";
		$search['order_name'] = "";
//debug($search);

		if($this->request->data and $mode==0){
			if(isset($this->request->data['Sinvoice2'])){
				$search = $this->request->data['Sinvoice2'];
			}
		}
		$search['order_date1'] = $this->Sinvoice->field('MIN(order_date) as order_date1');
		$search['order_date2'] = $this->Sinvoice->field('MAX(order_date) as order_date2');
//debug($search);
		$conditions = $this->GetPostData2($search);
//debug($conditions);
		$this->paginate = array(
			'Sinvoice2' => array(
				'page' => 1,
				'limit' => 20,
				'order' => array('product_name'), 		// desc
				'group' => array('product_name'),
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('Sinvoice2');
		$this->set('data', $data);
		$this->set('search', $search);
		$this->set('error_msg', $error_msg);

	//	$common = new Util\Common();
	//	$companys = $common->get_array_data('Sinvoice2', 'company');
		$companys = $this->Common->GetArrayData('Sinvoice2', 'company');
//debug($companys);
		$this->set('companys', $companys);

	//	$subjects = $this->Common->GetArrayData('Sinvoice2', 'subject');
	//	$this->set('subjects', $subjects);

		$order_names = $this->Common->GetArrayData('Sinvoice2', 'order_name');
		$this->set('order_names', $order_names);
	}

	public function search_edit2($id = 0){
		$this->layout = 'sinvoice';

		$this->set('main_title', "請求書・商品検索・編集");
		$this->set('sub_title', "請求書・商品検索・編集");
		$error_msg = "";

		if($this->request->data){
//debug($this->request->data);
			$search = $this->request->data['Sinvoice2'];
//debug($search);
			if($search['id'])
				$conditions['id'] = $search['id'];
		}
		$data = $this->Sinvoice2->find('first', array('conditions' => array("id" => $id) ));
		
		$this->set('data', $data['Sinvoice2']);
		$this->set('error_msg', $error_msg);
	}


//	http://localhost/iabou/sinvoice/export_excel/
//  http://http://p7.inabous.net/iabou/sinvoice/export_excel/
	public function export_excel2(){
		$this->autoRender = false;	//View File なし
		$outputFile = date("Ymd")."_sinvoice.xlsx";
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'sinvoice'.DS.$outputFile;
		//$output_file_path = str_replace('/', '\\', $output_file_path);
 
		// 文字コード変換
		$output_file_path = mb_convert_encoding($output_file_path, "SJIS", "UTF-8");
		///////////////////////////////////////////////////////////////////////////

		//$fields = array();

//debug($this->request->data);
		$search = $this->request->data['Sinvoice2'];
		$conditions = $this->GetPostData2($search);

		//$group = array();
		$orders = array('id');
		$data = $this->Sinvoice2->find('all', array('conditions'=>$conditions, 'order'=>$orders ));	//'fields'=>$fields,  'group'=>$group,

		$items = array('id','商品名','商品型番','商品コード','メーカー','数量','単位','単価','税金','実単価',
			'値引き率','フォルダ','ファイル名','仕入請求書ID','請求日','営業担当名');

		$book = new PHPExcel();
		$book->getActiveSheet()->setTitle(date("Y年m月d日"));
		$sheet = $book->getActiveSheet();

		$row = 1;
		foreach ($items as $col => $value) {
//debug($value);
//debug($col);
//exit();
        	$sheet->setCellValueByColumnAndRow($col, $row, $value);
		}

		$rowOffset = 2;
		foreach ($data as $row => $menu) {
//debug($menu);
//debug($row);
		    foreach ($menu as $no => $fields) {
//debug($fields);
//debug($no);
				$col = 0;
			    foreach ($fields as $field => $value) {
//debug($value);
//debug($field);
        			$sheet->setCellValueByColumnAndRow($col++, $row + $rowOffset, $value);
				}
//exit();
    		}
		}

		$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
		$writer->save($output_file_path);

		// ダウンロード
	    header('Content-Type: application/octet-stream');
	    header('Content-Disposition: attachment;filename="' . $outputFile . '"');
	    header('Cache-Control: max-age=0');
 
	    $book->setActiveSheetIndex(0);
    	$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
    	$writer->save('php://output'); 
    	exit;
	}

	private function GetPostData2($search){
//debug($search);
		$conditions = array();
		if($search['id'])
			$conditions['id'] = $search['id'];
		if($search['company'])
			$conditions['company'] = $search['company'];
//		if($search['subject'])
//			$conditions['subject'] = $search['subject'];

		if($search['order_name'])
			$conditions['order_name'] = $search['order_name'];

		if($search['product_name']){
			$conditions['OR'] = array('product_name LIKE' => '%'.$search['product_name'].'%',
										 'product_num LIKE' => '%'.$search['product_name'].'%',
										 'product_code LIKE' => '%'.$search['product_name'].'%');
		}
		if($search['order_date1'] and $search['order_date2']){
			$conditions['order_date BETWEEN ? and ?'] = array($search['order_date1'], $search['order_date2']);
		}
		return $conditions;
	}

/** ============================================================================================================= */





	//http://localhost/inabou/sinvoice/summary1
	public function summary1(){
		$ret = $this->Sinvoice->find('first', array('fields' => array('Min(order_date) as min_order_date')));
		$start_date = $ret[0]['min_order_date'];
//debug($start_date);
		$a = explode("-", $start_date);
		$year = intval($a[0]);
		$month = intval($a[1]);

		$ret = $this->Sinvoice->find('first', array('fields' => array('Max(order_date) as max_order_date')));
		$end_date = $ret[0]['max_order_date'];
//debug($end_date);
		$month1   = date('Y', strtotime($start_date)) * 12 + date('m', strtotime($start_date));
		$month2   = date('Y', strtotime($end_date)) * 12 + date('m', strtotime($end_date));
		$sabun    = $month2 - $month1;
//debug($sabun);
		$suppliers1 = $this->Getcompany("count");
		$suppliers2 = $this->Getcompany('total');
//debug(count($suppliers1));
//debug(count($suppliers2));
//exit();
		for($i=0; $i < $sabun; $i++){
			if(($month + $i) > 12){
				$year += 1;
				$month = ($i * -1) + 1;  		//???????????????要Check
//debug($i);
//debug($month);
//exit();
				$yearmonth = $year."-01"; //nullでも構いません
			}else{
				$yearmonth = $year."-".($month + $i); //nullでも構いません
			}
//debug($yearmonth);
			$data1[$i][0] = $yearmonth;
			$data2[$i][0] = $yearmonth;

			$firstDate = date('Y-m-d', strtotime('first day of ' . $yearmonth));
			$lastDate = date('Y-m-d', strtotime('last day of ' . $yearmonth));
//debug($firstDate);
//debug($lastDate);

			$sql = "SELECT COUNT(*) AS `count`, SUM(`total`) as `sum` FROM `sinvoice` ";
			$sql .= "WHERE `order_date` BETWEEN '".$firstDate."' AND '".$lastDate."'";
//debug($sql);
			$ret = $this->Sinvoice->query($sql);

			$data1[$i][1] = $ret[0][0]['count'];
			$data2[$i][1] = $ret[0][0]['sum'];

			for($j=0; $j<count($suppliers1); $j++){
				$sql = "SELECT COUNT(*) AS `count` FROM `sinvoice` ";
				$sql .= "WHERE `order_date` BETWEEN '".$firstDate."' AND '".$lastDate."'";
				$sql .= " AND `company` LIKE '%".$suppliers1[$j]."%'";
//debug($sql);
//exit();
				$ret = $this->Sinvoice->query($sql);
				$data1[$i][$j+2] = $ret[0][0]['count'];
			}

			for($j=0; $j<count($suppliers2); $j++){
				$sql = "SELECT SUM(`total`) as `sum` FROM `sinvoice` ";
				$sql .= "WHERE `order_date` BETWEEN '".$firstDate."' AND '".$lastDate."'";
				$sql .= " AND `company` LIKE '%".$suppliers2[$j]."%'";
//debug($sql);
//exit();
				$ret = $this->Sinvoice->query($sql);
				$data2[$i][$j+2] = $ret[0][0]['sum'];
			}
//debug($data1);
//debug($data2);
//exit();
		
		}
//debug($data1);
//debug($data2);
//exit();
		$filename = $this->xlsx_write_proc2($data1, $data2, $suppliers1, $suppliers2);
		echo($filename);
exit();
	}




	function xlsx_write_proc2($data1, $data2, $suppliers1, $suppliers2){
		$count = count($suppliers1);

		$this->autoRender = false;	//View File なし
		$outputFile = date("Ymd")."_sinvoice.xlsx";
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'sinvoice'.DS.$outputFile;

		$book = new PHPExcel();
		$book->getActiveSheet()->setTitle(date("Y年m月d日"));
		$sheet = $book->getActiveSheet();

		$offset = count($data1) + 4;

		$sheet->setCellValueByColumnAndRow(0, 1, "年月");
		$sheet->setCellValueByColumnAndRow(0, 1+$offset, "年月");
		$sheet->setCellValueByColumnAndRow(1, 1, "月件数");
		$sheet->setCellValueByColumnAndRow(1, 1+$offset, "月金額");
		for($i=0; $i<$count; $i++){
			$sheet->setCellValueByColumnAndRow($i+2, 1, 		$suppliers1[$i]);
			$sheet->setCellValueByColumnAndRow($i+2, 1+$offset, $suppliers2[$i]);
		}
		for($rowIndex=2; $rowIndex<count($data1)+2; $rowIndex++){
			for($columnIndex=0; $columnIndex<$count+2; $columnIndex++){
//debug(($rowIndex-2) . "--" . $columnIndex);
//debug($data1[$rowIndex-2][$columnIndex]);
				$sheet->setCellValueByColumnAndRow($columnIndex, $rowIndex, 		$data1[$rowIndex-2][$columnIndex]);
				$sheet->setCellValueByColumnAndRow($columnIndex, $rowIndex+$offset, $data2[$rowIndex-2][$columnIndex]);
//break;
			}
//break;
		}
//debug($data1);

		$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
		$writer->save($output_file_path);

		// ダウンロード
	    header('Content-Type: application/octet-stream');
	    header('Content-Disposition: attachment;filename="' . $outputFile . '"');
	    header('Cache-Control: max-age=0');
 
	    $book->setActiveSheetIndex(0);
    	$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
    	$writer->save('php://output'); 
    	exit;
	}



	function xlsx_write_proc3($data1, $data2, $applicants1, $applicants2){
		$count = count($applicants1);
//debug($count);
		$this->autoRender = false;	//View File なし
		$outputFile = date("Ymd")."_sinvoice.xlsx";
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'sinvoice'.DS.$outputFile;

		$book = new PHPExcel();
		$book->getActiveSheet()->setTitle(date("Y年m月d日"));
		$sheet = $book->getActiveSheet();

		$offset = count($data1) + 4;

		$sheet->setCellValueByColumnAndRow(0, 1, "年月");
		$sheet->setCellValueByColumnAndRow(0, 1+$offset, "年月");
		$sheet->setCellValueByColumnAndRow(1, 1, "月件数");
		$sheet->setCellValueByColumnAndRow(1, 1+$offset, "月金額");
		for($i=0; $i<$count; $i++){
			$sheet->setCellValueByColumnAndRow($i+2, 1, 		$applicants1[$i]);
			$sheet->setCellValueByColumnAndRow($i+2, 1+$offset, $applicants2[$i]);
		}
		for($rowIndex=2; $rowIndex<count($data1)+2; $rowIndex++){
			for($columnIndex=0; $columnIndex<$count+2; $columnIndex++){
//debug(($rowIndex-2) . "--" . $columnIndex);
//debug($data1[$rowIndex-2][$columnIndex]);
				$sheet->setCellValueByColumnAndRow($columnIndex, $rowIndex, 		$data1[$rowIndex-2][$columnIndex]);
				$sheet->setCellValueByColumnAndRow($columnIndex, $rowIndex+$offset, $data2[$rowIndex-2][$columnIndex]);
//break;
			}
//break;
		}
//debug($data1);
		$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
		$writer->save($output_file_path);

		// ダウンロード
	    header('Content-Type: application/octet-stream');
	    header('Content-Disposition: attachment;filename="' . $outputFile . '"');
	    header('Cache-Control: max-age=0');
 
	    $book->setActiveSheetIndex(0);
    	$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
    	$writer->save('php://output'); 
    	exit;
	}





	function Getcompany($mode="total"){
		if($mode == "total")
			$sql = "SELECT sum(`total`) as sum, `company` FROM `sinvoice` WHERE `company` != '' GROUP by `company`";
		else
			$sql = "SELECT count(*) as sum, `company` FROM `sinvoice` WHERE `company` != '' GROUP by `company`";
		
		$ret = $this->Sinvoice->query($sql);

		$count = count($ret);
//debug($count);
		for($i=0; $i<$count; $i++){
			$d[$i] = array('Sum' => $ret[$i][0]['sum'], 'company' => $ret[$i]['sinvoice']['company']);
		}
//debug($d);
		$sorted_array = $this->Common->sortByKey('Sum', SORT_DESC, $d);
//debug($sorted_array);
//exit();
		for($i=0; $i<$count; $i++){
			$names[$i] = $sorted_array[$i]['company'];
		}
//debug($names);
//exit();

		return $names;
	}


	//http://localhost/inabou/sinvoice/summary2
	public function summary2(){
		$ret = $this->Sinvoice->find('first', array('fields' => array('Min(order_date) as min_order_date')));
		$start_date = $ret[0]['min_order_date'];
//debug($start_date);
		$a = explode("-", $start_date);
		$year = intval($a[0]);
		$month = intval($a[1]);

		$ret = $this->Sinvoice->find('first', array('fields' => array('Max(order_date) as max_order_date')));
		$end_date = $ret[0]['max_order_date'];
//debug($end_date);

		$month1   = date('Y', strtotime($start_date)) * 12 + date('m', strtotime($start_date));
		$month2   = date('Y', strtotime($end_date)) * 12 + date('m', strtotime($end_date));
		$sabun    = $month2 - $month1;
//debug($sabun);
//exit();
		$applicants1 = $this->GetOrderName("count");
		$applicants2 = $this->GetOrderName("total");
//debug(count($applicants1));
//exit();
		for($i=0; $i < $sabun; $i++){
			if(($month + $i) > 12){
				$year += 1;
				$month = ($i * -1) + 1;  		//???????????????要Check
//debug($i);
//debug($month);
//exit();
				$yearmonth = $year."-01"; //nullでも構いません
			}else{
				$yearmonth = $year."-".($month + $i); //nullでも構いません
			}
//debug($yearmonth);
			$data1[$i][0] = $yearmonth;
			$data2[$i][0] = $yearmonth;

			$firstDate = date('Y-m-d', strtotime('first day of ' . $yearmonth));
			$lastDate = date('Y-m-d', strtotime('last day of ' . $yearmonth));
//debug($firstDate);
//debug($lastDate);

			$sql = "SELECT COUNT(*) AS `count`, SUM(`total`) as `sum` FROM `sinvoice` ";
			$sql .= "WHERE `order_date` BETWEEN '".$firstDate."' AND '".$lastDate."'";
			$ret = $this->Sinvoice->query($sql);
			$data1[$i][1] = $ret[0][0]['count'];
			$data2[$i][1] = $ret[0][0]['sum'];

			for($j=0; $j<count($applicants1); $j++){
				$sql = "SELECT COUNT(*) AS `count`, SUM(`total`) as `sum` FROM `sinvoice` ";
				$sql .= "WHERE `order_date` BETWEEN '".$firstDate."' AND '".$lastDate."'";
				$sql .= " AND `order_name` LIKE '%".$applicants1[$j]."%'";
				$ret = $this->Sinvoice->query($sql);
				
				$data1[$i][$j+2] = $ret[0][0]['count'];
				$data2[$i][$j+2] = $ret[0][0]['sum'];
			}
			for($j=0; $j<count($applicants2); $j++){
				$sql = "SELECT COUNT(*) AS `count`, SUM(`total`) as `sum` FROM `sinvoice` ";
				$sql .= "WHERE `order_date` BETWEEN '".$firstDate."' AND '".$lastDate."'";
				$sql .= " AND `order_name` LIKE '%".$applicants2[$j]."%'";
				$ret = $this->Sinvoice->query($sql);
				
				$data1[$i][$j+2] = $ret[0][0]['count'];
				$data2[$i][$j+2] = $ret[0][0]['sum'];
			}
//debug($data1);
//debug($data2);
//exit();
		
		}
//debug($data1);
//debug($data2);
//exit();
		$filename = $this->xlsx_write_proc3($data1, $data2, $applicants1, $applicants2);
		echo($filename);
exit();
	}



	function GetOrderName($mode="total"){
		if($mode=="total")
			$sql = "SELECT sum(`total`) as sum, `order_name` FROM `sinvoice` WHERE `order_name` != '' GROUP by `order_name`;";
		else
			$sql = "SELECT count(*) as sum, `order_name` FROM `sinvoice` WHERE `order_name` != '' GROUP by `order_name`;";

		$ret = $this->Sinvoice->query($sql);
//debug($ret);
//exit();
		$count = count($ret);
//debug($count);
		for($i=0; $i<$count; $i++){
			$d[$i] = array('Sum' => $ret[$i][0]['sum'], 'order_name' => $ret[$i]['sinvoice']['order_name']);
		}
//debug($d);
		$sorted_array = $this->Common->sortByKey('Sum', SORT_DESC, $d);
//debug($sorted_array);
//exit();
		for($i=0; $i<$count; $i++){
			$names[$i] = $sorted_array[$i]['order_name'];
		}
		return $names;
	}




}
