<?php
//	参照：　http://localhost/inabou/users/login
//	参照：　http//p5.yoshikura.com/inabou/search/


// Excel出力用ライブラリ
App::import( 'Vendor', 'PHPExcel', array('file'=>'phpexcel' . DS . 'PHPExcel.php') );
App::import( 'Vendor', 'PHPExcel_IOFactory', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'IOFactory.php') );
App::import( 'Vendor', 'PHPExcel_Cell_AdvancedValueBinder', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Cell' . DS . 'AdvancedValueBinder.php') );
// Excel95用ライブラリ
//App::import( 'Vendor', 'PHPExcel_Writer_Excel5', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Writer' . DS . 'Excel5.php') );
//App::import( 'Vendor', 'PHPExcel_Reader_Excel5', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Reader' . DS . 'Excel5.php') );

// Excel2007用ライブラリ
App::import( 'Vendor', 'PHPExcel_Writer_Excel2007', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Writer' . DS . 'Excel2007.php') );
App::import( 'Vendor', 'PHPExcel_Reader_Excel2007', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Reader' . DS . 'Excel2007.php') );

App::uses('AppController', 'Controller');
App::import('Vendor', 'util/common');


class SearchController extends AppController {
	public $name = 'Search';
	public $uses = array('User', 'Product', 'Delivery', 'Delivery2', 'Pinvoice', 'Pinvoice2', 'Sinvoice', 'Sinvoice2', 'Purchase', 'Purchase2', 'Logs', 'Delicom2');
	public $layout = 'search';

	public $components = array('Auth', 'Common');	//'Session', , 'Mail', 'Email', 'Qdmail', 'Excel'
	public $helpers = array('Common', 'Html', 'Form');	//'Javascript', , 'Tabular', 'Calender', 'Holiday'

	public $URL_SELF;
	private $debug = false;

	public $_dir = "/inabou/";
	public $_url = "";
	public $_path = WWW_ROOT;

    function beforeFilter() {
		//define("Classes", $_SERVER["DOCUMENT_ROOT"]."/Classes/");

		$this->set('main_title', "商品検索");
		$this->set('error_message', null);
		$this->set('data_error', false);
		$this->set('data_error_msg', "");

		$this->set('URL_SELF', $this->URL_SELF);
		date_default_timezone_set('Asia/Tokyo');

		$this->_dir = "/inabou/";
		$this->set('_dir', $this->_dir);
		
		$this->_url = FULL_BASE_URL.$this->_dir;
		$this->set('_url', $this->_url);

		$this->_path = WWW_ROOT;
		$this->set('_path', $this->_path);
		
		$user0 = $this->Auth->user();
		$this->set('login_category', $user0['category']);
    }

	public function index($main_menu="", $main_year=""){
/*
		$this->set('main_menu', $main_menu);
		$this->set('main_year', $main_year);

		date_default_timezone_set('Asia/Tokyo');
		$this->User->updateAll(
			array( 'accessed' => "'" . date("Y-m-d H:i:s") . "'", 'ip_address' => "'" . $_SERVER["REMOTE_ADDR"] . "'"),
			array( 'id' => $this->Auth->user('id'))
		);
		
		$fp = fopen("./log/Search_log.txt","a");
		fwrite($fp, $this->Auth->user('username') . "," . $this->Auth->user('name1') . "," . $this->Auth->user('name2') . "," . date("Y-m-d H:i:s") . "," . $_SERVER["REMOTE_ADDR"] . "\n");
		fclose($fp);
		$this->save_logs();
*/
		return $this->redirect(array('controller'=>'search','action'=>'search'));
	}

	private function save_logs(){
		return;
/*
		$count = $this->Logs->find('count', array('conditions' => array(
				'username LIKE' => $this->Auth->user('username'),
				'contents LIKE' => "商品検索",
				'accessed >' => date("Y-m-d H:i:s",strtotime("-30 minute"))
				)));
		if($count){
			//debug("1時間以上経ってない");
			return;
		}

		$this->data['Logs']['id'] = null;
		$this->data['Logs']['contents'] = "商品検索";
		$this->data['Logs']['username'] = $this->Auth->user('username');
		$this->data['Logs']['name1'] = $this->Auth->user('name1');
		$this->data['Logs']['name2'] = $this->Auth->user('name2');
		$this->data['Logs']['accessed'] = date("Y-m-d H:i:s");
		$this->data['Logs']['ip_address'] = $_SERVER['REMOTE_ADDR'];
//print_r($this->data); echo "<br>";
		if(!$this->Logs->save($this->data)){		//新規作成
			$errors = $this->Logs->invalidFields();
			$mes = '';
			foreach($errors as $field => $message){
				$mes .= $field." : ".$message."<br />\n";
			}
			$this->set('error_message', $mes);
			$this->set('data', $this->data);
		}
*/
	}



	/* =================== 　商品検索検索　 ======================= */
	public function search() {
		$user0 = $this->Auth->user();
		if($user0['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'search','action'=>'index'));
		}
		$this->set('main_title', '商品検索');
		$this->set('sub_title', '検索');

//****		//$this->MakeWorkIntervalTime();

		//-------------------------------------------------------
		/* 検索単語の取得 */
		$search = $this->Common->getPost($this, 'Search', 'search');
		$id = $this->Common->getPost($this, 'Search', 'id');
		$submit = $this->Common->getPost($this, 'Search', 'submit');


		if(strstr($submit, "クリア")){
			$manufacturer = "";
			$product_name = "";
			$this->set('manufacturer', $manufacturer);
			$this->set('product_name', $product_name);
		}else{
			$manufacturer = $this->Common->getPost($this, 'Search', 'manufacturer');
			$product_name = $this->Common->getPost($this, 'Search', 'product_name');
		}
		/* 検索単語に基づき条件作成 */
		$condition = array();
//$manufacturer = "大";
		if($manufacturer){
			$condition = array_merge_recursive($condition, array( 'DeliComName LIKE' => '%'.$manufacturer.'%'));
		}
//$product_name="ベ一ス";
		if($product_name)
			$condition = array_merge_recursive($condition, array(
				 'OR' => array('ProductName LIKE' => '%'.$product_name.'%', 'ProductNum LIKE' => '%'.$product_name.'%', 'ProductCode LIKE ' => '%'.$product_name.'%')
			));
		$condition = array_merge_recursive($condition, array("UnitPrice >" => 0));

		if(($product_name <> "") || ($manufacturer <> ""))
			$data1 = $this->Delivery2->find('all', array('conditions' => $condition, 'order' => array('deli_id' => 'asc', 'ProductName' => 'asc') ));
		else
			$data1 = array();
		$this->set('data1', $data1);
//debug($data1);
//exit();
		//-------------------------------------------------------
		if(strstr($submit, "クリア")){
			$manufacturer = "";
			$product_name = "";
			$this->set('manufacturer', $manufacturer);
			$this->set('product_name', $product_name);
		}else{
			$manufacturer = $this->Common->getPost($this, 'Search', 'manufacturer');
			$product_name = $this->Common->getPost($this, 'Search', 'product_name');
		}
		$condition = array();
		if($manufacturer){
			$condition = array_merge_recursive($condition, array(array('company LIKE' => '%'.$manufacturer.'%')));
		}
		
		if($product_name){
			$condition = array_merge_recursive($condition, array(
				 'OR' => array('product_name LIKE' => '%'.$product_name.'%', 'product_code LIKE' => '%'.$product_name.'%')
			));
		}

		$condition = array_merge_recursive($condition, array("a_unit_price >" => 0));
//debug($condition);
//exit();

		if(($product_name <> "") || ($manufacturer <> ""))
			$data2 = $this->Pinvoice2->find('all', array('conditions' => $condition, 'order' => array('company' => 'asc', 'product_name' => 'asc') ));
		else
			$data2 = array();
		$this->set('data2', $data2);
//debug($data2);
//exit();
		//-------------------------------------------------------
		$condition = array();
		if($manufacturer){
			$condition = array_merge_recursive($condition, array(array('company LIKE' => '%'.$manufacturer.'%')));
		}
		
		if($product_name){
			$condition = array_merge_recursive($condition, array(
				 'OR' => array('product_name LIKE' => '%'.$product_name.'%', 'product_num LIKE' => '%'.$product_name.'%',
				 'product_code LIKE' => '%'.$product_name.'%')
			));
		}

		//$condition = array_merge_recursive($condition, array("partition >" => 0));

		if(($product_name <> "") || ($manufacturer <> ""))
			$data3 = $this->Sinvoice2->find('all', array('conditions' => $condition, 'order' => array('company' => 'asc', 'product_name' => 'asc') ));
		else
			$data3 = array();
		$this->set('data3', $data3);

		//-------------------------------------------------------
		$condition = array();
		if($manufacturer){
			$condition = array_merge_recursive($condition, array(array('Supplier LIKE' => '%'.$manufacturer.'%')));
		}
		
		if($product_name){
			$condition = array_merge_recursive($condition, array(
				 'OR' => array('ProductName LIKE' => '%'.$product_name.'%', 'ModelNo LIKE' => '%'.$product_name.'%',
				 'ProductCode LIKE' => '%'.$product_name.'%')
			));
		}

		//$condition = array_merge_recursive($condition, array("partition >" => 0));

		if(($product_name <> "") || ($manufacturer <> ""))
			$data4 = $this->Purchase2->find('all', array('conditions' => $condition, 'order' => array('Supplier' => 'asc', 'ProductName' => 'asc') ));
		else
			$data4 = array();
		$this->set('data4', $data4);
		//-------------------------------------------------------
//debug($data3);
//exit();
		$companys = $this->Common->GetArrayData('Delicom2', 'delicom2');//Delicom2
		$this->set('companys', $companys);

		$this->set('data', 	$this->data);
		$this->set('login_category', $user0['category']);
		$this->set('login_user', $user0);
	}

	
	function search_export(){
		$year = $this->Common->getPost($this, 'Search', 'ExportDateY');
		if($year == "")
			$year = "2021";
		// 月を指定
		$month = $this->Common->getPost($this, 'Search', 'ExportDateM');
		if($month == "")
			$month = '04';
		$first_date = date('Y-m-d', strtotime('first day of ' . $year."-".$month));
//debug($first_date);
		$week_num = date("w", strtotime($first_date));
//debug($week_num);
		if ($week_num == 0){
			//日曜日だった場合
  			$monday1 = date('Y/m/d', strtotime("-6 day", strtotime($first_date)));
		}else{
  			$monday1 = date('Y/m/d', strtotime("-{$week_num} day", strtotime($first_date) + 24*60*60));
		}
//debug($monday1);
//exit();
		$last_date = date('Y-m-d', strtotime('last day of ' . $year."-".$month));
//debug("指定月の初日：" . $first_date);
//debug("指定月の末日：" . $last_date);

		App::import('Helper', 'Html');
        $html = new HtmlHelper();
		//----------------------------
		//$excel_fil0e = "schedule.xlsx";
		$excel_file0 = "schedule.xls";
		//----------------------------
		$xcellFile0 = $_SERVER['DOCUMENT_ROOT']."/inabou/app/webroot/files/search/ORG/".$excel_file0;
		//$xcellFile0 = $this->Common->ConvPath( WWW_ROOT."files/search/ORG/".$excel_file0);
		if(file_exists($xcellFile0) == false){
			debug("No exists ExcelFile:".$xcellFile0);
			exit();
		}
//debug($xcellFile0);
		//$excel_file = date("YmdHis")."_".$excel_file0;
		$excel_file = date("Ym", strtotime($first_date))."_".$excel_file0;

		$xcellFile = $this->Common->ConvPath( WWW_ROOT."files/search/".$excel_file);
		//$xcellFile = $this->Common->ConvPath( WWW_ROOT."files/search/20210512_".$excel_file);
		if(file_exists($xcellFile)){
			unlink($xcellFile);
		}
		copy($xcellFile0, $xcellFile);
//debug($xcellFile);

		/** PHPExcelを読み込み*/
		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel.php" );
		/** PHPExcel_IOFactory 出力用のphpを読み込み*/
		require_once $this->Common->ConvPath( Classes."phpexcel/PHPExcel/IOFactory.php" );

		// PHPExcelオブジェクトを生成する
		//$obj = PHPExcel_IOFactory::createReader("Excel2007");
		//$obj = PHPExcel_IOFactory::createReader('Excel5');
		
		//$book = $obj->load($xcellFile);
		//$book = new PHPExcel();
		$book = PHPExcel_IOFactory::load($xcellFile);

		$data = $this->Search->find('all', array('conditions' => array( 'work_date BETWEEN ? AND ?' => array($first_date, $last_date)), 
					'order' => ['work_date'=>'asc', 'deploy_name'=>'asc', "CAST(replace(site_time1, ':', '') AS UNSIGNED)" =>'asc', 'id'=>'asc'] ));
		
		//$sql = "SELECT * FROM `search` WHERE `work_date` BETWEEN '".$first_date."' and '".$last_date."' ORDER BY `work_date` asc, `deploy_name` asc, CAST(replace(site_time1, ':', '') AS UNSIGNED) asc, `id` asc ";
		//$data = $this->Search->query($sql);

//$log = $this->Search->getDataSource()->getLog(false, false);       
//debug($log);
		$data_count = count($data);
//debug($data_count);
//debug($data);
//exit();
		$a = ["A2", "A18", "A34", "G2", "G18", "G34", "G50"]; //'日にちの配列
		$b = ["A12", "A28", "A44", "G12", "G28", "G44", "G54"]; //'曜日にちの配列
		$c = ["月", "火", "水", "木", "金", "土", "日"]; //'日にちの配列

		for($sh=0; $sh<6; $sh++){
//$sh=0;
			// シートの設定を行う
			$book->setActiveSheetIndex($sh);
			$sheet = $book->getActiveSheet();
			//-----------------------------------------------
			for($i=0; $i<count($a); $i++){
				// セルに値をセットする
				if($i == 0){
//debug( date("n/d", strtotime($monday1)) );
					$sheet->setCellValue($a[$i], date("n/d", strtotime($monday1)));
				}else{
					$sheet->setCellValue($a[$i], date("n/d", strtotime("+{$i} day", strtotime($monday1))));
				}
				$sheet->setCellValue($b[$i], $c[$i]);
			}
			$monday1 = date('Y/m/d', strtotime( "+{$i} day", strtotime($monday1) ));
			//-----------------------------------------------
		}//endfor
//exit();		
		
        //$rows = [4, 18, 32, 4, 18, 32, 46];
        $rows = [2, 18, 34, 2, 18, 34, 50, 56];
        $cols = [2,  2,  2, 8,  8,  8, 8];
		
		$n = 0;
		$old_deploy_name = "";
		for($sh=0; $sh<6; $sh++){
			// シートの設定を行う
			$book->setActiveSheetIndex($sh);
			$sheet = $book->getActiveSheet();
			//-----------------------------------------------
			for($i=0; $i<count($a); $i++){
				$work_date1 = $year."/".$sheet->getCell( $a[$i] )->getValue();
				for($j=0; $j<16; ){		//1日分の行数
					//$data[$n]['Search'] = $data[$n]['search'];
					if(isset($data[$n]['Search']['work_date']) == false){
//debug($data);
//exit();
						break;
					}
					$work_date2 = $data[$n]['Search']['work_date'];
//debug($work_date1);
//debug($work_date2);
//exit();
					if(strtotime($work_date1) == strtotime($work_date2)){
						if($data[$n]['Search']['deploy_name'] != $old_deploy_name){
						// セルに値をセットする
//debug(($cols[$i] -1)."･".($rows[$i] + $j));
//debug($data[$n]['Search']['site_name']);

//debug($data[$n]['Search']['site_color']);
							$sheet->setCellValueByColumnAndRow( $cols[$i] -1, $rows[$i] + $j, $data[$n]['Search']['site_name']);
							$site_color_str = $data[$n]['Search']['site_color'];
							$sheet->getStyleByColumnAndRow( $cols[$i] -1, $rows[$i] + $j )->getFont()->getColor()->setRGB( $site_color_str );
							
							$sheet->setCellValueByColumnAndRow( $cols[$i] , $rows[$i] + $j, $data[$n]['Search']['car_no']);
							$sheet->setCellValueByColumnAndRow( $cols[$i] +1, $rows[$i] + $j, $data[$n]['Search']['deploy_name']);
							$sheet->setCellValueByColumnAndRow( $cols[$i] +2, $rows[$i] + $j, $data[$n]['Search']['note']);

							$j++;
							$sheet->setCellValueByColumnAndRow( $cols[$i] -1, $rows[$i] + $j, $data[$n]['Search']['site_time1']."-".$data[$n]['Search']['site_time2']);
							$j++;
							$old_deploy_name = $data[$n]['Search']['deploy_name'];
//exit();
						}else{
							$j -= 2;
//debug(($cols[$i] -1)."･".($rows[$i] + $j));
							$site_name_str = $sheet->getCellByColumnAndRow( $cols[$i] -1, $rows[$i] + $j )->getValue();
							$site_name_str .= "|".$data[$n]['Search']['site_name'];
							$site_names = explode("|", $site_name_str);
							$sheet->setCellValueByColumnAndRow( $cols[$i] -1, $rows[$i] + $j, $site_name_str);

							$site_color_str .= "|".$data[$n]['Search']['site_color'];
							$site_colors = explode( "|", $site_color_str );
							//======================================================================================
//if("コムネット府中美好町（共用部のみ）,横浜チラシ")
							//  リッチテキストで前半はサイズ12で、後半はサイズ20で設定
							$objRichText = new PHPExcel_RichText();
							
							for($k=0; $k<count($site_names); $k++){
								if($k <> 0){
									$objTextElm = $objRichText->createTextRun( "|" );
									$objTextElm->getFont()->getColor()->setRGB( "000000" );
								}
								//  リッチテキストに文字列設定
								$objTextElm = $objRichText->createTextRun( $site_names[$k] );
								//  フォントカラー設定
								$objTextElm->getFont()->getColor()->setRGB( $site_colors[$k] );
 							}
							
							//  [xx]セルに設定
							$sheet->getCellByColumnAndRow( $cols[$i] -1, $rows[$i] + $j )->setValue($objRichText);
							//======================================================================================

							$j++;
							$site_time =  $sheet->getCellByColumnAndRow( $cols[$i] -1, $rows[$i] + $j )->getValue();
							$sheet->setCellValueByColumnAndRow( $cols[$i] -1, $rows[$i] + $j, $site_time."|".$data[$n]['Search']['site_time1']."-".$data[$n]['Search']['site_time2']);
							$j++;
						}
						$n++;
					}else{
						break;
					}
					if($n >= $data_count) break;
				}	//end og for $j
				if($i == 8){
					debug("ループ・エラー". $i);
					exit();
				}
				if($n >= $data_count) break;
			}// end of for $i
			//-----------------------------------------------
			if($n >= $data_count) break;
		}//endfor $sh
		// Excel2007形式で保存する
		//$writer = PHPExcel_IOFactory::createWriter($book, "Excel2007");
		$writer = PHPExcel_IOFactory::createWriter($book, 'Excel5');
		$writer->save($xcellFile);

	// メモリの解放
		$book->disconnectWorksheets();
		unset($book);
//exit();
		// ファイルのダウンロード
		$dl_file = $excel_file;
		header('Content-Type: application/force-download');
		header('Content-Length: '.filesize($xcellFile));
		header('Content-Disposition: attachment; filename="'.mb_convert_encoding($dl_file, 'SJIS-win', 'UTF-8').'"');
		readfile($xcellFile);
		exit();
	
		$this->redirect(array('controller'=>'search','action'=>'search'));
	}
	
	

	/* =================== 商品検索詳細 ======================= */
	function search_detail($arg=""){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] == 0){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'search','action'=>'index'));
		}

		$this->set('main_title', '商品検索');
		$this->set('sub_title', '商品検索　＞　詳細');

		if($arg){
			$this->Search->id = $arg;
			$this->Quotation->id = $arg;
		}else{
			$this->Search->id = $this->Common->getPost($this, 'Search', 'id');
		}
		if(empty($this->data)){
			$this->data = $this->Search->read();	//読み出し
			$this->data2 = $this->Quotation->read();	//読み出し
//print_r($this->data);
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
			$this->set('data2', $this->data2);
		}else{
		}
		$this->set('login_category', $user0['User']['category']);
	}
	
	/* =================== 商品検索修正 ======================= */
	function edit($arg=""){
		$arg1="";
//debug($arg);
//debug($arg1);

		$user0 = $this->Auth->user();

		$this->set('main_title', '商品検索');
		$this->set('sub_title', '商品検索　＞　修正');

		if($arg)
			$this->Search->id = $arg;
		else
			$this->Search->id = $this->Common->getPost($this, 'Search', 'id');
//exit();
		if(empty($this->data)){
			$this->data = $this->Search->read();	//読み出し
//debug($this->data);
			//$this->data = $this->Common->utf82sjis($this->data);
			$this->set('data', $this->data);
		}else{
			$button2 = $this->Common->getPost($this, 'Search', 'button2');
			$deploy_name1 = $this->Common->getPost($this, 'Search', 'deploy_name1');
			$deploy_name2 = $this->Common->getPost($this, 'Search', 'deploy_name2');
			$deploy_name3 = $this->Common->getPost($this, 'Search', 'deploy_name3');

//debug($button2);			
//debug($deploy_name3);			

			if( ($button2 == "選択値取得") and ($deploy_name1 <> "") ){
				$deploy_name = $this->ConvDeployName($deploy_name1.",".$deploy_name3);
//debug($deploy_name1);			
//debug($deploy_name);			
//exit();
			}else{
				$this->data['Search']['work_interval'] = "";
//debug($this->data['Search']);
				if(!$this->Search->save($this->data)){		//更新
					$errors = $this->Search->invalidFields();
					$mes = '';
					foreach($errors as $field => $message){
						$mes .= $field." : ".$message."<br />\n";
					}
					$this->set('error_message', $mes);

					//$this->data = $this->Common->utf82sjis($this->data);
					$this->set('data', $this->data);
				}else{
					$this->redirect(array('controller'=>'search','action'=>'search'));
				}
			}
			$this->data = $this->Search->read();	//読み出し
			if(isset($deploy_name))
				$this->data['Search']['deploy_name'] = $deploy_name;
			$this->set('data', $this->data);
		}
		$this->set('login_category', $user0['User']['category']);
		$this->set('next_site_time1', $this->GetNextSiteTime1($arg1, $this->data));
		$this->set('main_menu_no');
	}
	
	
	function ConvDeployName($deploy_names){
		$a = explode(",", $deploy_names);
		for($i=0; $i<count($a); $i++){
			$b = explode(" ", $a[$i]);
			if($i == 0){
				$e = $b[0];
				$f = $b[1];
			}else{
				$c[$i-1] = $b[0];
				$d[$i-1] = $b[1];
			}
		}
		
		$ret1 = $this->User->find('first', array('fields' => array('initial'), 'conditions' => array('name1' => $e, 'name2' => $f)));
//debug($ret1);
		$n[0] = $ret1['User']['initial'];
		if(count($a)==1)
			return $n[0];

		$ret = $this->User->find('all', array('fields' => array('initial'), 'conditions' => array('name1' => $c, 'name2' => $d)));
		for($i=0; $i<count($ret); $i++){
			$n[$i+1] = $ret[$i]['User']['initial'];
		}
		return implode("･", $n);
	}
	
	
	
	function GetNextSiteTime1($arg1, $data1){
		$data2 = $this->Search->find('first', array('conditions' => array('id' => $arg1)));
//debug($data1);
//debug($data2);
//exit();
		if($data2['Search']['work_date'] == $data1['Search']['work_date']){
			if($data2['Search']['work_group'] == $data1['Search']['work_group']){
				return $data2['Search']['site_time1'];
			}
		}
		return "";
	}

	/* =================== 商品検索削除 ======================= */
	function delete($arg=""){
		$user0 = $this->Auth->user();
		if($user0['User']['category'] < 5){
			$this->set('error_message', "このメニューは利用ができません。");
			//$this->redirect(array('controller'=>'Search','action'=>'index'));
		}

		$this->set('main_title', '商品検索');
		$this->set('sub_title', '商品検索　＞　削除');

		if($arg)
			$this->Search->id = $arg;
		else
			$this->Search->id = $this->Common->getPost($this, 'Search', 'id');

		if(empty($this->data)){
			$this->data = $this->Search->read();	//読み出し
			$this->set('data', $this->data);
		}else{
			$this->set('data', $this->data);

			if(!$this->Search->delete($this->Search->id)){		//削除
				$errors = $this->Search->invalidFields();
				$mes = '';
				foreach($errors as $field => $message){
					$mes .= $field." : ".$message."<br />\n";
				}
				$this->set('error_message', $mes);
			}else
				$this->redirect(array('controller'=>'search','action'=>'search'));
		}
		$this->set('login_category', $user0['User']['category']);
	}
	/* =================== 商品検索新規作成 ======================= */
	function search_new(){
		$user0 = $this->Auth->user();

		$this->set('main_title', '商品検索');
		$this->set('sub_title', '商品検索　＞　新規作成');

		if(empty($this->data)){
			$lastID = $this->Search->getLastInsertID();
			if($lastID <= 0){
				$d = $this->Search->find('first', array('fields' => array('Max(id) as max_id')));
				$lastID = $d[0]['max_id'];
			}
			$this->data = $this->Search->find('first', array('conditions' => array('id' => $lastID)));

		}else{
			$button2 = $this->Common->getPost($this, 'Search', 'button2');
			$deploy_name1 = $this->Common->getPost($this, 'Search', 'deploy_name1');
			$deploy_name2 = $this->Common->getPost($this, 'Search', 'deploy_name2');
			$deploy_name3 = $this->Common->getPost($this, 'Search', 'deploy_name3');

//debug($button2);			
//debug($deploy_name3);			

			if( ($button2 == "選択値取得") and ($deploy_name1 <> "") ){
				$deploy_name = $this->ConvDeployName($deploy_name1.",".$deploy_name3);
//debug($deploy_name1);			
//debug($deploy_name);			
//exit();
				$lastID = $this->Search->getLastInsertID();
				if($lastID <= 0){
					$d = $this->Search->find('first', array('fields' => array('Max(id) as max_id')));
					$lastID = $d[0]['max_id'];
				}
				$this->data = $this->Search->find('first', array('conditions' => array('id' => $lastID)));
				$this->data['Search']['deploy_name'] = $deploy_name;
				
			}else{
				$this->data['Search']['work_interval'] = "";
				$this->data['Search']['id'] = null;
//debug($this->data['Search']);
//exit();
				if(!$this->Search->save($this->data)){		//新規作成
					$errors = $this->Search->invalidFields();
					$mes = '';
					foreach($errors as $field => $message){
						$mes .= $field." : ".$message."<br />\n";
					}
					$this->set('error_message', $mes);

					$this->set('data', $this->data);
				}else{
					$this->redirect(array('controller'=>'search','action'=>'search'));

					$lastID = $this->Search->getLastInsertID();
					if($lastID <= 0){
						$d = $this->Search->find('first', array('fields' => array('Max(id) as max_id')));
						$lastID = $d[0]['max_id'];
					}
					$this->data = $this->Search->find('first', array('conditions' => array('id' => $lastID)));
				}
			}
		}
		$this->set('data', $this->data);
		$this->set('login_category', $user0['User']['category']);
	}



	public function upload() {
		if(isset($_POST['submit'])) {
    		if(isset($_FILES['uploadFile']['name']) && $_FILES['uploadFile']['name'] != "") {
        		$allowedExtensions = array("xls","xlsx");
        		$ext = pathinfo($_FILES['uploadFile']['name'], PATHINFO_EXTENSION);
		
				if(in_array($ext, $allowedExtensions)) {
					// Uploaded file
               		
					$file = WWW_ROOT."files/search/R/".$_FILES['uploadFile']['name'];
					
               		$isUploaded = copy($_FILES['uploadFile']['tmp_name'], $file);
			   		// check uploaded file
               		if($isUploaded) {
//debug($file);
//exit();
						$this->redirect(array('controller'=>'search','action'=>'search'));
					}
	            	unlink($file);
                    echo '<span class="msg">File not uploaded!</span>';
					exit();
                } else {
                    echo '<span class="msg">File not uploaded!</span>';
					exit();
                }
        	} else {
            	echo '<span class="msg">Please upload excel sheet1.</span>';
				exit();
        	}
    	} else {
        	echo '<span class="msg">Please upload excel file2.</span>';
			exit();
    	}
	}

	private function xlsx_save_proc($up_file){
		//e(Classes."phpexcel/PHPExcel.php");
		/** Main Class */
		require_once Classes."phpexcel/PHPExcel.php";
		/** IO Class */
		require_once Classes."phpexcel/PHPExcel/IOFactory.php";

		//Configure::write('debug', 2);  // debugコードを出す
		$sql = "TRUNCATE TABLE `search`";
		$this->Search->query($sql);

        //データの読み込み
        $readData = $this->Excel->readXls($up_file, 9);	
		// param string $filepath,  int $colCount (Optional),  int $rowCount (Optional),  mix $sheetIndex (Optional)
//debug($readData[0]['data']);
		$k = 0;
		$data = array();
		for($i=2; $i<=count($readData[0]['data']); $i++){
			$data['Search'][] = array(
						'year' => $readData[0]['data'][$i][0],
						'month' => $readData[0]['data'][$i][1],
						'day' => $readData[0]['data'][$i][2],
						'from_time' => $this->Excel->num2time( $readData[0]['data'][$i][3] ),
						'to_time' => $this->Excel->num2time( $readData[0]['data'][$i][4] ),
						'title' => $readData[0]['data'][$i][5],
						'member' => $readData[0]['data'][$i][6],
						'mail' => $readData[0]['data'][$i][7],
						'place' => $readData[0]['data'][$i][8],
						'message' => $readData[0]['data'][$i][9]
						);
			
			$k++;
		}
//debug($data);
		if(!$this->Search->saveAll($data['Search'], array('atomic' => false))){		//更新
			$errors = $this->Search->invalidFields();
			$mes = '';
			foreach($errors as $field => $message){
				$mes .= $field." : ".$message."<br />\n";
			}
			$this->set('error_message', $mes);
		}else{
			if($this->Search->find('count') > 0){
				$this->set('error_message', "ファイル・アップロードに成功しました。");
			}else{
				$this->set('error_message', "ファイル・アップロードに失敗しました。");
debug($this->Search->getAffectedRows());
			}

		}

	}

	private function csv_save_proc($up_file){
		$sql = "TRUNCATE TABLE `search`";
//		$this->Search->query($sql);

		$handle = @fopen($up_file, "r");
		if ($handle) {
			$line = "";
		    while (!feof($handle)) {
		        $buf = fgets($handle, 4096);
//echo "buf=[".$buf."]<hr>";
				$last = substr($buf, -3);
//echo "last=[".$last."]<hr>";
//echo "last=[".bin2hex($last)."]<hr>";
				if(($last == "\x22\x0d\x0a") || ($last == "\x22\x0a")){
					$line .= "\x22";
//echo $line."<hr>";
		//			$this->Common->save_csv_line($this->Search, $line);
					$line = "";
				}else
					$line .= $buf;
		    }
		    fclose($handle);
			$this->set('error_message', "ファイル・アップロードに成功しました。");
		}
	}

	public function make_purchase2(){
		$this->autoRender = false;	//View File なし

		$sql = "TRUNCATE `purchase2`";
		$this->Purchase2->query($sql);
		$n = 1;

		$data1 = $this->Purchase->find('all', array('order' => [ 'id'=>'asc'] ));
		for($i=0; $i<count($data1); $i++){
			$a = explode("|", $data1[$i]['Purchase']['ProductName']);
			$b = explode("|", $data1[$i]['Purchase']['ModelNo']);
			$c = explode("|", $data1[$i]['Purchase']['ProductCode']);
			$d = explode("|", $data1[$i]['Purchase']['Qty']);
			$e = explode("|", $data1[$i]['Purchase']['UnitPrice']);
			$f = explode("|", $data1[$i]['Purchase']['Amount']);

			for($j=0; $j<count($a); $j++){
				$data2 = $data1[$i]['Purchase'];
				$data2['ProductName'] = $a[$j];
				$data2['ModelNo'] = $b[$j];
				$data2['ProductCode'] = $c[$j];
				$data2['Qty'] = $d[$j];
				$data2['UnitPrice'] = $e[$j];
				$data2['Amount'] = $f[$j];

				$data2['Supplier'] = $data1[$i]['Purchase']['Supplier'];
				$data2['purchase_id'] = $data1[$i]['Purchase']['id'];
				$data2['OrderDate'] = $data1[$i]['Purchase']['OrderDate'];
				$data2['OrderName'] = $data1[$i]['Purchase']['OrderName'];
				$data2['id'] = $n++;
//debug($data2);
				$this->Purchase2->save($data2);
//exit();
			
				// INSERT INTO `purchase2` (`id`, `Supplier`, `ProductName`, `ModelNo`, `ProductCode`, `Qty`, `UnitPrice`, `Amount`, 
				// `purchase_id`, `OrderDate`, `OrderName`) VALUES ('', 'Supplier', 'ProductName	', 'ModelNo', 'ProductCode', '1', 
				// '2', '3', '4', '2022-08-25', 'OrderName');
			
			}
		
		}
		echo "Purchase2作成終了";
	}


}