<?php 
//	http://localhost:81/inabou/nas2/
//	http://localhost:81/inabou/nas2/login/takano/inabou/
//	http://localhost:81/inabou/nas2/logout/takano/inabou/
//	http://localhost:81/inabou/nas2/logout/

// Excel出力用ライブラリ
App::import( 'Vendor', 'PHPExcel', array('file'=>'phpexcel' . DS . 'PHPExcel.php') );
App::import( 'Vendor', 'PHPExcel_IOFactory', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'IOFactory.php') );
App::import( 'Vendor', 'PHPExcel_Cell_AdvancedValueBinder', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Cell' . DS . 'AdvancedValueBinder.php') );
// Excel95用ライブラリ
//App::import( 'Vendor', 'PHPExcel_Writer_Excel5', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Writer' . DS . 'Excel5.php') );
//App::import( 'Vendor', 'PHPExcel_Reader_Excel5', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Reader' . DS . 'Excel5.php') );

// Excel2007用ライブラリ
App::import( 'Vendor', 'PHPExcel_Writer_Excel2007', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Writer' . DS . 'Excel2007.php') );
App::import( 'Vendor', 'PHPExcel_Reader_Excel2007', array('file'=>'phpexcel' . DS . 'PHPExcel' . DS . 'Reader' . DS . 'Excel2007.php') );

App::uses('AppController', 'Controller');
App::import('Vendor', 'util/common');

class Nas2Controller extends AppController {
	public $name = 'Nas2';
	public $uses = array('User', 'Naslog', 'Naslog2');
	public $layout = 'login2';
	public $helpers = array('Html', 'Common');		//'Common', 'Html', , 'QrCode'
	public $components = array('Common');		//'Auth'

	public $_dir = "/inabou/";
	public $_url = "";
	public $_path = WWW_ROOT;

	public function beforeFilter(){
		//parent::beforeFilter();
		//$this->Auth->allow();
		date_default_timezone_set('Asia/Tokyo');

		$this->_dir = "/inabou/";
		$this->set('_dir', $this->_dir);
		
		$this->_url = FULL_BASE_URL.$this->_dir;
		$this->set('_url', $this->_url);

		$this->_path = WWW_ROOT;
		$this->set('_path', $this->_path);

		$this->set('_store_id', $this->_store_id);

		$main_title = "ログインチェック";
		$this->set('main_title', $main_title);
	}

	public function index(){
		$this->redirect(array('controller' => 'login', 'action' => 'login'));
	}

	// http://localhost:81/inabou/nas2/login/yoshikura/kayoken2/040E3C36AEC4/JPH049CBC2/YOSHIKURA/
	// http://localhost:81/inabou/nas2/login/yoshikura/kayoken2/abc/JPH049CBC2/YOSHIKURA/

	// https://p7.inabous.net/inabou/nas2/login/yoshikura/kayoken2/040E3C36AEC4/JPC0007/YOSHIKURA/2.00
	// https://p7.inabous.net/inabou/nas2/login/yoshikura/kayoken2/abcdefghijkl/JPC0007/YOSHIKURA/
	public function login($username="", $password="", $mac_address="", $pc_name="", $pcuser_name="", $version=0){
		$this->autoRender = false;	//View File なし

		$data = array();
		if($version > 1){
			//debug($version);
		}

		$error_msg = "";
		if($username == "" or $password == "" or is_null($username) or is_null($password)){
			$error_msg = "データエラー";
			echo $error_msg;
			exit();
//debug($error_msg);
		}else{
			$fields = array();	//array('category', 'name1', 'name2', 'id');
			$conditions = array('username' => $username, 'password2' => $password);
			$data = $this->User->find('first', array('fields' => $fields, 'conditions' => $conditions));
//debug($data);	
			if(count($data) == 1){
				
				$id = $data['User']['id'];
				$mac_address1 = $data['User']['mac_address'];
				$pc_name1 = $data['User']['pc_name'];
				$pcuser_name1 = $data['User']['pcuser_name'];

				if(strlen($mac_address) > 1 and strlen($mac_address1) > 1){
					if($mac_address <> $mac_address1){
						$data2 = array('username' =>$username, 'password2'=>$password, 
							'mac_address'=>$mac_address, 'pc_name'=>$pc_name, 'pcuser_name'=>$pcuser_name,
							'version'=>$version);
//debug($data2);
						$this->send_mail($data, $data2);
					}
				}
//debug($data);
//exit();
				$this->User->set('id', $id);
				$this->User->id = $id;
				$this->User->saveField("mac_address", $mac_address);
				$this->User->saveField("pc_name", $pc_name);
				$this->User->saveField("pcuser_name", $pcuser_name);

				$this->nas_log(0, $username, $mac_address, $pc_name, $pcuser_name);
			}
		}
		//$this->set('error_msg', $error_msg);
		//$this->set('data', $data);
		echo base64_encode( $data['User']['category'] );
		exit();
	}

	public function logout($username="", $password=""){
		$data = array();
		$error_msg = "";
		if($username == "" or $password == "" or is_null($username) or is_null($password)){
			$error_msg = "データエラー";
//debug($error_msg);
		}else{
			$fields = array('category', 'name1', 'name2');
			$conditions = array('username' => $username, 'password2' => $password);
			$data = $this->User->find('first', array('fields' => $fields, 'conditions' => $conditions));
//debug($data);
			$this->nas_log(1, $username);
		}
		$this->set('error_msg', $error_msg);
		$this->set('data', $data);
	}

	//http://p7.inabous.net/inabou/nas2/change_password/yoshikura/
	public function change_password( $username="", $password="" ){
		$this->set('main_title', "ユーザ管理・編集");
		$this->set('sub_title', "ユーザ管理・編集");
		$error_msg = "";
		if($username == "" or $password == "" or is_null($username) or is_null($password)){
			$error_msg = "データエラー";
		}

		if($this->request->data){
//debug($this->request->data);
			$data2 = $this->request->data['User'];
//debug($data2);
			if($data2['id'] and $this->request->data['submit'] == "更新"){
				$data2['password'] = sha1(Configure::read('Security.salt').$data2['password2']);
//debug($data2['password']);
//debug($data2);
				$this->User->save($data2);
			}
			$id =  $data2['id'];
			$username =  $data2['username'];
			$error_msg = "";
		}
		
		if(!$error_msg){
			$data = $this->User->find('first', array('conditions' => array("username" => $username) ));
			if(count($data) == 0){
				$data = array();
				$data['User']['id'] = "";
				$data['User']['name1'] = "";
				$data['User']['name2'] = "";
				$data['User']['username'] = "";
				$data['User']['password'] = "";
				$data['User']['password2'] = "";
				$error_msg = "該当のログイン名がありません。";
			}
			$this->set('data', $data['User']);
		}
		$this->set('error_msg', $error_msg);
	}


	function nas_log($log=0, $username="", $mac_address="", $pc_name="", $pcuser_name=""){
		$data['Naslog']['id'] = null;
		$data['Naslog']['loginout'] = $log;
		$data['Naslog']['username'] = $username;
		$data['Naslog']['logtime'] = date("Y-m-d H:i:s");
		$data['Naslog']['ip_address'] = $_SERVER['REMOTE_ADDR'];
		//$data['Naslog']['useragent'] = $_SERVER['HTTP_USER_AGENT'];
		
		if($log == 0){
			$data['Naslog']['mac_address'] = $mac_address;
			$data['Naslog']['pc_name'] = $pc_name;
			$data['Naslog']['pcuser_name'] = $pcuser_name;
		}
//print_r($data); echo "<br>";
		if(!$this->Naslog->save($data)){		//新規作成
			$errors = $this->Naslog->invalidFields();
			$mes = '';
			foreach($errors as $field => $message){
				$mes .= $field." : ".$message."<br />\n";
			}
			$this->set('error_message', $mes);
			$this->set('data', $data);
		}
	}
	
/*******************************************************************************/
//		http://localhost:81/inabou/admin/
	function admin(){
		$this->layout = 'login3';

		$error_msg = "";
		$this->set('main_title', 'NASログ管理画面');
		$this->set('sub_title', '検索');

		$condition = array();
		
		//$search = $this->Common->getPost($this, 'Naslog', 'search');
		$id = $this->Common->getPost($this, 'Naslog', 'id');
		$logtime1 = $this->Common->getPost($this, 'Naslog', 'logtime1');
		$logtime2 = $this->Common->getPost($this, 'Naslog', 'logtime2');
		$loginout = $this->Common->getPost($this, 'Naslog', 'loginout');
		$username = $this->Common->getPost($this, 'Naslog', 'username');
		$submit = $this->Common->getPost($this, 'Naslog', 'submit');
		if($submit == "クリア"){
//debug($submit);
			$id=$logtime1=$logtime2=$loginout=$username=$submit="";
		}
		
		if($id)
			$condition = array_merge_recursive($condition, array("id" => $id));

		if($logtime1 and $logtime2)
			$condition = array_merge_recursive($condition, array('logtime BETWEEN ? AND ?' => array($logtime1, $logtime2)));

		if($loginout > 0)
			$condition = array_merge_recursive($condition, array( "loginout" => $loginout - 1));

		if($username)
			$condition = array_merge_recursive($condition, array( "username like" => '%'.$username.'%'));

//debug($condition);
		if($loginout == null)
			$loginout = 0;
//debug($loginout);
		$searchword = array(
						//"search" => $search,
					 "id" => urlencode($id),
				     "logtime1" => urlencode($logtime1),
				     "logtime2" => urlencode($logtime2),
				     "loginout" => urlencode($loginout),
				     "username" => urlencode($username),
		);

		$this->paginate = array(
			'Naslog' => array(
				'page' => 1,
				'limit' => 50,
				'order' => array('id'=>'desc'), 		// desc
				'conditions' => $condition, 
			), 
		);
		$data = $this->paginate('Naslog');
		$this->set('data', $data);
		//$this->set('search', $search);
		$this->set('searchword', $searchword);
		$this->set('error_msg', $error_msg);
//debug($data);

		//$user0 = $this->User();
		//$this->set('login_id', $user0['id']);	
	}

//	http://localhost:81/iabou/login/export_excel/
//  http://http://p7.inabous.net/iabou/login/export_excel/
	public function export_excel(){
		$this->autoRender = false;	//View File なし
		$outputFile = date("Ymd")."_login.xlsx";
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'login'.DS.$outputFile;
		//$output_file_path = str_replace('/', '\\', $output_file_path);
 
		// 文字コード変換
		$output_file_path = mb_convert_encoding($output_file_path, "SJIS", "UTF-8");
		///////////////////////////////////////////////////////////////////////////

		//$fields = array();

//debug($this->request->data);
		$data = $this->request->data['Naslog'];
//debug($data);
//exit();
		$condition = array();
		if($data['id'])
			$condition = array_merge_recursive($condition, array("id" => $data['id']));

		if($data['logtime1'] and $data['logtime2'])
			$condition = array_merge_recursive($condition, array('logtime BETWEEN ? AND ?' => array($data['logtime1'], $data['logtime2'])));

		if($data['loginout'] > 0)
			$condition = array_merge_recursive($condition, array( "loginout" => $data['loginout'] - 1));

		if($data['username'])
			$condition = array_merge_recursive($condition, array( "username like" => '%'.$data['username'].'%'));

//debug($condition);
//exit();
		//$group = array();
		$orders = array('id');
		$data = $this->Naslog->find('all', array('conditions'=>$condition, 'order'=>$orders ));	
					//'fields'=>$fields,  'group'=>$group,

		$items = array('', 'id','記録状態','ユーザー名','記録時間','IPアドレス','ユーザーエージェント');

		$book = new Spreadsheet();
		$sheet = $book->getActiveSheet();
		$sheet->setTitle(date("Y年m月d日"));

		$row = 1;
		foreach ($items as $col => $value) {
//debug($value);
//debug($col);
//exit();
        	$sheet->setCellValueByColumnAndRow($col, $row, $value);
		}

		$rowOffset = 2;
		foreach ($data as $row => $menu) {
//debug($menu);
//debug($row);
		    foreach ($menu as $no => $fields) {
//debug($fields);
//debug($no);
				$col = 1;
			    foreach ($fields as $field => $value) {
//debug($value);
//debug($field);
					if($col == 2 and $value == 0)
	        			$sheet->setCellValueByColumnAndRow($col++, $row + $rowOffset, "ログイン");
					elseif($col == 2 and $value == 1)
	        			$sheet->setCellValueByColumnAndRow($col++, $row + $rowOffset, "ログアウト");
					else
	        			$sheet->setCellValueByColumnAndRow($col++, $row + $rowOffset, $value);
					
				}
//exit();
    		}
		}

		//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
		$writer = new Writer($book);
		$writer->save($output_file_path);

		// ダウンロード
	    header('Content-Type: application/octet-stream');
	    header('Content-Disposition: attachment;filename="' . $outputFile . '"');
	    header('Cache-Control: max-age=0');
 
	    //$book->setActiveSheetIndex(0);
    	//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
    	$writer->save('php://output'); 
    	exit;
	}


	public function export_excel2(){
		$this->autoRender = false;	//View File なし
		$outputFile = date("Ymd")."_login2.xlsx";
		// 出力パスを含む、ファイル名
		$output_file_path = WWW_ROOT.'files'.DS.'login'.DS.$outputFile;
		//$output_file_path = str_replace('/', '\\', $output_file_path);
 
		// 文字コード変換
		$output_file_path = mb_convert_encoding($output_file_path, "SJIS", "UTF-8");
		///////////////////////////////////////////////////////////////////////////

		//$fields = array();

//debug($this->request->data);
		$data = $this->request->data['Naslog2'];
//debug($data);
//exit();
		$condition = array();
		if($data['id'])
			$condition = array_merge_recursive($condition, array("id" => $data['id']));

		if($data['logintime1'] and $data['logintime2'])
			$condition = array_merge_recursive($condition, array('logintime BETWEEN ? AND ?' => array($data['logintime1'], $data['logintime2'])));

		if($data['username'])
			$condition = array_merge_recursive($condition, array( "username like" => '%'.$data['username'].'%'));

//debug($condition);
//exit();
		//$group = array();
		$orders = array('id');
		$data = $this->Naslog2->find('all', array('conditions'=>$condition, 'order'=>$orders ));	
					//'fields'=>$fields,  'group'=>$group,

		$items = array('', 'id','ユーザー名','ログイン時間','ログアウト時間','IPアドレス','ユーザーエージェント');

		$book = new Spreadsheet();
		$sheet = $book->getActiveSheet();
		$sheet->setTitle(date("Y年m月d日"));

		$row = 1;
		foreach ($items as $col => $value) {
//debug($value);
//debug($col);
//exit();
        	$sheet->setCellValueByColumnAndRow($col, $row, $value);
		}

		$rowOffset = 2;
		foreach ($data as $row => $menu) {
//debug($menu);
//debug($row);
		    foreach ($menu as $no => $fields) {
//debug($fields);
//debug($no);
				$col = 1;
			    foreach ($fields as $field => $value) {
//debug($value);
//debug($field);
        			$sheet->setCellValueByColumnAndRow($col++, $row + $rowOffset, $value);
				}
//exit();
    		}
		}

		//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
		$writer = new Writer($book);
		$writer->save($output_file_path);

		// ダウンロード
	    header('Content-Type: application/octet-stream');
	    header('Content-Disposition: attachment;filename="' . $outputFile . '"');
	    header('Cache-Control: max-age=0');
 
	    //$book->setActiveSheetIndex(0);
    	//$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
    	$writer->save('php://output'); 
    	exit;
	}

/***********************************************************************/
	public function loginout(){
		$this->layout = 'login3';

		$error_msg = "";
		$this->set('main_title', 'NASログ管理画面2');
		$this->set('sub_title', '検索');

		$condition = array();
		$id = $this->Common->getPost($this, 'Naslog2', 'id');
		$logintime1 = $this->Common->getPost($this, 'Naslog2', 'logintime1');
		$logintime2 = $this->Common->getPost($this, 'Naslog2', 'logintime2');
		$username = $this->Common->getPost($this, 'Naslog2', 'username');
//debug($logintime1);
//debug($logintime2);
		$submit = $this->Common->getPost($this, 'Naslog2', 'submit');
		if($submit == "クリア"){
//debug($submit);
			$id=$logintime1=$logintime2=$username=$submit="";
		}

		$sql = "TRUNCATE TABLE `naslog2`";
		$this->Naslog2->query($sql);

		//$data = $this->Naslog->find('all', array('order' => array('id'=>'asc')));
		$data = $this->Naslog->find('all', array('order'=>['id'=>'asc']));
//debug($data);
//exit();
		for($i=0; $i<count($data); $i++){
			$uname = $data[$i]['Naslog']['username'];
			if($data[$i]['Naslog']['loginout'] == 0){
				$logintime = $data[$i]['Naslog']['logtime'];
				$n = 0;
//debug($username);
//exit();
				for($j=0; $j<100; $j++){
					if(!isset($data[$i+$j]['Naslog']['username']))
						continue;
					
					if(($uname == $data[$i+$j]['Naslog']['username']) and
							($data[$i + $j]['Naslog']['loginout'] == 1)){
						$this->save_naslog2($data[$i + $j]['Naslog'], $logintime);
						break;
					}elseif(($uname == $data[$i+$j]['Naslog']['username']) and
							($data[$i + $j]['Naslog']['loginout'] == 01)){
						$logintime = $data[$i+$j]['Naslog']['logtime'];
						$n = $j;
					}
				}

				if($j < 100){
					$i = $i + $n;
				}
			}
		}

		//id	username	logintime	logouttime	ip_address
		if($id)
			$condition = array_merge_recursive($condition, array("id" => $id));

		if($logintime1 and $logintime2)
			$condition = array_merge_recursive($condition, array('logintime BETWEEN ? AND ?' => array($logintime1, $logintime2)));

		if($username)
			$condition = array_merge_recursive($condition, array( "username like" => '%'.$username.'%'));

//debug($condition);
//debug($logintime1);
		$searchword = array(
					 "id" => urlencode($id),
				     "logintime1" => urlencode($logintime1),
				     "logintime2" => urlencode($logintime2),
				     "username" => urlencode($username),
		);

//debug($condition);
		$this->paginate = array(
			'Naslog2' => array(
				'page' => 1,
				'limit' => 50,
				'order' => array('id'=>'desc'), 		// desc
				'conditions' => $condition, 
			), 
		);
		$data = $this->paginate('Naslog2');
		$this->set('data', $data);
//debug($data);
//exit();

		$this->set('searchword', $searchword);
		$this->set('error_msg', $error_msg);
//debug($data);
	
	
	}

	private function save_naslog2($data, $logintime){
//debug($data);
		//$data1 = $data;
		$data1['id'] = null;
		$data1['username'] = $data['username'];
		$data1['logintime'] = $logintime;
		$data1['logouttime'] = $data['logtime'];
		$data1['ip_address'] = $data['ip_address'];
		$data1['useragent'] = $data['useragent'];

		$data1['pc_name'] = $this->User->field('pc_name', array('username' => $data['username']));
		$data1['pcuser_name'] = $this->User->field('pcuser_name', array('username' => $data['username']));
		$data1['mac_address'] = $this->User->field('mac_address', array('username' => $data['username']));

		$this->Naslog2->save($data1);
		return true;

	}

	//  http://p7.inabous.net/inabou/nas2/download/
	public function download(){
		$this->autoRender = false;	//View File なし
		
		$zip_tmp_path = WWW_ROOT."files/nas/";
		$zip_name = "NAS.xlsx";
		//ダウンロード
		header('Content-Type: application/force-download;');
		header('Content-Length: '.filesize($zip_tmp_path.$zip_name));
		header('Content-Disposition: attachment; filename="'.$zip_name.'"');
		readfile($zip_tmp_path.$zip_name);
	}

	//  https://p7.inabous.net/inabou/nas2/get_login_time/yoshikura/kayoken2/
	public function get_login_time($username="", $password="", $mac_address="", $pc_name="", $pcuser_name=""){
		$this->autoRender = false;	//View File なし
		$data = array();
		$error_msg = "";
		
		if($username= ""){
			return;
		}
		
		$conditions = array('username' => $username);
		$order = 'id DESC';
		$logtime = $this->Naslog->field('logtime', $conditions, $order);
		if(strlen($logtime) > 0)
			echo base64_encode($logtime);
		else
			return;
	
	}

	// http://localhost:81/inabou/nas2/login/yoshikura/kayoken2/040E3C36AEC4/JPH049CBC2/YOSHIKURA/
	// http://localhost:81/inabou/nas2/login/yoshikura/kayoken2/abc/JPH049CBC2/YOSHIKURA/

	// https://p7.inabous.net/inabou/nas2/login/yoshikura/kayoken2/040E3C36AEC4/JPC0007/YOSHIKURA/
	// https://p7.inabous.net/inabou/nas2/login/yoshikura/kayoken2/abcdefghijkl/JPC0007/YOSHIKURA/

	function send_mail($data, $data2){
		//$this->autoRender = false;	//View File なし
		$data1=$data['User'];
//debug($data1);
//debug($data2);
//exit();

		$to = $data1['email'];
		if(strstr($to, "morikawa@inabou.co.jp")){
			return;
		}


		$to_name = $data1['name1']." ".$data1['name2'];
		$mac_address1 = $data1['mac_address'];
		$pc_name1 = $data1['pc_name'];
		$pcuser_name1 = $data1['pcuser_name'];

		$mac_address = $data2['mac_address'];
		$pc_name = $data2['pc_name'];
		$pcuser_name = $data2['pcuser_name'];
		$version = $data2['version'];

		$from = "admin@inabous.net";
		$from_name = "システム管理者";

		$cc = "admin@inabous.net";		//"yoshikura@inabous.net";	//"nakanishi@inabou.co.jp"
		$bcc = "yoshikura@inabous.net";		//"yoshikura229@icloud.com";		//"yoshikura3@gmail.com";
//debug($to);

		$subject = "不正ログイン";
		//$mailbody = $to."\r\n".$to_name."様\r\n";
		$mailbody = "不正ログインがありました\r\n";
		$mailbody .= "PC名：".$pc_name."  前：".$pc_name1."\r\n";
		$mailbody .= "ユーザ名：".$pcuser_name."  前：".$pcuser_name1."\r\n";
		$mailbody .= "MACアドレス：".$mac_address."  前：".$mac_address1."\r\n";

		$mailbody .= "\r\nNASバージョン：".$version."\r\n";
		
		$mailbody .= "\r\nシステム管理者<admin@inabous.net>\r\n";
//debug($to);
//debug($mailbody);
		$return_flag = $this->Common->cake_sendmail($from, $from_name, $to, $to_name, $subject, $mailbody, $cc, $bcc);
//debug($return_flag);
//exit();
	}

/**************************************************************************************************/
	public function logintotal(){
		$this->layout = 'login3';
		$this->set('main_title', 'NASログ3(月毎)');
		$this->set('sub_title', '検索');

		$a = $this->Common->GetModelAll("Naslog2", "logintime");
//debug($a);
		$logintime1 = date("Y-m-d", strtotime($a[0]));
		$logintime2 = date("Y-m-d", strtotime($a[count($a)-1]));

//debug($logintime1);
//debug($logintime2);
//exit();
		//$logintime1 = date("Y-m-d", strtotime($logintime2." -1 year  +1 day"));

		$this->set('logintime1', 	$logintime1);
		$this->set('logintime2',	$logintime2);
		$daydiff = (strtotime($logintime2)-strtotime($logintime1))/(3600*24);
//debug($logintime1);
//debug($logintime2);
//debug($daydiff);
//exit();

		$colspan = $daydiff;	//intval(date("m", strtotime($logintime2))) + 3+12;

//debug($logintime1);
//		$username = $this->Common->getPost($this, 'Naslog2', 'username');
//		$use_section = $this->Common->getPost($this, 'Naslog2', 'use_section');
//		$loginout = $this->Common->getPost($this, 'Naslog2', 'loginout');

		/* pagenation引数取得 */
//		$page = $this->Common->getPost($this, 'Naslog2', 'page');
//		$direction = $this->Common->getPost($this, 'Naslog2', 'direction');
//		$sort = $this->Common->getPost($this, 'Naslog2', 'sort');

		/* 検索単語に基づき引数作成 */
//		$searchword = array();
//		$searchword = array("logintime1" => urlencode($logintime1), "logintime2" => urlencode($logintime2));

		$conditions = array();	//array('logintime  BETWEEN ? AND ?' => array($logintime1, $logintime2));
//debug($colspan);

		$data = $this->Naslog2->find('all', array(
			'fields' => array('username', 
					"count(`id`) as total",
					"DATE_FORMAT(logintime, '%Y%m%d') as dates"
					),
			'group' => array("DATE_FORMAT(logintime, '%Y%m%d')", "username"),
			'order' => array('id'), 		// desc
			'conditions' => $conditions,
			));
//debug($data);
//exit();

		$data1 = $this->Naslog2->find('all', array(
			'fields' => array('username'),
			'group' => array("username"),
			'order' => array('username'), 		// desc
			'conditions' => $conditions,
			));
		for($i=0; $i<count($data1); $i++){
			$rows1[$i] = $data1[$i]['Naslog2']['username'];
			$rows2[$i] = $this->User->field("name1", array('username' => $data1[$i]['Naslog2']['username']));
			$rows3[$i] = $this->User->field("name2", array('username' => $data1[$i]['Naslog2']['username']));
		}
//debug($rows1);
//debug($rows2);
//debug($rows3);

		$data2 = $this->Naslog2->find('all', array(
			'fields' => array("DATE_FORMAT(logintime, '%Y%m%d') as dates"),
			'group' => array("DATE_FORMAT(logintime, '%Y%m%d')"),
			'order' => array("DATE_FORMAT(logintime, '%Y%m%d')"), 		// desc
			'conditions' => $conditions,
			));

//debug($data2);
		for($i=0; $i<count($data2); $i++){
			$columns[$i] = $data2[$i][0]['dates'];
		}
//debug($columns);
//exit();
		for($n=0; $n<count($data); $n++){
//debug($data[$n]['Naslog2']['username']);
//debug($data[$n][0]['dates']);
			$found = 0;
			for($i=0; $i<count($rows1); $i++){
				for($j=0; $j<count($columns); $j++){
					if($rows1[$i] == $data[$n]['Naslog2']['username']){
						if($columns[$j] == $data[$n][0]['dates']){
//debug("*[".$i."][".$j."]");
							if(!isset($data3[$i][$j+2])){
								$data3[$i]['username'] = $rows1[$i];
								$data3[$i]['user'] = $rows2[$i];
								$data3[$i][$j+2] = 1;	//$data[$n][0]['total'];
								$found = 1;
								break;
							}elseif($data3[$i][$j+2] == 0){
								$data3[$i][0] = $rows1[$i];
								$data3[$i][1] = $rows2[$i];
								$data3[$i][$j+2] = 1;	//$data[$n][0]['total']."/".$data[$n][0]['dates'];
								$found = 1;
								break;
							}else{
								debug("エラー[".$i."][".$j."]"); exit();
							}
						}
					}
					$found = 0;
				}
				if($found == 1){
					$found = 0;
					break;
				}
			}
		}

//debug($data3);
//exit();
		if(!empty($this->data)){
			$colspan = 12;
			if(isset($this->data['excel'])){
//debug($this->data);
//exit();
				/***********************************/
				$this->search_export($data3, $rows1, $rows2, $columns);
				/***********************************/
			}
		}

		/* ページネーションの作成 *///debug($conditions);
		$this->paginate = array(
			'Naslog2' => array(
				'fields' => array(),
				'group' => array(),
				'page' => 1,
				'limit' => 100,
				'order' => array('id'), 		// desc
				'conditions' => array(), 
			), 
		);
		$this->data = $this->paginate('Naslog2');
		$this->data = $data3;
		$this->set('data', 	$this->data);
//debug($this->data);
		$colspan = 12;	//intval(date("m", strtotime($logintime2))) + 3+12;
		$this->set('colspan', $colspan);
		$this->set('columns', $columns);
		$this->set('rows1', $rows1);
		$this->set('rows2', $rows2);
//exit();
	}


	function search_export($data, $rows1, $rows2, $columns){
		$this->autoRender = false;	//View File なし
//debug($data);
//debug($rows1);
//debug($rows2);
//debug($columns);
//exit();
		$excel_file0 = "login.xlsx";
		$xcellFile0 = $this->Common->ConvPath( WWW_ROOT."files/login/ORG/".$excel_file0);
		if(file_exists($xcellFile0) == false){
			debug("No exists ExcelFile:".$xcellFile0);
			exit();
		}
//debug($xcellFile0);
		//$excel_file = date("YmdHis")."_".$excel_file0;
		$excel_file = date("YmdHi")."_".$excel_file0;

		$xcellFile = $this->Common->ConvPath( WWW_ROOT."files/login/".$excel_file);
		if(file_exists($xcellFile)){
			unlink($xcellFile);
		}
		copy($xcellFile0, $xcellFile);
//debug($xcellFile);


		//$book = new PHPExcel();
		$book = PHPExcel_IOFactory::load($xcellFile);
//exit();

//debug($log);
		$data_count = count($data)-1;
//debug($data_count);
//debug($data);
//exit();

		$sh=0;
		//for($sh=0; $sh<5; $sh++){

			// シートの設定を行う
			$book->setActiveSheetIndex($sh);
			$sheet = $book->getActiveSheet();
//exit();


			$colspan = count($columns);
			//-----------------------------------------------
			$sheet->setCellValueByColumnAndRow( 0, 1, "連番");
			$sheet->setCellValueByColumnAndRow( 1, 1, "userid");
			$sheet->setCellValueByColumnAndRow( 2, 1, "利用者");
			for($j=0; $j<$colspan; $j++){
				$sheet->setCellValueByColumnAndRow( 3+$j, 1,  substr($columns[$j], -4));
			}
			$sheet->setCellValueByColumnAndRow( $colspan+3, 1, "合計");
			//-----------------------------------------------
//exit();
			$sub_total = 0;
			for($i=0; $i<count($data); $i++){
				// セルに値をセットする
				//$sheet->setCellValueByColumnAndRow( 0, $i + 2,  $i+1 );
				$sheet->setCellValueByColumnAndRow( 0, $i + 2,  $i+1 );
				$sheet->setCellValueByColumnAndRow( 1, $i + 2,  $rows1[$i] );
				$sheet->setCellValueByColumnAndRow( 2, $i + 2,  $rows2[$i] );
				$sub_total = 0;

				for($j=0; $j<$colspan; $j++){
					if(isset($data[$i][$j+2])){
						$sheet->setCellValueByColumnAndRow( 3+$j, $i + 2,  $data[$i][$j+2]);
						$sub_total += $data[$i][$j+2];
					}else{
						$sheet->setCellValueByColumnAndRow( 3+$j, $i + 2,  0);
						//$sub_total += 0;
					}
				}
				$sheet->setCellValueByColumnAndRow( $colspan+3, $i + 2, $sub_total );
//break;
			}
			
			$sheet->setCellValueByColumnAndRow( 0, $i + 2,  "" );
			$sheet->setCellValueByColumnAndRow( 1, $i + 2,  "" );
			$sheet->setCellValueByColumnAndRow( 2, $i + 2,  "合計" );
			/*
			for($j=0; $j<$colspan; $j++){
				$sheet->setCellValueByColumnAndRow( 3+$j, $i + 2,  $data['Trafficfee']['m_total'][$j] );
			}
			$sheet->setCellValueByColumnAndRow( $colspan+3, $i + 2, $data['Trafficfee']['m_total'][$j] );
			*/
			//-----------------------------------------------
		
		//}//endfor $sh
		// Excel2007形式で保存する
		$writer = PHPExcel_IOFactory::createWriter($book, 'Excel2007');
		$writer->save($xcellFile);

	// メモリの解放
		$book->disconnectWorksheets();
		unset($book);
//exit();
		// ファイルのダウンロード
		$dl_file = $excel_file;
		header('Content-Type: application/force-download');
		header('Content-Length: '.filesize($xcellFile));
		header('Content-Disposition: attachment; filename="'.mb_convert_encoding($dl_file, 'SJIS-win', 'UTF-8').'"');
		readfile($xcellFile);
		//exit();
	
		//$this->redirect(array('controller'=>'invoice','action'=>'search'));
		
	}

//	http://p7.inabous.net/inabou/nas2/message/
	function message($username="yoshikura", $password="kayoken2"){
		$this->autoRender = false;	//View File なし
		
		$fields = array();	//array('category', 'name1', 'name2', 'id');
		$conditions = array('username' => $username, 'password2' => $password);
		$data = $this->User->find('first', array('fields' => $fields, 'conditions' => $conditions));
		if(count($data)){
			echo base64_encode($data['User']['name1']." ".$data['User']['name2']." 様　正常接続しています。");
		}else{
			echo base64_encode("ユーザー名が不明：".$username);
		}
	}



}