<?php
//	http://localhost:81/inabou/admin/
//  http://p7.inabous.net/inabou/admin/

// Excel出力用ライブラリ
if(file_exists('D:\xampp\htdocs\vendor\autoload.php'))
	require 'D:\xampp\htdocs\vendor\autoload.php';
else
	require '/home/enzbaoev/public_html/p7/vendor/autoload.php';

//use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx as Writer;
use PhpOffice\PhpSpreadsheet\Reader\Xlsx as Reader;
use PhpOffice\PhpSpreadsheet\RichText\RichText as RichText; //RichTextAPIを使用
use PhpOffice\PhpSpreadsheet\Style;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;

App::uses('AppController', 'Controller');
App::import('Vendor', 'util/common');

class AdminController extends AppController {
	public $name = 'Admin';
	public $uses = array('Car', 'User');		//, 'User2'
	public $layout = 'admin';
	public $helpers = array('Html', 'Common');		//'Common', 'Html', , 'QrCode'
	public $components = array('Common', 'Auth');		//'Auth' 

	public $_dir = "/inabou/";
	public $_url = "";
	public $_path = WWW_ROOT;

	public function beforeFilter(){
		//parent::beforeFilter();
		//$this->Auth->allow();
		date_default_timezone_set('Asia/Tokyo');

		$this->_dir = "/inabou/";
		$this->set('_dir', $this->_dir);
		
		$this->_url = FULL_BASE_URL.$this->_dir;
		$this->set('_url', $this->_url);

		$this->_path = WWW_ROOT;
		$this->set('_path', $this->_path);

		$this->set('_store_id', $this->_store_id);

		$main_title = "メニュー管理";
		$this->set('main_title', $main_title);
	}

	public function index($username=""){
		$this->redirect(array('controller' => 'admin', 'action' => 'users', $username));
	}

	public function users($username= "", $mode=0){
//debug($this->Auth->user());
//exit();
		$this->set('main_title', "ユーザー管理");
		$error_msg = "";

//``id`,`username`,`password`,`category`,`name1`,`name2`,
// `kana1`,`kana2`,`email`,`role`,`accessed`,`modified`,`is_deleted`,
// `ip_address`,`password2`,`birthday`,`entry_date`,`tel`,
// `one_time_key`,`mailed`,`one_time_key2`,`received`,`initial`,`division`,
// `pc_data`
		$search = $this->Common->getPost($this, 'User', 'search');
		$id = $this->Common->getPost($this, 'User', 'id');
		$username = $this->Common->getPost($this, 'User', 'username');
		$category = $this->Common->getPost($this, 'User', 'category');
		$name1 = $this->Common->getPost($this, 'User', 'name1');
		$name2 = $this->Common->getPost($this, 'User', 'name2');
		$email = $this->Common->getPost($this, 'User', 'email');
		$password2 = $this->Common->getPost($this, 'User', 'password2');

//debug($category);
//debug($this->request->data);

		$conditions = array();
		if($id)
			$conditions = array_merge_recursive($conditions, array("id" => $id));
		if($username)
			$conditions = array_merge_recursive($conditions, array("username LIKE" => '%'.$username.'%'));
		if($category)
			$conditions = array_merge_recursive($conditions, array("category" => $category));
		if($name1)
			$conditions = array_merge_recursive($conditions, array("name1 LIKE" => '%'.$name1.'%'));
		if($name2)
			$conditions = array_merge_recursive($conditions, array("name2 LIKE" => '%'.$name2.'%'));
		if($password2)
			$conditions = array_merge_recursive($conditions, array("password2 LIKE" => '%'.$password2.'%'));

		$this->paginate = array(
			'User' => array(
				'page' => 1,
				'limit' => 40,
				'order' => array('id'), 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('User');
		$this->set('data', $data);
		$this->set('search', $search);
		$this->set('error_msg', $error_msg);

//debug($this->Auth->user());
		$user0 = $this->Auth->User();
		$this->set('login_id', $user0['id']);

	}

	public function user_edit($id = 0){
		$this->set('main_title', "ユーザ管理・編集");
		$this->set('sub_title', "ユーザ管理・編集");
		$error_msg = "";

		if($this->request->data){
//debug($this->request->data);
			$data2 = $this->request->data['User'];
//debug($data2);
			if($data2['id'] and $this->request->data['submit'] == "更新"){
				$data2['password'] = sha1(Configure::read('Security.salt').$data2['password2']);
				$this->User->save($data2);
			}elseif($data2['id'] and $this->request->data['submit'] == "削除"){
				$this->User->id = $data2['id'];
				$this->User->delete($this->User->id);
				$this->redirect(array('controller' => 'admin', 'action' => 'users'));
			}
//exit();
			$id =  $data2['id'];
		}

		$data = $this->User->find('first', array('conditions' => array("id" => $id) ));
		
		$this->set('data', $data['User']);
		$this->set('error_msg', $error_msg);
	}

	public function user_new(){
		$this->set('main_title', "ユーザ管理・編集");
		$this->set('sub_title', "ユーザ管理・新規");
		$error_msg = "";

		if($this->request->data){
//debug($this->request->data);
//exit();
			$data2 = $this->request->data['User'];
			if($this->request->data['submit'] == "新規"){
				$data2['password'] = sha1(Configure::read('Security.salt').$data2['password2']);
			
				$max = $this->User->find('first', array("fields" => "MAX(id) as max_id"));
				$data2['id'] = $max[0]['max_id'] + 1;
//debug($data2['id']);
				$this->User->save($data2);
				$this->redirect(array('controller' => 'admin', 'action' => 'user_edit', $data2['id']));
			}
			exit();
		}
		$this->set('error_msg', $error_msg);
	}





	public function cars($username= "", $mode=0){
//debug($this->Auth->user());
//exit();
		$this->set('main_title', "車両管理");
		$error_msg = "";

//``id`,`number_plate`,`owner`,`not_use`
		$search = $this->Common->getPost($this, 'Car', 'search');
		$id = $this->Common->getPost($this, 'Car', 'id');
		$number_plate = $this->Common->getPost($this, 'Car', 'number_plate');
		$owner = $this->Common->getPost($this, 'Car', 'owner');
		$not_use = strval( $this->Common->getPost($this, 'Car', 'not_use'));

		if($this->request->data){
//debug($this->request->data);
		}
		$conditions = array();
		if($id)
			$conditions = array_merge_recursive($conditions, array("id" => $id));
		if($number_plate)
			$conditions = array_merge_recursive($conditions, array("number_plate LIKE" => '%'.$number_plate.'%'));
		if($owner)
			$conditions = array_merge_recursive($conditions, array("owner" => $owner));
		if(strlen($not_use) > 0)
			$conditions = array_merge_recursive($conditions, array("not_use LIKE" => $not_use));
//debug($conditions);
		$this->paginate = array(
			'Car' => array(
				'page' => 1,
				'limit' => 40,
				'order' => array('id'), 		// desc
				'conditions' => $conditions, 
			), 
		);
		$data = $this->paginate('Car');
		$this->set('data', $data);
		$this->set('search', $search);
		$this->set('error_msg', $error_msg);

//debug($this->Auth->user());
		$user0 = $this->Auth->User();
		$this->set('login_id', $user0['id']);

	}


	public function car_edit($id = 0){
		$this->layout = 'admin';

		$this->set('main_title', "車両管理・編集");
		$this->set('sub_title', "車両管理・編集");
		$error_msg = "";

		if($this->request->data){
//debug($this->request->data);
			$data2 = $this->request->data['Car'];
//debug($data2);
			if($data2['id'] and $this->request->data['submit'] == "更新"){
				$this->Car->save($data2);
			}elseif($data2['id'] and $this->request->data['submit'] == "削除"){
				$this->Car->id = $data2['id'];
				$this->Car->delete($this->Car->id);
				$this->redirect(array('controller' => 'admin', 'action' => 'cars'));
			}
//exit();
			$id =  $data2['id'];
		}

		$data = $this->Car->find('first', array('conditions' => array("id" => $id) ));
		
		$this->set('data', $data['Car']);
		$this->set('error_msg', $error_msg);
	}


	public function car_new(){
		$this->set('main_title', "車両管理・編集");
		$this->set('sub_title', "車両管理・新規");
		$error_msg = "";

		if($this->request->data){
//debug($this->request->data);
//exit();
			$data2 = $this->request->data['Car'];
			if($this->request->data['submit'] == "新規"){
				$data2['password'] = sha1(Configure::read('Security.salt').$data2['password2']);
			
				$max = $this->Car->find('first', array("fields" => "MAX(id) as max_id"));
				$data2['id'] = $max[0]['max_id'] + 1;
//debug($data2['id']);
				$this->Car->save($data2);
				$this->redirect(array('controller' => 'admin', 'action' => 'car_edit', $data2['id']));
			}
			exit();
		}
		$this->set('error_msg', $error_msg);
	}
















}
